package io.fabric8.openshift.api.model.hive.gcp.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlatformStatusFluent<A extends PlatformStatusFluent<A>> extends BaseFluent<A>{
  public PlatformStatusFluent() {
  }
  
  public PlatformStatusFluent(PlatformStatus instance) {
    this.copyInstance(instance);
  }
  private PrivateServiceConnectStatusBuilder privateServiceConnect;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PlatformStatus instance) {
    instance = (instance != null ? instance : new PlatformStatus());
    if (instance != null) {
          this.withPrivateServiceConnect(instance.getPrivateServiceConnect());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public PrivateServiceConnectStatus buildPrivateServiceConnect() {
    return this.privateServiceConnect != null ? this.privateServiceConnect.build() : null;
  }
  
  public A withPrivateServiceConnect(PrivateServiceConnectStatus privateServiceConnect) {
    this._visitables.remove("privateServiceConnect");
    if (privateServiceConnect != null) {
        this.privateServiceConnect = new PrivateServiceConnectStatusBuilder(privateServiceConnect);
        this._visitables.get("privateServiceConnect").add(this.privateServiceConnect);
    } else {
        this.privateServiceConnect = null;
        this._visitables.get("privateServiceConnect").remove(this.privateServiceConnect);
    }
    return (A) this;
  }
  
  public boolean hasPrivateServiceConnect() {
    return this.privateServiceConnect != null;
  }
  
  public A withNewPrivateServiceConnect(String endpoint,String endpointAddress,String serviceAttachment,String serviceAttachmentFirewall,String serviceAttachmentSubnet) {
    return (A)withPrivateServiceConnect(new PrivateServiceConnectStatus(endpoint, endpointAddress, serviceAttachment, serviceAttachmentFirewall, serviceAttachmentSubnet));
  }
  
  public PrivateServiceConnectNested<A> withNewPrivateServiceConnect() {
    return new PrivateServiceConnectNested(null);
  }
  
  public PrivateServiceConnectNested<A> withNewPrivateServiceConnectLike(PrivateServiceConnectStatus item) {
    return new PrivateServiceConnectNested(item);
  }
  
  public PrivateServiceConnectNested<A> editPrivateServiceConnect() {
    return withNewPrivateServiceConnectLike(java.util.Optional.ofNullable(buildPrivateServiceConnect()).orElse(null));
  }
  
  public PrivateServiceConnectNested<A> editOrNewPrivateServiceConnect() {
    return withNewPrivateServiceConnectLike(java.util.Optional.ofNullable(buildPrivateServiceConnect()).orElse(new PrivateServiceConnectStatusBuilder().build()));
  }
  
  public PrivateServiceConnectNested<A> editOrNewPrivateServiceConnectLike(PrivateServiceConnectStatus item) {
    return withNewPrivateServiceConnectLike(java.util.Optional.ofNullable(buildPrivateServiceConnect()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformStatusFluent that = (PlatformStatusFluent) o;
    if (!java.util.Objects.equals(privateServiceConnect, that.privateServiceConnect)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(privateServiceConnect,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (privateServiceConnect != null) { sb.append("privateServiceConnect:"); sb.append(privateServiceConnect + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PrivateServiceConnectNested<N> extends PrivateServiceConnectStatusFluent<PrivateServiceConnectNested<N>> implements Nested<N>{
    PrivateServiceConnectNested(PrivateServiceConnectStatus item) {
      this.builder = new PrivateServiceConnectStatusBuilder(this, item);
    }
    PrivateServiceConnectStatusBuilder builder;
    
    public N and() {
      return (N) PlatformStatusFluent.this.withPrivateServiceConnect(builder.build());
    }
    
    public N endPrivateServiceConnect() {
      return and();
    }
    
  
  }

}