package io.fabric8.openshift.api.model.hive.gcp.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PrivateServiceConnectStatusFluent<A extends PrivateServiceConnectStatusFluent<A>> extends BaseFluent<A>{
  public PrivateServiceConnectStatusFluent() {
  }
  
  public PrivateServiceConnectStatusFluent(PrivateServiceConnectStatus instance) {
    this.copyInstance(instance);
  }
  private String endpoint;
  private String endpointAddress;
  private String serviceAttachment;
  private String serviceAttachmentFirewall;
  private String serviceAttachmentSubnet;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PrivateServiceConnectStatus instance) {
    instance = (instance != null ? instance : new PrivateServiceConnectStatus());
    if (instance != null) {
          this.withEndpoint(instance.getEndpoint());
          this.withEndpointAddress(instance.getEndpointAddress());
          this.withServiceAttachment(instance.getServiceAttachment());
          this.withServiceAttachmentFirewall(instance.getServiceAttachmentFirewall());
          this.withServiceAttachmentSubnet(instance.getServiceAttachmentSubnet());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getEndpoint() {
    return this.endpoint;
  }
  
  public A withEndpoint(String endpoint) {
    this.endpoint = endpoint;
    return (A) this;
  }
  
  public boolean hasEndpoint() {
    return this.endpoint != null;
  }
  
  public String getEndpointAddress() {
    return this.endpointAddress;
  }
  
  public A withEndpointAddress(String endpointAddress) {
    this.endpointAddress = endpointAddress;
    return (A) this;
  }
  
  public boolean hasEndpointAddress() {
    return this.endpointAddress != null;
  }
  
  public String getServiceAttachment() {
    return this.serviceAttachment;
  }
  
  public A withServiceAttachment(String serviceAttachment) {
    this.serviceAttachment = serviceAttachment;
    return (A) this;
  }
  
  public boolean hasServiceAttachment() {
    return this.serviceAttachment != null;
  }
  
  public String getServiceAttachmentFirewall() {
    return this.serviceAttachmentFirewall;
  }
  
  public A withServiceAttachmentFirewall(String serviceAttachmentFirewall) {
    this.serviceAttachmentFirewall = serviceAttachmentFirewall;
    return (A) this;
  }
  
  public boolean hasServiceAttachmentFirewall() {
    return this.serviceAttachmentFirewall != null;
  }
  
  public String getServiceAttachmentSubnet() {
    return this.serviceAttachmentSubnet;
  }
  
  public A withServiceAttachmentSubnet(String serviceAttachmentSubnet) {
    this.serviceAttachmentSubnet = serviceAttachmentSubnet;
    return (A) this;
  }
  
  public boolean hasServiceAttachmentSubnet() {
    return this.serviceAttachmentSubnet != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PrivateServiceConnectStatusFluent that = (PrivateServiceConnectStatusFluent) o;
    if (!java.util.Objects.equals(endpoint, that.endpoint)) return false;
    if (!java.util.Objects.equals(endpointAddress, that.endpointAddress)) return false;
    if (!java.util.Objects.equals(serviceAttachment, that.serviceAttachment)) return false;
    if (!java.util.Objects.equals(serviceAttachmentFirewall, that.serviceAttachmentFirewall)) return false;
    if (!java.util.Objects.equals(serviceAttachmentSubnet, that.serviceAttachmentSubnet)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(endpoint,  endpointAddress,  serviceAttachment,  serviceAttachmentFirewall,  serviceAttachmentSubnet,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (endpoint != null) { sb.append("endpoint:"); sb.append(endpoint + ","); }
    if (endpointAddress != null) { sb.append("endpointAddress:"); sb.append(endpointAddress + ","); }
    if (serviceAttachment != null) { sb.append("serviceAttachment:"); sb.append(serviceAttachment + ","); }
    if (serviceAttachmentFirewall != null) { sb.append("serviceAttachmentFirewall:"); sb.append(serviceAttachmentFirewall + ","); }
    if (serviceAttachmentSubnet != null) { sb.append("serviceAttachmentSubnet:"); sb.append(serviceAttachmentSubnet + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}