package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterDeploymentCustomizationBuilder extends ClusterDeploymentCustomizationFluent<ClusterDeploymentCustomizationBuilder> implements VisitableBuilder<ClusterDeploymentCustomization,ClusterDeploymentCustomizationBuilder>{
  public ClusterDeploymentCustomizationBuilder() {
    this(new ClusterDeploymentCustomization());
  }
  
  public ClusterDeploymentCustomizationBuilder(ClusterDeploymentCustomizationFluent<?> fluent) {
    this(fluent, new ClusterDeploymentCustomization());
  }
  
  public ClusterDeploymentCustomizationBuilder(ClusterDeploymentCustomizationFluent<?> fluent,ClusterDeploymentCustomization instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterDeploymentCustomizationBuilder(ClusterDeploymentCustomization instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterDeploymentCustomizationFluent<?> fluent;
  
  public ClusterDeploymentCustomization build() {
    ClusterDeploymentCustomization buildable = new ClusterDeploymentCustomization(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}