package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GCPPrivateServiceConnectInventoryFluent<A extends GCPPrivateServiceConnectInventoryFluent<A>> extends BaseFluent<A>{
  public GCPPrivateServiceConnectInventoryFluent() {
  }
  
  public GCPPrivateServiceConnectInventoryFluent(GCPPrivateServiceConnectInventory instance) {
    this.copyInstance(instance);
  }
  private String network;
  private ArrayList<GCPPrivateServiceConnectSubnetBuilder> subnets = new ArrayList<GCPPrivateServiceConnectSubnetBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GCPPrivateServiceConnectInventory instance) {
    instance = (instance != null ? instance : new GCPPrivateServiceConnectInventory());
    if (instance != null) {
          this.withNetwork(instance.getNetwork());
          this.withSubnets(instance.getSubnets());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getNetwork() {
    return this.network;
  }
  
  public A withNetwork(String network) {
    this.network = network;
    return (A) this;
  }
  
  public boolean hasNetwork() {
    return this.network != null;
  }
  
  public A addToSubnets(int index,GCPPrivateServiceConnectSubnet item) {
    if (this.subnets == null) {this.subnets = new ArrayList<GCPPrivateServiceConnectSubnetBuilder>();}
    GCPPrivateServiceConnectSubnetBuilder builder = new GCPPrivateServiceConnectSubnetBuilder(item);
    if (index < 0 || index >= subnets.size()) {
        _visitables.get("subnets").add(builder);
        subnets.add(builder);
    } else {
        _visitables.get("subnets").add(builder);
        subnets.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToSubnets(int index,GCPPrivateServiceConnectSubnet item) {
    if (this.subnets == null) {this.subnets = new ArrayList<GCPPrivateServiceConnectSubnetBuilder>();}
    GCPPrivateServiceConnectSubnetBuilder builder = new GCPPrivateServiceConnectSubnetBuilder(item);
    if (index < 0 || index >= subnets.size()) {
        _visitables.get("subnets").add(builder);
        subnets.add(builder);
    } else {
        _visitables.get("subnets").add(builder);
        subnets.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToSubnets(io.fabric8.openshift.api.model.hive.v1.GCPPrivateServiceConnectSubnet... items) {
    if (this.subnets == null) {this.subnets = new ArrayList<GCPPrivateServiceConnectSubnetBuilder>();}
    for (GCPPrivateServiceConnectSubnet item : items) {GCPPrivateServiceConnectSubnetBuilder builder = new GCPPrivateServiceConnectSubnetBuilder(item);_visitables.get("subnets").add(builder);this.subnets.add(builder);} return (A)this;
  }
  
  public A addAllToSubnets(Collection<GCPPrivateServiceConnectSubnet> items) {
    if (this.subnets == null) {this.subnets = new ArrayList<GCPPrivateServiceConnectSubnetBuilder>();}
    for (GCPPrivateServiceConnectSubnet item : items) {GCPPrivateServiceConnectSubnetBuilder builder = new GCPPrivateServiceConnectSubnetBuilder(item);_visitables.get("subnets").add(builder);this.subnets.add(builder);} return (A)this;
  }
  
  public A removeFromSubnets(io.fabric8.openshift.api.model.hive.v1.GCPPrivateServiceConnectSubnet... items) {
    if (this.subnets == null) return (A)this;
    for (GCPPrivateServiceConnectSubnet item : items) {GCPPrivateServiceConnectSubnetBuilder builder = new GCPPrivateServiceConnectSubnetBuilder(item);_visitables.get("subnets").remove(builder); this.subnets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSubnets(Collection<GCPPrivateServiceConnectSubnet> items) {
    if (this.subnets == null) return (A)this;
    for (GCPPrivateServiceConnectSubnet item : items) {GCPPrivateServiceConnectSubnetBuilder builder = new GCPPrivateServiceConnectSubnetBuilder(item);_visitables.get("subnets").remove(builder); this.subnets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSubnets(Predicate<GCPPrivateServiceConnectSubnetBuilder> predicate) {
    if (subnets == null) return (A) this;
    final Iterator<GCPPrivateServiceConnectSubnetBuilder> each = subnets.iterator();
    final List visitables = _visitables.get("subnets");
    while (each.hasNext()) {
      GCPPrivateServiceConnectSubnetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GCPPrivateServiceConnectSubnet> buildSubnets() {
    return this.subnets != null ? build(subnets) : null;
  }
  
  public GCPPrivateServiceConnectSubnet buildSubnet(int index) {
    return this.subnets.get(index).build();
  }
  
  public GCPPrivateServiceConnectSubnet buildFirstSubnet() {
    return this.subnets.get(0).build();
  }
  
  public GCPPrivateServiceConnectSubnet buildLastSubnet() {
    return this.subnets.get(subnets.size() - 1).build();
  }
  
  public GCPPrivateServiceConnectSubnet buildMatchingSubnet(Predicate<GCPPrivateServiceConnectSubnetBuilder> predicate) {
      for (GCPPrivateServiceConnectSubnetBuilder item : subnets) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSubnet(Predicate<GCPPrivateServiceConnectSubnetBuilder> predicate) {
      for (GCPPrivateServiceConnectSubnetBuilder item : subnets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSubnets(List<GCPPrivateServiceConnectSubnet> subnets) {
    if (this.subnets != null) {
      this._visitables.get("subnets").clear();
    }
    if (subnets != null) {
        this.subnets = new ArrayList();
        for (GCPPrivateServiceConnectSubnet item : subnets) {
          this.addToSubnets(item);
        }
    } else {
      this.subnets = null;
    }
    return (A) this;
  }
  
  public A withSubnets(io.fabric8.openshift.api.model.hive.v1.GCPPrivateServiceConnectSubnet... subnets) {
    if (this.subnets != null) {
        this.subnets.clear();
        _visitables.remove("subnets");
    }
    if (subnets != null) {
      for (GCPPrivateServiceConnectSubnet item : subnets) {
        this.addToSubnets(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSubnets() {
    return this.subnets != null && !this.subnets.isEmpty();
  }
  
  public A addNewSubnet(String region,String subnet) {
    return (A)addToSubnets(new GCPPrivateServiceConnectSubnet(region, subnet));
  }
  
  public SubnetsNested<A> addNewSubnet() {
    return new SubnetsNested(-1, null);
  }
  
  public SubnetsNested<A> addNewSubnetLike(GCPPrivateServiceConnectSubnet item) {
    return new SubnetsNested(-1, item);
  }
  
  public SubnetsNested<A> setNewSubnetLike(int index,GCPPrivateServiceConnectSubnet item) {
    return new SubnetsNested(index, item);
  }
  
  public SubnetsNested<A> editSubnet(int index) {
    if (subnets.size() <= index) throw new RuntimeException("Can't edit subnets. Index exceeds size.");
    return setNewSubnetLike(index, buildSubnet(index));
  }
  
  public SubnetsNested<A> editFirstSubnet() {
    if (subnets.size() == 0) throw new RuntimeException("Can't edit first subnets. The list is empty.");
    return setNewSubnetLike(0, buildSubnet(0));
  }
  
  public SubnetsNested<A> editLastSubnet() {
    int index = subnets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subnets. The list is empty.");
    return setNewSubnetLike(index, buildSubnet(index));
  }
  
  public SubnetsNested<A> editMatchingSubnet(Predicate<GCPPrivateServiceConnectSubnetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subnets.size();i++) { 
    if (predicate.test(subnets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subnets. No match found.");
    return setNewSubnetLike(index, buildSubnet(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GCPPrivateServiceConnectInventoryFluent that = (GCPPrivateServiceConnectInventoryFluent) o;
    if (!java.util.Objects.equals(network, that.network)) return false;
    if (!java.util.Objects.equals(subnets, that.subnets)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(network,  subnets,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (network != null) { sb.append("network:"); sb.append(network + ","); }
    if (subnets != null && !subnets.isEmpty()) { sb.append("subnets:"); sb.append(subnets + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SubnetsNested<N> extends GCPPrivateServiceConnectSubnetFluent<SubnetsNested<N>> implements Nested<N>{
    SubnetsNested(int index,GCPPrivateServiceConnectSubnet item) {
      this.index = index;
      this.builder = new GCPPrivateServiceConnectSubnetBuilder(this, item);
    }
    GCPPrivateServiceConnectSubnetBuilder builder;
    int index;
    
    public N and() {
      return (N) GCPPrivateServiceConnectInventoryFluent.this.setToSubnets(index,builder.build());
    }
    
    public N endSubnet() {
      return and();
    }
    
  
  }

}