package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.openshift.api.model.config.v1.IdentityProvider;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SyncIdentityProviderSpecFluent<A extends SyncIdentityProviderSpecFluent<A>> extends BaseFluent<A>{
  public SyncIdentityProviderSpecFluent() {
  }
  
  public SyncIdentityProviderSpecFluent(SyncIdentityProviderSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<LocalObjectReferenceBuilder> clusterDeploymentRefs = new ArrayList<LocalObjectReferenceBuilder>();
  private List<IdentityProvider> identityProviders = new ArrayList<IdentityProvider>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SyncIdentityProviderSpec instance) {
    instance = (instance != null ? instance : new SyncIdentityProviderSpec());
    if (instance != null) {
          this.withClusterDeploymentRefs(instance.getClusterDeploymentRefs());
          this.withIdentityProviders(instance.getIdentityProviders());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToClusterDeploymentRefs(int index,LocalObjectReference item) {
    if (this.clusterDeploymentRefs == null) {this.clusterDeploymentRefs = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= clusterDeploymentRefs.size()) {
        _visitables.get("clusterDeploymentRefs").add(builder);
        clusterDeploymentRefs.add(builder);
    } else {
        _visitables.get("clusterDeploymentRefs").add(builder);
        clusterDeploymentRefs.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToClusterDeploymentRefs(int index,LocalObjectReference item) {
    if (this.clusterDeploymentRefs == null) {this.clusterDeploymentRefs = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= clusterDeploymentRefs.size()) {
        _visitables.get("clusterDeploymentRefs").add(builder);
        clusterDeploymentRefs.add(builder);
    } else {
        _visitables.get("clusterDeploymentRefs").add(builder);
        clusterDeploymentRefs.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToClusterDeploymentRefs(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.clusterDeploymentRefs == null) {this.clusterDeploymentRefs = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("clusterDeploymentRefs").add(builder);this.clusterDeploymentRefs.add(builder);} return (A)this;
  }
  
  public A addAllToClusterDeploymentRefs(Collection<LocalObjectReference> items) {
    if (this.clusterDeploymentRefs == null) {this.clusterDeploymentRefs = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("clusterDeploymentRefs").add(builder);this.clusterDeploymentRefs.add(builder);} return (A)this;
  }
  
  public A removeFromClusterDeploymentRefs(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.clusterDeploymentRefs == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("clusterDeploymentRefs").remove(builder); this.clusterDeploymentRefs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromClusterDeploymentRefs(Collection<LocalObjectReference> items) {
    if (this.clusterDeploymentRefs == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("clusterDeploymentRefs").remove(builder); this.clusterDeploymentRefs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromClusterDeploymentRefs(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (clusterDeploymentRefs == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = clusterDeploymentRefs.iterator();
    final List visitables = _visitables.get("clusterDeploymentRefs");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LocalObjectReference> buildClusterDeploymentRefs() {
    return this.clusterDeploymentRefs != null ? build(clusterDeploymentRefs) : null;
  }
  
  public LocalObjectReference buildClusterDeploymentRef(int index) {
    return this.clusterDeploymentRefs.get(index).build();
  }
  
  public LocalObjectReference buildFirstClusterDeploymentRef() {
    return this.clusterDeploymentRefs.get(0).build();
  }
  
  public LocalObjectReference buildLastClusterDeploymentRef() {
    return this.clusterDeploymentRefs.get(clusterDeploymentRefs.size() - 1).build();
  }
  
  public LocalObjectReference buildMatchingClusterDeploymentRef(Predicate<LocalObjectReferenceBuilder> predicate) {
      for (LocalObjectReferenceBuilder item : clusterDeploymentRefs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingClusterDeploymentRef(Predicate<LocalObjectReferenceBuilder> predicate) {
      for (LocalObjectReferenceBuilder item : clusterDeploymentRefs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withClusterDeploymentRefs(List<LocalObjectReference> clusterDeploymentRefs) {
    if (this.clusterDeploymentRefs != null) {
      this._visitables.get("clusterDeploymentRefs").clear();
    }
    if (clusterDeploymentRefs != null) {
        this.clusterDeploymentRefs = new ArrayList();
        for (LocalObjectReference item : clusterDeploymentRefs) {
          this.addToClusterDeploymentRefs(item);
        }
    } else {
      this.clusterDeploymentRefs = null;
    }
    return (A) this;
  }
  
  public A withClusterDeploymentRefs(io.fabric8.kubernetes.api.model.LocalObjectReference... clusterDeploymentRefs) {
    if (this.clusterDeploymentRefs != null) {
        this.clusterDeploymentRefs.clear();
        _visitables.remove("clusterDeploymentRefs");
    }
    if (clusterDeploymentRefs != null) {
      for (LocalObjectReference item : clusterDeploymentRefs) {
        this.addToClusterDeploymentRefs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasClusterDeploymentRefs() {
    return this.clusterDeploymentRefs != null && !this.clusterDeploymentRefs.isEmpty();
  }
  
  public A addNewClusterDeploymentRef(String name) {
    return (A)addToClusterDeploymentRefs(new LocalObjectReference(name));
  }
  
  public ClusterDeploymentRefsNested<A> addNewClusterDeploymentRef() {
    return new ClusterDeploymentRefsNested(-1, null);
  }
  
  public ClusterDeploymentRefsNested<A> addNewClusterDeploymentRefLike(LocalObjectReference item) {
    return new ClusterDeploymentRefsNested(-1, item);
  }
  
  public ClusterDeploymentRefsNested<A> setNewClusterDeploymentRefLike(int index,LocalObjectReference item) {
    return new ClusterDeploymentRefsNested(index, item);
  }
  
  public ClusterDeploymentRefsNested<A> editClusterDeploymentRef(int index) {
    if (clusterDeploymentRefs.size() <= index) throw new RuntimeException("Can't edit clusterDeploymentRefs. Index exceeds size.");
    return setNewClusterDeploymentRefLike(index, buildClusterDeploymentRef(index));
  }
  
  public ClusterDeploymentRefsNested<A> editFirstClusterDeploymentRef() {
    if (clusterDeploymentRefs.size() == 0) throw new RuntimeException("Can't edit first clusterDeploymentRefs. The list is empty.");
    return setNewClusterDeploymentRefLike(0, buildClusterDeploymentRef(0));
  }
  
  public ClusterDeploymentRefsNested<A> editLastClusterDeploymentRef() {
    int index = clusterDeploymentRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterDeploymentRefs. The list is empty.");
    return setNewClusterDeploymentRefLike(index, buildClusterDeploymentRef(index));
  }
  
  public ClusterDeploymentRefsNested<A> editMatchingClusterDeploymentRef(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterDeploymentRefs.size();i++) { 
    if (predicate.test(clusterDeploymentRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterDeploymentRefs. No match found.");
    return setNewClusterDeploymentRefLike(index, buildClusterDeploymentRef(index));
  }
  
  public A addToIdentityProviders(int index,IdentityProvider item) {
    if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProvider>();}
    this.identityProviders.add(index, item);
    return (A)this;
  }
  
  public A setToIdentityProviders(int index,IdentityProvider item) {
    if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProvider>();}
    this.identityProviders.set(index, item); return (A)this;
  }
  
  public A addToIdentityProviders(io.fabric8.openshift.api.model.config.v1.IdentityProvider... items) {
    if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProvider>();}
    for (IdentityProvider item : items) {this.identityProviders.add(item);} return (A)this;
  }
  
  public A addAllToIdentityProviders(Collection<IdentityProvider> items) {
    if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProvider>();}
    for (IdentityProvider item : items) {this.identityProviders.add(item);} return (A)this;
  }
  
  public A removeFromIdentityProviders(io.fabric8.openshift.api.model.config.v1.IdentityProvider... items) {
    if (this.identityProviders == null) return (A)this;
    for (IdentityProvider item : items) { this.identityProviders.remove(item);} return (A)this;
  }
  
  public A removeAllFromIdentityProviders(Collection<IdentityProvider> items) {
    if (this.identityProviders == null) return (A)this;
    for (IdentityProvider item : items) { this.identityProviders.remove(item);} return (A)this;
  }
  
  public List<IdentityProvider> getIdentityProviders() {
    return this.identityProviders;
  }
  
  public IdentityProvider getIdentityProvider(int index) {
    return this.identityProviders.get(index);
  }
  
  public IdentityProvider getFirstIdentityProvider() {
    return this.identityProviders.get(0);
  }
  
  public IdentityProvider getLastIdentityProvider() {
    return this.identityProviders.get(identityProviders.size() - 1);
  }
  
  public IdentityProvider getMatchingIdentityProvider(Predicate<IdentityProvider> predicate) {
      for (IdentityProvider item : identityProviders) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingIdentityProvider(Predicate<IdentityProvider> predicate) {
      for (IdentityProvider item : identityProviders) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIdentityProviders(List<IdentityProvider> identityProviders) {
    if (identityProviders != null) {
        this.identityProviders = new ArrayList();
        for (IdentityProvider item : identityProviders) {
          this.addToIdentityProviders(item);
        }
    } else {
      this.identityProviders = null;
    }
    return (A) this;
  }
  
  public A withIdentityProviders(io.fabric8.openshift.api.model.config.v1.IdentityProvider... identityProviders) {
    if (this.identityProviders != null) {
        this.identityProviders.clear();
        _visitables.remove("identityProviders");
    }
    if (identityProviders != null) {
      for (IdentityProvider item : identityProviders) {
        this.addToIdentityProviders(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasIdentityProviders() {
    return this.identityProviders != null && !this.identityProviders.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SyncIdentityProviderSpecFluent that = (SyncIdentityProviderSpecFluent) o;
    if (!java.util.Objects.equals(clusterDeploymentRefs, that.clusterDeploymentRefs)) return false;
    if (!java.util.Objects.equals(identityProviders, that.identityProviders)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterDeploymentRefs,  identityProviders,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterDeploymentRefs != null && !clusterDeploymentRefs.isEmpty()) { sb.append("clusterDeploymentRefs:"); sb.append(clusterDeploymentRefs + ","); }
    if (identityProviders != null && !identityProviders.isEmpty()) { sb.append("identityProviders:"); sb.append(identityProviders + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterDeploymentRefsNested<N> extends LocalObjectReferenceFluent<ClusterDeploymentRefsNested<N>> implements Nested<N>{
    ClusterDeploymentRefsNested(int index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) SyncIdentityProviderSpecFluent.this.setToClusterDeploymentRefs(index,builder.build());
    }
    
    public N endClusterDeploymentRef() {
      return and();
    }
    
  
  }

}