/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.ClusterDeprovisionPlatform;
import io.fabric8.openshift.api.model.hive.v1.ClusterDeprovisionPlatformBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterDeprovisionPlatformFluent;
import io.fabric8.openshift.api.model.hive.v1.ClusterDeprovisionSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ClusterDeprovisionSpecFluent<A extends ClusterDeprovisionSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String baseDomain;
    private String clusterID;
    private String clusterName;
    private String infraID;
    private ClusterDeprovisionPlatformBuilder platform;

    public ClusterDeprovisionSpecFluent() {
    }

    public ClusterDeprovisionSpecFluent(ClusterDeprovisionSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ClusterDeprovisionPlatform buildPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    protected void copyInstance(ClusterDeprovisionSpec instance) {
        ClusterDeprovisionSpec clusterDeprovisionSpec = instance = instance != null ? instance : new ClusterDeprovisionSpec();
        if (instance != null) {
            this.withBaseDomain(instance.getBaseDomain());
            this.withClusterID(instance.getClusterID());
            this.withClusterName(instance.getClusterName());
            this.withInfraID(instance.getInfraID());
            this.withPlatform(instance.getPlatform());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PlatformNested<A> editOrNewPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(new ClusterDeprovisionPlatformBuilder().build()));
    }

    public PlatformNested<A> editOrNewPlatformLike(ClusterDeprovisionPlatform item) {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(item));
    }

    public PlatformNested<A> editPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterDeprovisionSpecFluent that = (ClusterDeprovisionSpecFluent)((Object)o);
        if (!Objects.equals(this.baseDomain, that.baseDomain)) {
            return false;
        }
        if (!Objects.equals(this.clusterID, that.clusterID)) {
            return false;
        }
        if (!Objects.equals(this.clusterName, that.clusterName)) {
            return false;
        }
        if (!Objects.equals(this.infraID, that.infraID)) {
            return false;
        }
        if (!Objects.equals((Object)this.platform, (Object)that.platform)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getBaseDomain() {
        return this.baseDomain;
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getInfraID() {
        return this.infraID;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBaseDomain() {
        return this.baseDomain != null;
    }

    public boolean hasClusterID() {
        return this.clusterID != null;
    }

    public boolean hasClusterName() {
        return this.clusterName != null;
    }

    public boolean hasInfraID() {
        return this.infraID != null;
    }

    public boolean hasPlatform() {
        return this.platform != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseDomain, this.clusterID, this.clusterName, this.infraID, this.platform, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseDomain != null) {
            sb.append("baseDomain:");
            sb.append(this.baseDomain);
            sb.append(",");
        }
        if (this.clusterID != null) {
            sb.append("clusterID:");
            sb.append(this.clusterID);
            sb.append(",");
        }
        if (this.clusterName != null) {
            sb.append("clusterName:");
            sb.append(this.clusterName);
            sb.append(",");
        }
        if (this.infraID != null) {
            sb.append("infraID:");
            sb.append(this.infraID);
            sb.append(",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append((Object)this.platform);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withBaseDomain(String baseDomain) {
        this.baseDomain = baseDomain;
        return (A)((Object)this);
    }

    public A withClusterID(String clusterID) {
        this.clusterID = clusterID;
        return (A)((Object)this);
    }

    public A withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return (A)((Object)this);
    }

    public A withInfraID(String infraID) {
        this.infraID = infraID;
        return (A)((Object)this);
    }

    public PlatformNested<A> withNewPlatform() {
        return new PlatformNested(null);
    }

    public PlatformNested<A> withNewPlatformLike(ClusterDeprovisionPlatform item) {
        return new PlatformNested(item);
    }

    public A withPlatform(ClusterDeprovisionPlatform platform) {
        this._visitables.remove((Object)"platform");
        if (platform != null) {
            this.platform = new ClusterDeprovisionPlatformBuilder(platform);
            this._visitables.get((Object)"platform").add(this.platform);
        } else {
            this.platform = null;
            this._visitables.get((Object)"platform").remove((Object)this.platform);
        }
        return (A)((Object)this);
    }

    public class PlatformNested<N>
    extends ClusterDeprovisionPlatformFluent<PlatformNested<N>>
    implements Nested<N> {
        ClusterDeprovisionPlatformBuilder builder;

        PlatformNested(ClusterDeprovisionPlatform item) {
            this.builder = new ClusterDeprovisionPlatformBuilder(this, item);
        }

        public N and() {
            return (N)ClusterDeprovisionSpecFluent.this.withPlatform(this.builder.build());
        }

        public N endPlatform() {
            return this.and();
        }
    }
}

