/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.FailedProvisionAWSConfig;
import io.fabric8.openshift.api.model.hive.v1.FailedProvisionAWSConfigBuilder;
import io.fabric8.openshift.api.model.hive.v1.FailedProvisionAWSConfigFluent;
import io.fabric8.openshift.api.model.hive.v1.FailedProvisionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class FailedProvisionConfigFluent<A extends FailedProvisionConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private FailedProvisionAWSConfigBuilder aws;
    private List<String> retryReasons = new ArrayList<String>();
    private Boolean skipGatherLogs;

    public FailedProvisionConfigFluent() {
    }

    public FailedProvisionConfigFluent(FailedProvisionConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToRetryReasons(Collection<String> items) {
        if (this.retryReasons == null) {
            this.retryReasons = new ArrayList<String>();
        }
        for (String item : items) {
            this.retryReasons.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToRetryReasons(String ... items) {
        if (this.retryReasons == null) {
            this.retryReasons = new ArrayList<String>();
        }
        for (String item : items) {
            this.retryReasons.add(item);
        }
        return (A)((Object)this);
    }

    public A addToRetryReasons(int index, String item) {
        if (this.retryReasons == null) {
            this.retryReasons = new ArrayList<String>();
        }
        this.retryReasons.add(index, item);
        return (A)((Object)this);
    }

    public FailedProvisionAWSConfig buildAws() {
        return this.aws != null ? this.aws.build() : null;
    }

    protected void copyInstance(FailedProvisionConfig instance) {
        FailedProvisionConfig failedProvisionConfig = instance = instance != null ? instance : new FailedProvisionConfig();
        if (instance != null) {
            this.withAws(instance.getAws());
            this.withRetryReasons(instance.getRetryReasons());
            this.withSkipGatherLogs(instance.getSkipGatherLogs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AwsNested<A> editAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(null));
    }

    public AwsNested<A> editOrNewAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(new FailedProvisionAWSConfigBuilder().build()));
    }

    public AwsNested<A> editOrNewAwsLike(FailedProvisionAWSConfig item) {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FailedProvisionConfigFluent that = (FailedProvisionConfigFluent)((Object)o);
        if (!Objects.equals((Object)this.aws, (Object)that.aws)) {
            return false;
        }
        if (!Objects.equals(this.retryReasons, that.retryReasons)) {
            return false;
        }
        if (!Objects.equals(this.skipGatherLogs, that.skipGatherLogs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstRetryReason() {
        return this.retryReasons.get(0);
    }

    public String getLastRetryReason() {
        return this.retryReasons.get(this.retryReasons.size() - 1);
    }

    public String getMatchingRetryReason(Predicate<String> predicate) {
        for (String item : this.retryReasons) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getRetryReason(int index) {
        return this.retryReasons.get(index);
    }

    public List<String> getRetryReasons() {
        return this.retryReasons;
    }

    public Boolean getSkipGatherLogs() {
        return this.skipGatherLogs;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAws() {
        return this.aws != null;
    }

    public boolean hasMatchingRetryReason(Predicate<String> predicate) {
        for (String item : this.retryReasons) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRetryReasons() {
        return this.retryReasons != null && !this.retryReasons.isEmpty();
    }

    public boolean hasSkipGatherLogs() {
        return this.skipGatherLogs != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aws, this.retryReasons, this.skipGatherLogs, this.additionalProperties});
    }

    public A removeAllFromRetryReasons(Collection<String> items) {
        if (this.retryReasons == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.retryReasons.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromRetryReasons(String ... items) {
        if (this.retryReasons == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.retryReasons.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToRetryReasons(int index, String item) {
        if (this.retryReasons == null) {
            this.retryReasons = new ArrayList<String>();
        }
        this.retryReasons.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aws != null) {
            sb.append("aws:");
            sb.append((Object)this.aws);
            sb.append(",");
        }
        if (this.retryReasons != null && !this.retryReasons.isEmpty()) {
            sb.append("retryReasons:");
            sb.append(this.retryReasons);
            sb.append(",");
        }
        if (this.skipGatherLogs != null) {
            sb.append("skipGatherLogs:");
            sb.append(this.skipGatherLogs);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAws(FailedProvisionAWSConfig aws) {
        this._visitables.remove((Object)"aws");
        if (aws != null) {
            this.aws = new FailedProvisionAWSConfigBuilder(aws);
            this._visitables.get((Object)"aws").add(this.aws);
        } else {
            this.aws = null;
            this._visitables.get((Object)"aws").remove((Object)this.aws);
        }
        return (A)((Object)this);
    }

    public AwsNested<A> withNewAws() {
        return new AwsNested(null);
    }

    public AwsNested<A> withNewAwsLike(FailedProvisionAWSConfig item) {
        return new AwsNested(item);
    }

    public A withRetryReasons(List<String> retryReasons) {
        if (retryReasons != null) {
            this.retryReasons = new ArrayList<String>();
            for (String item : retryReasons) {
                this.addToRetryReasons(item);
            }
        } else {
            this.retryReasons = null;
        }
        return (A)((Object)this);
    }

    public A withRetryReasons(String ... retryReasons) {
        if (this.retryReasons != null) {
            this.retryReasons.clear();
            this._visitables.remove((Object)"retryReasons");
        }
        if (retryReasons != null) {
            for (String item : retryReasons) {
                this.addToRetryReasons(item);
            }
        }
        return (A)((Object)this);
    }

    public A withSkipGatherLogs() {
        return this.withSkipGatherLogs(true);
    }

    public A withSkipGatherLogs(Boolean skipGatherLogs) {
        this.skipGatherLogs = skipGatherLogs;
        return (A)((Object)this);
    }

    public class AwsNested<N>
    extends FailedProvisionAWSConfigFluent<AwsNested<N>>
    implements Nested<N> {
        FailedProvisionAWSConfigBuilder builder;

        AwsNested(FailedProvisionAWSConfig item) {
            this.builder = new FailedProvisionAWSConfigBuilder(this, item);
        }

        public N and() {
            return (N)FailedProvisionConfigFluent.this.withAws(this.builder.build());
        }

        public N endAws() {
            return this.and();
        }
    }
}

