/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.azure.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.azure.v1.DiskEncryptionSet;
import io.fabric8.openshift.api.model.hive.azure.v1.DiskEncryptionSetBuilder;
import io.fabric8.openshift.api.model.hive.azure.v1.DiskEncryptionSetFluent;
import io.fabric8.openshift.api.model.hive.azure.v1.OSDisk;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OSDiskFluent<A extends OSDiskFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private DiskEncryptionSetBuilder diskEncryptionSet;
    private Integer diskSizeGB;
    private String diskType;

    public OSDiskFluent() {
    }

    public OSDiskFluent(OSDisk instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public DiskEncryptionSet buildDiskEncryptionSet() {
        return this.diskEncryptionSet != null ? this.diskEncryptionSet.build() : null;
    }

    protected void copyInstance(OSDisk instance) {
        OSDisk oSDisk = instance = instance != null ? instance : new OSDisk();
        if (instance != null) {
            this.withDiskEncryptionSet(instance.getDiskEncryptionSet());
            this.withDiskSizeGB(instance.getDiskSizeGB());
            this.withDiskType(instance.getDiskType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DiskEncryptionSetNested<A> editDiskEncryptionSet() {
        return this.withNewDiskEncryptionSetLike(Optional.ofNullable(this.buildDiskEncryptionSet()).orElse(null));
    }

    public DiskEncryptionSetNested<A> editOrNewDiskEncryptionSet() {
        return this.withNewDiskEncryptionSetLike(Optional.ofNullable(this.buildDiskEncryptionSet()).orElse(new DiskEncryptionSetBuilder().build()));
    }

    public DiskEncryptionSetNested<A> editOrNewDiskEncryptionSetLike(DiskEncryptionSet item) {
        return this.withNewDiskEncryptionSetLike(Optional.ofNullable(this.buildDiskEncryptionSet()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OSDiskFluent that = (OSDiskFluent)((Object)o);
        if (!Objects.equals((Object)this.diskEncryptionSet, (Object)that.diskEncryptionSet)) {
            return false;
        }
        if (!Objects.equals(this.diskSizeGB, that.diskSizeGB)) {
            return false;
        }
        if (!Objects.equals(this.diskType, that.diskType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getDiskSizeGB() {
        return this.diskSizeGB;
    }

    public String getDiskType() {
        return this.diskType;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDiskEncryptionSet() {
        return this.diskEncryptionSet != null;
    }

    public boolean hasDiskSizeGB() {
        return this.diskSizeGB != null;
    }

    public boolean hasDiskType() {
        return this.diskType != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.diskEncryptionSet, this.diskSizeGB, this.diskType, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.diskEncryptionSet != null) {
            sb.append("diskEncryptionSet:");
            sb.append((Object)this.diskEncryptionSet);
            sb.append(",");
        }
        if (this.diskSizeGB != null) {
            sb.append("diskSizeGB:");
            sb.append(this.diskSizeGB);
            sb.append(",");
        }
        if (this.diskType != null) {
            sb.append("diskType:");
            sb.append(this.diskType);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDiskEncryptionSet(DiskEncryptionSet diskEncryptionSet) {
        this._visitables.remove((Object)"diskEncryptionSet");
        if (diskEncryptionSet != null) {
            this.diskEncryptionSet = new DiskEncryptionSetBuilder(diskEncryptionSet);
            this._visitables.get((Object)"diskEncryptionSet").add(this.diskEncryptionSet);
        } else {
            this.diskEncryptionSet = null;
            this._visitables.get((Object)"diskEncryptionSet").remove((Object)this.diskEncryptionSet);
        }
        return (A)((Object)this);
    }

    public A withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return (A)((Object)this);
    }

    public A withDiskType(String diskType) {
        this.diskType = diskType;
        return (A)((Object)this);
    }

    public DiskEncryptionSetNested<A> withNewDiskEncryptionSet() {
        return new DiskEncryptionSetNested(null);
    }

    public A withNewDiskEncryptionSet(String name, String resourceGroup, String subscriptionId) {
        return this.withDiskEncryptionSet(new DiskEncryptionSet(name, resourceGroup, subscriptionId));
    }

    public DiskEncryptionSetNested<A> withNewDiskEncryptionSetLike(DiskEncryptionSet item) {
        return new DiskEncryptionSetNested(item);
    }

    public class DiskEncryptionSetNested<N>
    extends DiskEncryptionSetFluent<DiskEncryptionSetNested<N>>
    implements Nested<N> {
        DiskEncryptionSetBuilder builder;

        DiskEncryptionSetNested(DiskEncryptionSet item) {
            this.builder = new DiskEncryptionSetBuilder(this, item);
        }

        public N and() {
            return (N)OSDiskFluent.this.withDiskEncryptionSet(this.builder.build());
        }

        public N endDiskEncryptionSet() {
            return this.and();
        }
    }
}

