/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.ovirt.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.hive.ovirt.v1.Platform;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private LocalObjectReferenceBuilder certificatesSecretRef;
    private LocalObjectReferenceBuilder credentialsSecretRef;
    private String ovirtClusterId;
    private String ovirtNetworkName;
    private String storageDomainId;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public LocalObjectReference buildCertificatesSecretRef() {
        return this.certificatesSecretRef != null ? this.certificatesSecretRef.build() : null;
    }

    public LocalObjectReference buildCredentialsSecretRef() {
        return this.credentialsSecretRef != null ? this.credentialsSecretRef.build() : null;
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withCertificatesSecretRef(instance.getCertificatesSecretRef());
            this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
            this.withOvirtClusterId(instance.getOvirtClusterId());
            this.withOvirtNetworkName(instance.getOvirtNetworkName());
            this.withStorageDomainId(instance.getStorageDomainId());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CertificatesSecretRefNested<A> editCertificatesSecretRef() {
        return this.withNewCertificatesSecretRefLike(Optional.ofNullable(this.buildCertificatesSecretRef()).orElse(null));
    }

    public CredentialsSecretRefNested<A> editCredentialsSecretRef() {
        return this.withNewCredentialsSecretRefLike(Optional.ofNullable(this.buildCredentialsSecretRef()).orElse(null));
    }

    public CertificatesSecretRefNested<A> editOrNewCertificatesSecretRef() {
        return this.withNewCertificatesSecretRefLike(Optional.ofNullable(this.buildCertificatesSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public CertificatesSecretRefNested<A> editOrNewCertificatesSecretRefLike(LocalObjectReference item) {
        return this.withNewCertificatesSecretRefLike(Optional.ofNullable(this.buildCertificatesSecretRef()).orElse(item));
    }

    public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
        return this.withNewCredentialsSecretRefLike(Optional.ofNullable(this.buildCredentialsSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
        return this.withNewCredentialsSecretRefLike(Optional.ofNullable(this.buildCredentialsSecretRef()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)((Object)o);
        if (!Objects.equals(this.certificatesSecretRef, that.certificatesSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.credentialsSecretRef, that.credentialsSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.ovirtClusterId, that.ovirtClusterId)) {
            return false;
        }
        if (!Objects.equals(this.ovirtNetworkName, that.ovirtNetworkName)) {
            return false;
        }
        if (!Objects.equals(this.storageDomainId, that.storageDomainId)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getOvirtClusterId() {
        return this.ovirtClusterId;
    }

    public String getOvirtNetworkName() {
        return this.ovirtNetworkName;
    }

    public String getStorageDomainId() {
        return this.storageDomainId;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCertificatesSecretRef() {
        return this.certificatesSecretRef != null;
    }

    public boolean hasCredentialsSecretRef() {
        return this.credentialsSecretRef != null;
    }

    public boolean hasOvirtClusterId() {
        return this.ovirtClusterId != null;
    }

    public boolean hasOvirtNetworkName() {
        return this.ovirtNetworkName != null;
    }

    public boolean hasStorageDomainId() {
        return this.storageDomainId != null;
    }

    public int hashCode() {
        return Objects.hash(this.certificatesSecretRef, this.credentialsSecretRef, this.ovirtClusterId, this.ovirtNetworkName, this.storageDomainId, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificatesSecretRef != null) {
            sb.append("certificatesSecretRef:");
            sb.append(this.certificatesSecretRef);
            sb.append(",");
        }
        if (this.credentialsSecretRef != null) {
            sb.append("credentialsSecretRef:");
            sb.append(this.credentialsSecretRef);
            sb.append(",");
        }
        if (this.ovirtClusterId != null) {
            sb.append("ovirtClusterId:");
            sb.append(this.ovirtClusterId);
            sb.append(",");
        }
        if (this.ovirtNetworkName != null) {
            sb.append("ovirtNetworkName:");
            sb.append(this.ovirtNetworkName);
            sb.append(",");
        }
        if (this.storageDomainId != null) {
            sb.append("storageDomainId:");
            sb.append(this.storageDomainId);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCertificatesSecretRef(LocalObjectReference certificatesSecretRef) {
        this._visitables.remove((Object)"certificatesSecretRef");
        if (certificatesSecretRef != null) {
            this.certificatesSecretRef = new LocalObjectReferenceBuilder(certificatesSecretRef);
            this._visitables.get((Object)"certificatesSecretRef").add(this.certificatesSecretRef);
        } else {
            this.certificatesSecretRef = null;
            this._visitables.get((Object)"certificatesSecretRef").remove(this.certificatesSecretRef);
        }
        return (A)((Object)this);
    }

    public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
        this._visitables.remove((Object)"credentialsSecretRef");
        if (credentialsSecretRef != null) {
            this.credentialsSecretRef = new LocalObjectReferenceBuilder(credentialsSecretRef);
            this._visitables.get((Object)"credentialsSecretRef").add(this.credentialsSecretRef);
        } else {
            this.credentialsSecretRef = null;
            this._visitables.get((Object)"credentialsSecretRef").remove(this.credentialsSecretRef);
        }
        return (A)((Object)this);
    }

    public CertificatesSecretRefNested<A> withNewCertificatesSecretRef() {
        return new CertificatesSecretRefNested(null);
    }

    public A withNewCertificatesSecretRef(String name) {
        return this.withCertificatesSecretRef(new LocalObjectReference(name));
    }

    public CertificatesSecretRefNested<A> withNewCertificatesSecretRefLike(LocalObjectReference item) {
        return new CertificatesSecretRefNested(item);
    }

    public CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
        return new CredentialsSecretRefNested(null);
    }

    public A withNewCredentialsSecretRef(String name) {
        return this.withCredentialsSecretRef(new LocalObjectReference(name));
    }

    public CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
        return new CredentialsSecretRefNested(item);
    }

    public A withOvirtClusterId(String ovirtClusterId) {
        this.ovirtClusterId = ovirtClusterId;
        return (A)((Object)this);
    }

    public A withOvirtNetworkName(String ovirtNetworkName) {
        this.ovirtNetworkName = ovirtNetworkName;
        return (A)((Object)this);
    }

    public A withStorageDomainId(String storageDomainId) {
        this.storageDomainId = storageDomainId;
        return (A)((Object)this);
    }

    public class CredentialsSecretRefNested<N>
    extends LocalObjectReferenceFluent<CredentialsSecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        CredentialsSecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.withCredentialsSecretRef(this.builder.build());
        }

        public N endCredentialsSecretRef() {
            return this.and();
        }
    }

    public class CertificatesSecretRefNested<N>
    extends LocalObjectReferenceFluent<CertificatesSecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        CertificatesSecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.withCertificatesSecretRef(this.builder.build());
        }

        public N endCertificatesSecretRef() {
            return this.and();
        }
    }
}

