/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.hive.v1.CertificateBundleStatus;
import io.fabric8.openshift.api.model.hive.v1.CertificateBundleStatusBuilder;
import io.fabric8.openshift.api.model.hive.v1.CertificateBundleStatusFluent;
import io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentCondition;
import io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentConditionBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentConditionFluent;
import io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentStatus;
import io.fabric8.openshift.api.model.hive.v1.PlatformStatus;
import io.fabric8.openshift.api.model.hive.v1.PlatformStatusBuilder;
import io.fabric8.openshift.api.model.hive.v1.PlatformStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ClusterDeploymentStatusFluent<A extends ClusterDeploymentStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiURL;
    private ArrayList<CertificateBundleStatusBuilder> certificateBundles = new ArrayList();
    private String cliImage;
    private ArrayList<ClusterDeploymentConditionBuilder> conditions = new ArrayList();
    private Integer installRestarts;
    private String installStartedTimestamp;
    private String installVersion;
    private String installedTimestamp;
    private String installerImage;
    private PlatformStatusBuilder platformStatus;
    private String powerState;
    private LocalObjectReferenceBuilder provisionRef;
    private String webConsoleURL;

    public ClusterDeploymentStatusFluent() {
    }

    public ClusterDeploymentStatusFluent(ClusterDeploymentStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToCertificateBundles(Collection<CertificateBundleStatus> items) {
        if (this.certificateBundles == null) {
            this.certificateBundles = new ArrayList();
        }
        for (CertificateBundleStatus item : items) {
            CertificateBundleStatusBuilder builder = new CertificateBundleStatusBuilder(item);
            this._visitables.get((Object)"certificateBundles").add(builder);
            this.certificateBundles.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<ClusterDeploymentCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ClusterDeploymentCondition item : items) {
            ClusterDeploymentConditionBuilder builder = new ClusterDeploymentConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public CertificateBundlesNested<A> addNewCertificateBundle() {
        return new CertificateBundlesNested(-1, null);
    }

    public A addNewCertificateBundle(Boolean generated, String name) {
        return this.addToCertificateBundles(new CertificateBundleStatus(generated, name));
    }

    public CertificateBundlesNested<A> addNewCertificateBundleLike(CertificateBundleStatus item) {
        return new CertificateBundlesNested(-1, item);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(ClusterDeploymentCondition item) {
        return new ConditionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToCertificateBundles(CertificateBundleStatus ... items) {
        if (this.certificateBundles == null) {
            this.certificateBundles = new ArrayList();
        }
        for (CertificateBundleStatus item : items) {
            CertificateBundleStatusBuilder builder = new CertificateBundleStatusBuilder(item);
            this._visitables.get((Object)"certificateBundles").add(builder);
            this.certificateBundles.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToCertificateBundles(int index, CertificateBundleStatus item) {
        if (this.certificateBundles == null) {
            this.certificateBundles = new ArrayList();
        }
        CertificateBundleStatusBuilder builder = new CertificateBundleStatusBuilder(item);
        if (index < 0 || index >= this.certificateBundles.size()) {
            this._visitables.get((Object)"certificateBundles").add(builder);
            this.certificateBundles.add(builder);
        } else {
            this._visitables.get((Object)"certificateBundles").add(builder);
            this.certificateBundles.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(ClusterDeploymentCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ClusterDeploymentCondition item : items) {
            ClusterDeploymentConditionBuilder builder = new ClusterDeploymentConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, ClusterDeploymentCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ClusterDeploymentConditionBuilder builder = new ClusterDeploymentConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public CertificateBundleStatus buildCertificateBundle(int index) {
        return this.certificateBundles.get(index).build();
    }

    public List<CertificateBundleStatus> buildCertificateBundles() {
        return this.certificateBundles != null ? ClusterDeploymentStatusFluent.build(this.certificateBundles) : null;
    }

    public ClusterDeploymentCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<ClusterDeploymentCondition> buildConditions() {
        return this.conditions != null ? ClusterDeploymentStatusFluent.build(this.conditions) : null;
    }

    public CertificateBundleStatus buildFirstCertificateBundle() {
        return this.certificateBundles.get(0).build();
    }

    public ClusterDeploymentCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public CertificateBundleStatus buildLastCertificateBundle() {
        return this.certificateBundles.get(this.certificateBundles.size() - 1).build();
    }

    public ClusterDeploymentCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public CertificateBundleStatus buildMatchingCertificateBundle(Predicate<CertificateBundleStatusBuilder> predicate) {
        for (CertificateBundleStatusBuilder item : this.certificateBundles) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ClusterDeploymentCondition buildMatchingCondition(Predicate<ClusterDeploymentConditionBuilder> predicate) {
        for (ClusterDeploymentConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public PlatformStatus buildPlatformStatus() {
        return this.platformStatus != null ? this.platformStatus.build() : null;
    }

    public LocalObjectReference buildProvisionRef() {
        return this.provisionRef != null ? this.provisionRef.build() : null;
    }

    protected void copyInstance(ClusterDeploymentStatus instance) {
        ClusterDeploymentStatus clusterDeploymentStatus = instance = instance != null ? instance : new ClusterDeploymentStatus();
        if (instance != null) {
            this.withApiURL(instance.getApiURL());
            this.withCertificateBundles(instance.getCertificateBundles());
            this.withCliImage(instance.getCliImage());
            this.withConditions(instance.getConditions());
            this.withInstallRestarts(instance.getInstallRestarts());
            this.withInstallStartedTimestamp(instance.getInstallStartedTimestamp());
            this.withInstallVersion(instance.getInstallVersion());
            this.withInstalledTimestamp(instance.getInstalledTimestamp());
            this.withInstallerImage(instance.getInstallerImage());
            this.withPlatformStatus(instance.getPlatformStatus());
            this.withPowerState(instance.getPowerState());
            this.withProvisionRef(instance.getProvisionRef());
            this.withWebConsoleURL(instance.getWebConsoleURL());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CertificateBundlesNested<A> editCertificateBundle(int index) {
        if (this.certificateBundles.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "certificateBundles"));
        }
        return this.setNewCertificateBundleLike(index, this.buildCertificateBundle(index));
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public CertificateBundlesNested<A> editFirstCertificateBundle() {
        if (this.certificateBundles.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "certificateBundles"));
        }
        return this.setNewCertificateBundleLike(0, this.buildCertificateBundle(0));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public CertificateBundlesNested<A> editLastCertificateBundle() {
        int index = this.certificateBundles.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "certificateBundles"));
        }
        return this.setNewCertificateBundleLike(index, this.buildCertificateBundle(index));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public CertificateBundlesNested<A> editMatchingCertificateBundle(Predicate<CertificateBundleStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.certificateBundles.size(); ++i) {
            if (!predicate.test(this.certificateBundles.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "certificateBundles"));
        }
        return this.setNewCertificateBundleLike(index, this.buildCertificateBundle(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ClusterDeploymentConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public PlatformStatusNested<A> editOrNewPlatformStatus() {
        return this.withNewPlatformStatusLike(Optional.ofNullable(this.buildPlatformStatus()).orElse(new PlatformStatusBuilder().build()));
    }

    public PlatformStatusNested<A> editOrNewPlatformStatusLike(PlatformStatus item) {
        return this.withNewPlatformStatusLike(Optional.ofNullable(this.buildPlatformStatus()).orElse(item));
    }

    public ProvisionRefNested<A> editOrNewProvisionRef() {
        return this.withNewProvisionRefLike(Optional.ofNullable(this.buildProvisionRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public ProvisionRefNested<A> editOrNewProvisionRefLike(LocalObjectReference item) {
        return this.withNewProvisionRefLike(Optional.ofNullable(this.buildProvisionRef()).orElse(item));
    }

    public PlatformStatusNested<A> editPlatformStatus() {
        return this.withNewPlatformStatusLike(Optional.ofNullable(this.buildPlatformStatus()).orElse(null));
    }

    public ProvisionRefNested<A> editProvisionRef() {
        return this.withNewProvisionRefLike(Optional.ofNullable(this.buildProvisionRef()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterDeploymentStatusFluent that = (ClusterDeploymentStatusFluent)((Object)o);
        if (!Objects.equals(this.apiURL, that.apiURL)) {
            return false;
        }
        if (!Objects.equals(this.certificateBundles, that.certificateBundles)) {
            return false;
        }
        if (!Objects.equals(this.cliImage, that.cliImage)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.installRestarts, that.installRestarts)) {
            return false;
        }
        if (!Objects.equals(this.installStartedTimestamp, that.installStartedTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.installVersion, that.installVersion)) {
            return false;
        }
        if (!Objects.equals(this.installedTimestamp, that.installedTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.installerImage, that.installerImage)) {
            return false;
        }
        if (!Objects.equals((Object)this.platformStatus, (Object)that.platformStatus)) {
            return false;
        }
        if (!Objects.equals(this.powerState, that.powerState)) {
            return false;
        }
        if (!Objects.equals(this.provisionRef, that.provisionRef)) {
            return false;
        }
        if (!Objects.equals(this.webConsoleURL, that.webConsoleURL)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiURL() {
        return this.apiURL;
    }

    public String getCliImage() {
        return this.cliImage;
    }

    public Integer getInstallRestarts() {
        return this.installRestarts;
    }

    public String getInstallStartedTimestamp() {
        return this.installStartedTimestamp;
    }

    public String getInstallVersion() {
        return this.installVersion;
    }

    public String getInstalledTimestamp() {
        return this.installedTimestamp;
    }

    public String getInstallerImage() {
        return this.installerImage;
    }

    public String getPowerState() {
        return this.powerState;
    }

    public String getWebConsoleURL() {
        return this.webConsoleURL;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiURL() {
        return this.apiURL != null;
    }

    public boolean hasCertificateBundles() {
        return this.certificateBundles != null && !this.certificateBundles.isEmpty();
    }

    public boolean hasCliImage() {
        return this.cliImage != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasInstallRestarts() {
        return this.installRestarts != null;
    }

    public boolean hasInstallStartedTimestamp() {
        return this.installStartedTimestamp != null;
    }

    public boolean hasInstallVersion() {
        return this.installVersion != null;
    }

    public boolean hasInstalledTimestamp() {
        return this.installedTimestamp != null;
    }

    public boolean hasInstallerImage() {
        return this.installerImage != null;
    }

    public boolean hasMatchingCertificateBundle(Predicate<CertificateBundleStatusBuilder> predicate) {
        for (CertificateBundleStatusBuilder item : this.certificateBundles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingCondition(Predicate<ClusterDeploymentConditionBuilder> predicate) {
        for (ClusterDeploymentConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPlatformStatus() {
        return this.platformStatus != null;
    }

    public boolean hasPowerState() {
        return this.powerState != null;
    }

    public boolean hasProvisionRef() {
        return this.provisionRef != null;
    }

    public boolean hasWebConsoleURL() {
        return this.webConsoleURL != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiURL, this.certificateBundles, this.cliImage, this.conditions, this.installRestarts, this.installStartedTimestamp, this.installVersion, this.installedTimestamp, this.installerImage, this.platformStatus, this.powerState, this.provisionRef, this.webConsoleURL, this.additionalProperties});
    }

    public A removeAllFromCertificateBundles(Collection<CertificateBundleStatus> items) {
        if (this.certificateBundles == null) {
            return (A)((Object)this);
        }
        for (CertificateBundleStatus item : items) {
            CertificateBundleStatusBuilder builder = new CertificateBundleStatusBuilder(item);
            this._visitables.get((Object)"certificateBundles").remove((Object)builder);
            this.certificateBundles.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<ClusterDeploymentCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ClusterDeploymentCondition item : items) {
            ClusterDeploymentConditionBuilder builder = new ClusterDeploymentConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromCertificateBundles(CertificateBundleStatus ... items) {
        if (this.certificateBundles == null) {
            return (A)((Object)this);
        }
        for (CertificateBundleStatus item : items) {
            CertificateBundleStatusBuilder builder = new CertificateBundleStatusBuilder(item);
            this._visitables.get((Object)"certificateBundles").remove((Object)builder);
            this.certificateBundles.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(ClusterDeploymentCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ClusterDeploymentCondition item : items) {
            ClusterDeploymentConditionBuilder builder = new ClusterDeploymentConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCertificateBundles(Predicate<CertificateBundleStatusBuilder> predicate) {
        if (this.certificateBundles == null) {
            return (A)((Object)this);
        }
        Iterator<CertificateBundleStatusBuilder> each = this.certificateBundles.iterator();
        List visitables = this._visitables.get((Object)"certificateBundles");
        while (each.hasNext()) {
            CertificateBundleStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ClusterDeploymentConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ClusterDeploymentConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ClusterDeploymentConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public CertificateBundlesNested<A> setNewCertificateBundleLike(int index, CertificateBundleStatus item) {
        return new CertificateBundlesNested(index, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, ClusterDeploymentCondition item) {
        return new ConditionsNested(index, item);
    }

    public A setToCertificateBundles(int index, CertificateBundleStatus item) {
        if (this.certificateBundles == null) {
            this.certificateBundles = new ArrayList();
        }
        CertificateBundleStatusBuilder builder = new CertificateBundleStatusBuilder(item);
        if (index < 0 || index >= this.certificateBundles.size()) {
            this._visitables.get((Object)"certificateBundles").add(builder);
            this.certificateBundles.add(builder);
        } else {
            this._visitables.get((Object)"certificateBundles").add(builder);
            this.certificateBundles.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, ClusterDeploymentCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ClusterDeploymentConditionBuilder builder = new ClusterDeploymentConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiURL != null) {
            sb.append("apiURL:");
            sb.append(this.apiURL);
            sb.append(",");
        }
        if (this.certificateBundles != null && !this.certificateBundles.isEmpty()) {
            sb.append("certificateBundles:");
            sb.append(this.certificateBundles);
            sb.append(",");
        }
        if (this.cliImage != null) {
            sb.append("cliImage:");
            sb.append(this.cliImage);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.installRestarts != null) {
            sb.append("installRestarts:");
            sb.append(this.installRestarts);
            sb.append(",");
        }
        if (this.installStartedTimestamp != null) {
            sb.append("installStartedTimestamp:");
            sb.append(this.installStartedTimestamp);
            sb.append(",");
        }
        if (this.installVersion != null) {
            sb.append("installVersion:");
            sb.append(this.installVersion);
            sb.append(",");
        }
        if (this.installedTimestamp != null) {
            sb.append("installedTimestamp:");
            sb.append(this.installedTimestamp);
            sb.append(",");
        }
        if (this.installerImage != null) {
            sb.append("installerImage:");
            sb.append(this.installerImage);
            sb.append(",");
        }
        if (this.platformStatus != null) {
            sb.append("platformStatus:");
            sb.append((Object)this.platformStatus);
            sb.append(",");
        }
        if (this.powerState != null) {
            sb.append("powerState:");
            sb.append(this.powerState);
            sb.append(",");
        }
        if (this.provisionRef != null) {
            sb.append("provisionRef:");
            sb.append(this.provisionRef);
            sb.append(",");
        }
        if (this.webConsoleURL != null) {
            sb.append("webConsoleURL:");
            sb.append(this.webConsoleURL);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiURL(String apiURL) {
        this.apiURL = apiURL;
        return (A)((Object)this);
    }

    public A withCertificateBundles(List<CertificateBundleStatus> certificateBundles) {
        if (this.certificateBundles != null) {
            this._visitables.get((Object)"certificateBundles").clear();
        }
        if (certificateBundles != null) {
            this.certificateBundles = new ArrayList();
            for (CertificateBundleStatus item : certificateBundles) {
                this.addToCertificateBundles(item);
            }
        } else {
            this.certificateBundles = null;
        }
        return (A)((Object)this);
    }

    public A withCertificateBundles(CertificateBundleStatus ... certificateBundles) {
        if (this.certificateBundles != null) {
            this.certificateBundles.clear();
            this._visitables.remove((Object)"certificateBundles");
        }
        if (certificateBundles != null) {
            for (CertificateBundleStatus item : certificateBundles) {
                this.addToCertificateBundles(item);
            }
        }
        return (A)((Object)this);
    }

    public A withCliImage(String cliImage) {
        this.cliImage = cliImage;
        return (A)((Object)this);
    }

    public A withConditions(List<ClusterDeploymentCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (ClusterDeploymentCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(ClusterDeploymentCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (ClusterDeploymentCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withInstallRestarts(Integer installRestarts) {
        this.installRestarts = installRestarts;
        return (A)((Object)this);
    }

    public A withInstallStartedTimestamp(String installStartedTimestamp) {
        this.installStartedTimestamp = installStartedTimestamp;
        return (A)((Object)this);
    }

    public A withInstallVersion(String installVersion) {
        this.installVersion = installVersion;
        return (A)((Object)this);
    }

    public A withInstalledTimestamp(String installedTimestamp) {
        this.installedTimestamp = installedTimestamp;
        return (A)((Object)this);
    }

    public A withInstallerImage(String installerImage) {
        this.installerImage = installerImage;
        return (A)((Object)this);
    }

    public PlatformStatusNested<A> withNewPlatformStatus() {
        return new PlatformStatusNested(null);
    }

    public PlatformStatusNested<A> withNewPlatformStatusLike(PlatformStatus item) {
        return new PlatformStatusNested(item);
    }

    public ProvisionRefNested<A> withNewProvisionRef() {
        return new ProvisionRefNested(null);
    }

    public A withNewProvisionRef(String name) {
        return this.withProvisionRef(new LocalObjectReference(name));
    }

    public ProvisionRefNested<A> withNewProvisionRefLike(LocalObjectReference item) {
        return new ProvisionRefNested(item);
    }

    public A withPlatformStatus(PlatformStatus platformStatus) {
        this._visitables.remove((Object)"platformStatus");
        if (platformStatus != null) {
            this.platformStatus = new PlatformStatusBuilder(platformStatus);
            this._visitables.get((Object)"platformStatus").add(this.platformStatus);
        } else {
            this.platformStatus = null;
            this._visitables.get((Object)"platformStatus").remove((Object)this.platformStatus);
        }
        return (A)((Object)this);
    }

    public A withPowerState(String powerState) {
        this.powerState = powerState;
        return (A)((Object)this);
    }

    public A withProvisionRef(LocalObjectReference provisionRef) {
        this._visitables.remove((Object)"provisionRef");
        if (provisionRef != null) {
            this.provisionRef = new LocalObjectReferenceBuilder(provisionRef);
            this._visitables.get((Object)"provisionRef").add(this.provisionRef);
        } else {
            this.provisionRef = null;
            this._visitables.get((Object)"provisionRef").remove(this.provisionRef);
        }
        return (A)((Object)this);
    }

    public A withWebConsoleURL(String webConsoleURL) {
        this.webConsoleURL = webConsoleURL;
        return (A)((Object)this);
    }

    public class ProvisionRefNested<N>
    extends LocalObjectReferenceFluent<ProvisionRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        ProvisionRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)ClusterDeploymentStatusFluent.this.withProvisionRef(this.builder.build());
        }

        public N endProvisionRef() {
            return this.and();
        }
    }

    public class PlatformStatusNested<N>
    extends PlatformStatusFluent<PlatformStatusNested<N>>
    implements Nested<N> {
        PlatformStatusBuilder builder;

        PlatformStatusNested(PlatformStatus item) {
            this.builder = new PlatformStatusBuilder(this, item);
        }

        public N and() {
            return (N)ClusterDeploymentStatusFluent.this.withPlatformStatus(this.builder.build());
        }

        public N endPlatformStatus() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ClusterDeploymentConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ClusterDeploymentConditionBuilder builder;
        int index;

        ConditionsNested(int index, ClusterDeploymentCondition item) {
            this.index = index;
            this.builder = new ClusterDeploymentConditionBuilder(this, item);
        }

        public N and() {
            return (N)ClusterDeploymentStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class CertificateBundlesNested<N>
    extends CertificateBundleStatusFluent<CertificateBundlesNested<N>>
    implements Nested<N> {
        CertificateBundleStatusBuilder builder;
        int index;

        CertificateBundlesNested(int index, CertificateBundleStatus item) {
            this.index = index;
            this.builder = new CertificateBundleStatusBuilder(this, item);
        }

        public N and() {
            return (N)ClusterDeploymentStatusFluent.this.setToCertificateBundles(this.index, this.builder.build());
        }

        public N endCertificateBundle() {
            return this.and();
        }
    }
}

