/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.hive.v1.ClusterPoolReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ClusterPoolReferenceFluent<A extends ClusterPoolReferenceFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String claimName;
    private String claimedTimestamp;
    private LocalObjectReferenceBuilder clusterDeploymentCustomization;
    private String namespace;
    private String poolName;

    public ClusterPoolReferenceFluent() {
    }

    public ClusterPoolReferenceFluent(ClusterPoolReference instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public LocalObjectReference buildClusterDeploymentCustomization() {
        return this.clusterDeploymentCustomization != null ? this.clusterDeploymentCustomization.build() : null;
    }

    protected void copyInstance(ClusterPoolReference instance) {
        ClusterPoolReference clusterPoolReference = instance = instance != null ? instance : new ClusterPoolReference();
        if (instance != null) {
            this.withClaimName(instance.getClaimName());
            this.withClaimedTimestamp(instance.getClaimedTimestamp());
            this.withClusterDeploymentCustomization(instance.getClusterDeploymentCustomization());
            this.withNamespace(instance.getNamespace());
            this.withPoolName(instance.getPoolName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ClusterDeploymentCustomizationNested<A> editClusterDeploymentCustomization() {
        return this.withNewClusterDeploymentCustomizationLike(Optional.ofNullable(this.buildClusterDeploymentCustomization()).orElse(null));
    }

    public ClusterDeploymentCustomizationNested<A> editOrNewClusterDeploymentCustomization() {
        return this.withNewClusterDeploymentCustomizationLike(Optional.ofNullable(this.buildClusterDeploymentCustomization()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public ClusterDeploymentCustomizationNested<A> editOrNewClusterDeploymentCustomizationLike(LocalObjectReference item) {
        return this.withNewClusterDeploymentCustomizationLike(Optional.ofNullable(this.buildClusterDeploymentCustomization()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterPoolReferenceFluent that = (ClusterPoolReferenceFluent)((Object)o);
        if (!Objects.equals(this.claimName, that.claimName)) {
            return false;
        }
        if (!Objects.equals(this.claimedTimestamp, that.claimedTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.clusterDeploymentCustomization, that.clusterDeploymentCustomization)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.poolName, that.poolName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getClaimName() {
        return this.claimName;
    }

    public String getClaimedTimestamp() {
        return this.claimedTimestamp;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasClaimName() {
        return this.claimName != null;
    }

    public boolean hasClaimedTimestamp() {
        return this.claimedTimestamp != null;
    }

    public boolean hasClusterDeploymentCustomization() {
        return this.clusterDeploymentCustomization != null;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public boolean hasPoolName() {
        return this.poolName != null;
    }

    public int hashCode() {
        return Objects.hash(this.claimName, this.claimedTimestamp, this.clusterDeploymentCustomization, this.namespace, this.poolName, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.claimName != null) {
            sb.append("claimName:");
            sb.append(this.claimName);
            sb.append(",");
        }
        if (this.claimedTimestamp != null) {
            sb.append("claimedTimestamp:");
            sb.append(this.claimedTimestamp);
            sb.append(",");
        }
        if (this.clusterDeploymentCustomization != null) {
            sb.append("clusterDeploymentCustomization:");
            sb.append(this.clusterDeploymentCustomization);
            sb.append(",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace);
            sb.append(",");
        }
        if (this.poolName != null) {
            sb.append("poolName:");
            sb.append(this.poolName);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withClaimName(String claimName) {
        this.claimName = claimName;
        return (A)((Object)this);
    }

    public A withClaimedTimestamp(String claimedTimestamp) {
        this.claimedTimestamp = claimedTimestamp;
        return (A)((Object)this);
    }

    public A withClusterDeploymentCustomization(LocalObjectReference clusterDeploymentCustomization) {
        this._visitables.remove((Object)"clusterDeploymentCustomization");
        if (clusterDeploymentCustomization != null) {
            this.clusterDeploymentCustomization = new LocalObjectReferenceBuilder(clusterDeploymentCustomization);
            this._visitables.get((Object)"clusterDeploymentCustomization").add(this.clusterDeploymentCustomization);
        } else {
            this.clusterDeploymentCustomization = null;
            this._visitables.get((Object)"clusterDeploymentCustomization").remove(this.clusterDeploymentCustomization);
        }
        return (A)((Object)this);
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public ClusterDeploymentCustomizationNested<A> withNewClusterDeploymentCustomization() {
        return new ClusterDeploymentCustomizationNested(null);
    }

    public A withNewClusterDeploymentCustomization(String name) {
        return this.withClusterDeploymentCustomization(new LocalObjectReference(name));
    }

    public ClusterDeploymentCustomizationNested<A> withNewClusterDeploymentCustomizationLike(LocalObjectReference item) {
        return new ClusterDeploymentCustomizationNested(item);
    }

    public A withPoolName(String poolName) {
        this.poolName = poolName;
        return (A)((Object)this);
    }

    public class ClusterDeploymentCustomizationNested<N>
    extends LocalObjectReferenceFluent<ClusterDeploymentCustomizationNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        ClusterDeploymentCustomizationNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)ClusterPoolReferenceFluent.this.withClusterDeploymentCustomization(this.builder.build());
        }

        public N endClusterDeploymentCustomization() {
            return this.and();
        }
    }
}

