/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.libvirt.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.libvirt.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.libvirt.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.libvirt.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.installer.libvirt.v1.Network;
import io.fabric8.openshift.api.model.installer.libvirt.v1.NetworkBuilder;
import io.fabric8.openshift.api.model.installer.libvirt.v1.NetworkFluent;
import io.fabric8.openshift.api.model.installer.libvirt.v1.Platform;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private String uri;
    private MachinePoolBuilder defaultMachinePlatform;
    private NetworkBuilder network;
    private Map<String, Object> additionalProperties;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withUri(instance.getUri());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withNetwork(instance.getNetwork());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getUri() {
        return this.uri;
    }

    public A withUri(String uri) {
        this.uri = uri;
        return (A)((Object)this);
    }

    public boolean hasUri() {
        return this.uri != null;
    }

    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.remove((Object)"defaultMachinePlatform");
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get((Object)"defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get((Object)"defaultMachinePlatform").remove((Object)this.defaultMachinePlatform);
        }
        return (A)((Object)this);
    }

    public boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNested(null);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNested(item);
    }

    public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(null));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(item));
    }

    public Network buildNetwork() {
        return this.network != null ? this.network.build() : null;
    }

    public A withNetwork(Network network) {
        this._visitables.remove((Object)"network");
        if (network != null) {
            this.network = new NetworkBuilder(network);
            this._visitables.get((Object)"network").add(this.network);
        } else {
            this.network = null;
            this._visitables.get((Object)"network").remove((Object)this.network);
        }
        return (A)((Object)this);
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public NetworkNested<A> withNewNetwork() {
        return new NetworkNested(null);
    }

    public NetworkNested<A> withNewNetworkLike(Network item) {
        return new NetworkNested(item);
    }

    public NetworkNested<A> editNetwork() {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(null));
    }

    public NetworkNested<A> editOrNewNetwork() {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(new NetworkBuilder().build()));
    }

    public NetworkNested<A> editOrNewNetworkLike(Network item) {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)((Object)o);
        if (!Objects.equals(this.uri, that.uri)) {
            return false;
        }
        if (!Objects.equals((Object)this.defaultMachinePlatform, (Object)that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals((Object)this.network, (Object)that.network)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uri, this.defaultMachinePlatform, this.network, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.uri != null) {
            sb.append("uri:");
            sb.append(this.uri + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append((Object)((Object)this.defaultMachinePlatform) + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append((Object)((Object)this.network) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NetworkNested<N>
    extends NetworkFluent<NetworkNested<N>>
    implements Nested<N> {
        NetworkBuilder builder;

        NetworkNested(Network item) {
            this.builder = new NetworkBuilder(this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.withNetwork(this.builder.build());
        }

        public N endNetwork() {
            return this.and();
        }
    }

    public class DefaultMachinePlatformNested<N>
    extends MachinePoolFluent<DefaultMachinePlatformNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        public N and() {
            return (N)PlatformFluent.this.withDefaultMachinePlatform(this.builder.build());
        }

        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

