package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluentImpl<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withArmEndpoint(instance.getArmEndpoint()); 
    fluent.withBaseDomainResourceGroupName(instance.getBaseDomainResourceGroupName()); 
    fluent.withCloudName(instance.getCloudName()); 
    fluent.withClusterOSImage(instance.getClusterOSImage()); 
    fluent.withComputeSubnet(instance.getComputeSubnet()); 
    fluent.withControlPlaneSubnet(instance.getControlPlaneSubnet()); 
    fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    fluent.withNetworkResourceGroupName(instance.getNetworkResourceGroupName()); 
    fluent.withOutboundType(instance.getOutboundType()); 
    fluent.withRegion(instance.getRegion()); 
    fluent.withResourceGroupName(instance.getResourceGroupName()); 
    fluent.withVirtualNetwork(instance.getVirtualNetwork()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withArmEndpoint(instance.getArmEndpoint()); 
    this.withBaseDomainResourceGroupName(instance.getBaseDomainResourceGroupName()); 
    this.withCloudName(instance.getCloudName()); 
    this.withClusterOSImage(instance.getClusterOSImage()); 
    this.withComputeSubnet(instance.getComputeSubnet()); 
    this.withControlPlaneSubnet(instance.getControlPlaneSubnet()); 
    this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform()); 
    this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName()); 
    this.withOutboundType(instance.getOutboundType()); 
    this.withRegion(instance.getRegion()); 
    this.withResourceGroupName(instance.getResourceGroupName()); 
    this.withVirtualNetwork(instance.getVirtualNetwork()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getArmEndpoint(),fluent.getBaseDomainResourceGroupName(),fluent.getCloudName(),fluent.getClusterOSImage(),fluent.getComputeSubnet(),fluent.getControlPlaneSubnet(),fluent.getDefaultMachinePlatform(),fluent.getNetworkResourceGroupName(),fluent.getOutboundType(),fluent.getRegion(),fluent.getResourceGroupName(),fluent.getVirtualNetwork());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}