package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class InstallConfigFluentImpl<A extends InstallConfigFluent<A>> extends BaseFluent<A> implements InstallConfigFluent<A>{
  public InstallConfigFluentImpl() {
  }
  public InstallConfigFluentImpl(InstallConfig instance) {
    this.withAdditionalTrustBundle(instance.getAdditionalTrustBundle()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withBaseDomain(instance.getBaseDomain()); 
    this.withBootstrapInPlace(instance.getBootstrapInPlace()); 
    this.withCompute(instance.getCompute()); 
    this.withControlPlane(instance.getControlPlane()); 
    this.withCredentialsMode(instance.getCredentialsMode()); 
    this.withFips(instance.getFips()); 
    this.withImageContentSources(instance.getImageContentSources()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withNetworking(instance.getNetworking()); 
    this.withPlatform(instance.getPlatform()); 
    this.withProxy(instance.getProxy()); 
    this.withPublish(instance.getPublish()); 
    this.withPullSecret(instance.getPullSecret()); 
    this.withSshKey(instance.getSshKey()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String additionalTrustBundle;
  private String apiVersion;
  private String baseDomain;
  private BootstrapInPlaceBuilder bootstrapInPlace;
  private ArrayList<MachinePoolBuilder> compute = new ArrayList<MachinePoolBuilder>();
  private MachinePoolBuilder controlPlane;
  private String credentialsMode;
  private Boolean fips;
  private ArrayList<ImageContentSourceBuilder> imageContentSources = new ArrayList<ImageContentSourceBuilder>();
  private String kind;
  private ObjectMetaBuilder metadata;
  private NetworkingBuilder networking;
  private PlatformBuilder platform;
  private ProxyBuilder proxy;
  private String publish;
  private String pullSecret;
  private String sshKey;
  private Map<String,Object> additionalProperties;
  public String getAdditionalTrustBundle() {
    return this.additionalTrustBundle;
  }
  public A withAdditionalTrustBundle(String additionalTrustBundle) {
    this.additionalTrustBundle=additionalTrustBundle; return (A) this;
  }
  public Boolean hasAdditionalTrustBundle() {
    return this.additionalTrustBundle != null;
  }
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getBaseDomain() {
    return this.baseDomain;
  }
  public A withBaseDomain(String baseDomain) {
    this.baseDomain=baseDomain; return (A) this;
  }
  public Boolean hasBaseDomain() {
    return this.baseDomain != null;
  }
  
  /**
   * This method has been deprecated, please use method buildBootstrapInPlace instead.
   * @return The buildable object.
   */
  @Deprecated
  public BootstrapInPlace getBootstrapInPlace() {
    return this.bootstrapInPlace!=null ?this.bootstrapInPlace.build():null;
  }
  public BootstrapInPlace buildBootstrapInPlace() {
    return this.bootstrapInPlace!=null ?this.bootstrapInPlace.build():null;
  }
  public A withBootstrapInPlace(BootstrapInPlace bootstrapInPlace) {
    _visitables.get("bootstrapInPlace").remove(this.bootstrapInPlace);
    if (bootstrapInPlace!=null){ this.bootstrapInPlace= new BootstrapInPlaceBuilder(bootstrapInPlace); _visitables.get("bootstrapInPlace").add(this.bootstrapInPlace);} else { this.bootstrapInPlace = null; _visitables.get("bootstrapInPlace").remove(this.bootstrapInPlace); } return (A) this;
  }
  public Boolean hasBootstrapInPlace() {
    return this.bootstrapInPlace != null;
  }
  public A withNewBootstrapInPlace(String installationDisk) {
    return (A)withBootstrapInPlace(new BootstrapInPlace(installationDisk));
  }
  public InstallConfigFluent.BootstrapInPlaceNested<A> withNewBootstrapInPlace() {
    return new InstallConfigFluentImpl.BootstrapInPlaceNestedImpl();
  }
  public InstallConfigFluent.BootstrapInPlaceNested<A> withNewBootstrapInPlaceLike(BootstrapInPlace item) {
    return new InstallConfigFluentImpl.BootstrapInPlaceNestedImpl(item);
  }
  public InstallConfigFluent.BootstrapInPlaceNested<A> editBootstrapInPlace() {
    return withNewBootstrapInPlaceLike(getBootstrapInPlace());
  }
  public InstallConfigFluent.BootstrapInPlaceNested<A> editOrNewBootstrapInPlace() {
    return withNewBootstrapInPlaceLike(getBootstrapInPlace() != null ? getBootstrapInPlace(): new BootstrapInPlaceBuilder().build());
  }
  public InstallConfigFluent.BootstrapInPlaceNested<A> editOrNewBootstrapInPlaceLike(BootstrapInPlace item) {
    return withNewBootstrapInPlaceLike(getBootstrapInPlace() != null ? getBootstrapInPlace(): item);
  }
  public A addToCompute(Integer index,MachinePool item) {
    if (this.compute == null) {this.compute = new ArrayList<MachinePoolBuilder>();}
    MachinePoolBuilder builder = new MachinePoolBuilder(item);_visitables.get("compute").add(index >= 0 ? index : _visitables.get("compute").size(), builder);this.compute.add(index >= 0 ? index : compute.size(), builder); return (A)this;
  }
  public A setToCompute(Integer index,MachinePool item) {
    if (this.compute == null) {this.compute = new ArrayList<MachinePoolBuilder>();}
    MachinePoolBuilder builder = new MachinePoolBuilder(item);
    if (index < 0 || index >= _visitables.get("compute").size()) { _visitables.get("compute").add(builder); } else { _visitables.get("compute").set(index, builder);}
    if (index < 0 || index >= compute.size()) { compute.add(builder); } else { compute.set(index, builder);}
     return (A)this;
  }
  public A addToCompute(io.fabric8.openshift.api.model.installer.v1.MachinePool... items) {
    if (this.compute == null) {this.compute = new ArrayList<MachinePoolBuilder>();}
    for (MachinePool item : items) {MachinePoolBuilder builder = new MachinePoolBuilder(item);_visitables.get("compute").add(builder);this.compute.add(builder);} return (A)this;
  }
  public A addAllToCompute(Collection<MachinePool> items) {
    if (this.compute == null) {this.compute = new ArrayList<MachinePoolBuilder>();}
    for (MachinePool item : items) {MachinePoolBuilder builder = new MachinePoolBuilder(item);_visitables.get("compute").add(builder);this.compute.add(builder);} return (A)this;
  }
  public A removeFromCompute(io.fabric8.openshift.api.model.installer.v1.MachinePool... items) {
    for (MachinePool item : items) {MachinePoolBuilder builder = new MachinePoolBuilder(item);_visitables.get("compute").remove(builder);if (this.compute != null) {this.compute.remove(builder);}} return (A)this;
  }
  public A removeAllFromCompute(Collection<MachinePool> items) {
    for (MachinePool item : items) {MachinePoolBuilder builder = new MachinePoolBuilder(item);_visitables.get("compute").remove(builder);if (this.compute != null) {this.compute.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCompute(Predicate<MachinePoolBuilder> predicate) {
    if (compute == null) return (A) this;
    final Iterator<MachinePoolBuilder> each = compute.iterator();
    final List visitables = _visitables.get("compute");
    while (each.hasNext()) {
      MachinePoolBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildCompute instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MachinePool> getCompute() {
    return compute != null ? build(compute) : null;
  }
  public List<MachinePool> buildCompute() {
    return compute != null ? build(compute) : null;
  }
  public MachinePool buildCompute(Integer index) {
    return this.compute.get(index).build();
  }
  public MachinePool buildFirstCompute() {
    return this.compute.get(0).build();
  }
  public MachinePool buildLastCompute() {
    return this.compute.get(compute.size() - 1).build();
  }
  public MachinePool buildMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
    for (MachinePoolBuilder item: compute) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
    for (MachinePoolBuilder item: compute) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCompute(List<MachinePool> compute) {
    if (this.compute != null) { _visitables.get("compute").removeAll(this.compute);}
    if (compute != null) {this.compute = new ArrayList(); for (MachinePool item : compute){this.addToCompute(item);}} else { this.compute = null;} return (A) this;
  }
  public A withCompute(io.fabric8.openshift.api.model.installer.v1.MachinePool... compute) {
    if (this.compute != null) {this.compute.clear();}
    if (compute != null) {for (MachinePool item :compute){ this.addToCompute(item);}} return (A) this;
  }
  public Boolean hasCompute() {
    return compute != null && !compute.isEmpty();
  }
  public InstallConfigFluent.ComputeNested<A> addNewCompute() {
    return new InstallConfigFluentImpl.ComputeNestedImpl();
  }
  public InstallConfigFluent.ComputeNested<A> addNewComputeLike(MachinePool item) {
    return new InstallConfigFluentImpl.ComputeNestedImpl(-1, item);
  }
  public InstallConfigFluent.ComputeNested<A> setNewComputeLike(Integer index,MachinePool item) {
    return new InstallConfigFluentImpl.ComputeNestedImpl(index, item);
  }
  public InstallConfigFluent.ComputeNested<A> editCompute(Integer index) {
    if (compute.size() <= index) throw new RuntimeException("Can't edit compute. Index exceeds size.");
    return setNewComputeLike(index, buildCompute(index));
  }
  public InstallConfigFluent.ComputeNested<A> editFirstCompute() {
    if (compute.size() == 0) throw new RuntimeException("Can't edit first compute. The list is empty.");
    return setNewComputeLike(0, buildCompute(0));
  }
  public InstallConfigFluent.ComputeNested<A> editLastCompute() {
    int index = compute.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last compute. The list is empty.");
    return setNewComputeLike(index, buildCompute(index));
  }
  public InstallConfigFluent.ComputeNested<A> editMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
    int index = -1;
    for (int i=0;i<compute.size();i++) { 
    if (predicate.test(compute.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching compute. No match found.");
    return setNewComputeLike(index, buildCompute(index));
  }
  
  /**
   * This method has been deprecated, please use method buildControlPlane instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getControlPlane() {
    return this.controlPlane!=null ?this.controlPlane.build():null;
  }
  public MachinePool buildControlPlane() {
    return this.controlPlane!=null ?this.controlPlane.build():null;
  }
  public A withControlPlane(MachinePool controlPlane) {
    _visitables.get("controlPlane").remove(this.controlPlane);
    if (controlPlane!=null){ this.controlPlane= new MachinePoolBuilder(controlPlane); _visitables.get("controlPlane").add(this.controlPlane);} else { this.controlPlane = null; _visitables.get("controlPlane").remove(this.controlPlane); } return (A) this;
  }
  public Boolean hasControlPlane() {
    return this.controlPlane != null;
  }
  public InstallConfigFluent.ControlPlaneNested<A> withNewControlPlane() {
    return new InstallConfigFluentImpl.ControlPlaneNestedImpl();
  }
  public InstallConfigFluent.ControlPlaneNested<A> withNewControlPlaneLike(MachinePool item) {
    return new InstallConfigFluentImpl.ControlPlaneNestedImpl(item);
  }
  public InstallConfigFluent.ControlPlaneNested<A> editControlPlane() {
    return withNewControlPlaneLike(getControlPlane());
  }
  public InstallConfigFluent.ControlPlaneNested<A> editOrNewControlPlane() {
    return withNewControlPlaneLike(getControlPlane() != null ? getControlPlane(): new MachinePoolBuilder().build());
  }
  public InstallConfigFluent.ControlPlaneNested<A> editOrNewControlPlaneLike(MachinePool item) {
    return withNewControlPlaneLike(getControlPlane() != null ? getControlPlane(): item);
  }
  public String getCredentialsMode() {
    return this.credentialsMode;
  }
  public A withCredentialsMode(String credentialsMode) {
    this.credentialsMode=credentialsMode; return (A) this;
  }
  public Boolean hasCredentialsMode() {
    return this.credentialsMode != null;
  }
  public Boolean getFips() {
    return this.fips;
  }
  public A withFips(Boolean fips) {
    this.fips=fips; return (A) this;
  }
  public Boolean hasFips() {
    return this.fips != null;
  }
  public A addToImageContentSources(Integer index,ImageContentSource item) {
    if (this.imageContentSources == null) {this.imageContentSources = new ArrayList<ImageContentSourceBuilder>();}
    ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);_visitables.get("imageContentSources").add(index >= 0 ? index : _visitables.get("imageContentSources").size(), builder);this.imageContentSources.add(index >= 0 ? index : imageContentSources.size(), builder); return (A)this;
  }
  public A setToImageContentSources(Integer index,ImageContentSource item) {
    if (this.imageContentSources == null) {this.imageContentSources = new ArrayList<ImageContentSourceBuilder>();}
    ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
    if (index < 0 || index >= _visitables.get("imageContentSources").size()) { _visitables.get("imageContentSources").add(builder); } else { _visitables.get("imageContentSources").set(index, builder);}
    if (index < 0 || index >= imageContentSources.size()) { imageContentSources.add(builder); } else { imageContentSources.set(index, builder);}
     return (A)this;
  }
  public A addToImageContentSources(io.fabric8.openshift.api.model.installer.v1.ImageContentSource... items) {
    if (this.imageContentSources == null) {this.imageContentSources = new ArrayList<ImageContentSourceBuilder>();}
    for (ImageContentSource item : items) {ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);_visitables.get("imageContentSources").add(builder);this.imageContentSources.add(builder);} return (A)this;
  }
  public A addAllToImageContentSources(Collection<ImageContentSource> items) {
    if (this.imageContentSources == null) {this.imageContentSources = new ArrayList<ImageContentSourceBuilder>();}
    for (ImageContentSource item : items) {ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);_visitables.get("imageContentSources").add(builder);this.imageContentSources.add(builder);} return (A)this;
  }
  public A removeFromImageContentSources(io.fabric8.openshift.api.model.installer.v1.ImageContentSource... items) {
    for (ImageContentSource item : items) {ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);_visitables.get("imageContentSources").remove(builder);if (this.imageContentSources != null) {this.imageContentSources.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageContentSources(Collection<ImageContentSource> items) {
    for (ImageContentSource item : items) {ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);_visitables.get("imageContentSources").remove(builder);if (this.imageContentSources != null) {this.imageContentSources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageContentSources(Predicate<ImageContentSourceBuilder> predicate) {
    if (imageContentSources == null) return (A) this;
    final Iterator<ImageContentSourceBuilder> each = imageContentSources.iterator();
    final List visitables = _visitables.get("imageContentSources");
    while (each.hasNext()) {
      ImageContentSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImageContentSources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageContentSource> getImageContentSources() {
    return imageContentSources != null ? build(imageContentSources) : null;
  }
  public List<ImageContentSource> buildImageContentSources() {
    return imageContentSources != null ? build(imageContentSources) : null;
  }
  public ImageContentSource buildImageContentSource(Integer index) {
    return this.imageContentSources.get(index).build();
  }
  public ImageContentSource buildFirstImageContentSource() {
    return this.imageContentSources.get(0).build();
  }
  public ImageContentSource buildLastImageContentSource() {
    return this.imageContentSources.get(imageContentSources.size() - 1).build();
  }
  public ImageContentSource buildMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
    for (ImageContentSourceBuilder item: imageContentSources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
    for (ImageContentSourceBuilder item: imageContentSources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImageContentSources(List<ImageContentSource> imageContentSources) {
    if (this.imageContentSources != null) { _visitables.get("imageContentSources").removeAll(this.imageContentSources);}
    if (imageContentSources != null) {this.imageContentSources = new ArrayList(); for (ImageContentSource item : imageContentSources){this.addToImageContentSources(item);}} else { this.imageContentSources = null;} return (A) this;
  }
  public A withImageContentSources(io.fabric8.openshift.api.model.installer.v1.ImageContentSource... imageContentSources) {
    if (this.imageContentSources != null) {this.imageContentSources.clear();}
    if (imageContentSources != null) {for (ImageContentSource item :imageContentSources){ this.addToImageContentSources(item);}} return (A) this;
  }
  public Boolean hasImageContentSources() {
    return imageContentSources != null && !imageContentSources.isEmpty();
  }
  public InstallConfigFluent.ImageContentSourcesNested<A> addNewImageContentSource() {
    return new InstallConfigFluentImpl.ImageContentSourcesNestedImpl();
  }
  public InstallConfigFluent.ImageContentSourcesNested<A> addNewImageContentSourceLike(ImageContentSource item) {
    return new InstallConfigFluentImpl.ImageContentSourcesNestedImpl(-1, item);
  }
  public InstallConfigFluent.ImageContentSourcesNested<A> setNewImageContentSourceLike(Integer index,ImageContentSource item) {
    return new InstallConfigFluentImpl.ImageContentSourcesNestedImpl(index, item);
  }
  public InstallConfigFluent.ImageContentSourcesNested<A> editImageContentSource(Integer index) {
    if (imageContentSources.size() <= index) throw new RuntimeException("Can't edit imageContentSources. Index exceeds size.");
    return setNewImageContentSourceLike(index, buildImageContentSource(index));
  }
  public InstallConfigFluent.ImageContentSourcesNested<A> editFirstImageContentSource() {
    if (imageContentSources.size() == 0) throw new RuntimeException("Can't edit first imageContentSources. The list is empty.");
    return setNewImageContentSourceLike(0, buildImageContentSource(0));
  }
  public InstallConfigFluent.ImageContentSourcesNested<A> editLastImageContentSource() {
    int index = imageContentSources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imageContentSources. The list is empty.");
    return setNewImageContentSourceLike(index, buildImageContentSource(index));
  }
  public InstallConfigFluent.ImageContentSourcesNested<A> editMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imageContentSources.size();i++) { 
    if (predicate.test(imageContentSources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imageContentSources. No match found.");
    return setNewImageContentSourceLike(index, buildImageContentSource(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public InstallConfigFluent.MetadataNested<A> withNewMetadata() {
    return new InstallConfigFluentImpl.MetadataNestedImpl();
  }
  public InstallConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new InstallConfigFluentImpl.MetadataNestedImpl(item);
  }
  public InstallConfigFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public InstallConfigFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public InstallConfigFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNetworking instead.
   * @return The buildable object.
   */
  @Deprecated
  public Networking getNetworking() {
    return this.networking!=null ?this.networking.build():null;
  }
  public Networking buildNetworking() {
    return this.networking!=null ?this.networking.build():null;
  }
  public A withNetworking(Networking networking) {
    _visitables.get("networking").remove(this.networking);
    if (networking!=null){ this.networking= new NetworkingBuilder(networking); _visitables.get("networking").add(this.networking);} else { this.networking = null; _visitables.get("networking").remove(this.networking); } return (A) this;
  }
  public Boolean hasNetworking() {
    return this.networking != null;
  }
  public InstallConfigFluent.NetworkingNested<A> withNewNetworking() {
    return new InstallConfigFluentImpl.NetworkingNestedImpl();
  }
  public InstallConfigFluent.NetworkingNested<A> withNewNetworkingLike(Networking item) {
    return new InstallConfigFluentImpl.NetworkingNestedImpl(item);
  }
  public InstallConfigFluent.NetworkingNested<A> editNetworking() {
    return withNewNetworkingLike(getNetworking());
  }
  public InstallConfigFluent.NetworkingNested<A> editOrNewNetworking() {
    return withNewNetworkingLike(getNetworking() != null ? getNetworking(): new NetworkingBuilder().build());
  }
  public InstallConfigFluent.NetworkingNested<A> editOrNewNetworkingLike(Networking item) {
    return withNewNetworkingLike(getNetworking() != null ? getNetworking(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public Platform getPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  public Platform buildPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  public A withPlatform(Platform platform) {
    _visitables.get("platform").remove(this.platform);
    if (platform!=null){ this.platform= new PlatformBuilder(platform); _visitables.get("platform").add(this.platform);} else { this.platform = null; _visitables.get("platform").remove(this.platform); } return (A) this;
  }
  public Boolean hasPlatform() {
    return this.platform != null;
  }
  public InstallConfigFluent.PlatformNested<A> withNewPlatform() {
    return new InstallConfigFluentImpl.PlatformNestedImpl();
  }
  public InstallConfigFluent.PlatformNested<A> withNewPlatformLike(Platform item) {
    return new InstallConfigFluentImpl.PlatformNestedImpl(item);
  }
  public InstallConfigFluent.PlatformNested<A> editPlatform() {
    return withNewPlatformLike(getPlatform());
  }
  public InstallConfigFluent.PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(getPlatform() != null ? getPlatform(): new PlatformBuilder().build());
  }
  public InstallConfigFluent.PlatformNested<A> editOrNewPlatformLike(Platform item) {
    return withNewPlatformLike(getPlatform() != null ? getPlatform(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildProxy instead.
   * @return The buildable object.
   */
  @Deprecated
  public Proxy getProxy() {
    return this.proxy!=null ?this.proxy.build():null;
  }
  public Proxy buildProxy() {
    return this.proxy!=null ?this.proxy.build():null;
  }
  public A withProxy(Proxy proxy) {
    _visitables.get("proxy").remove(this.proxy);
    if (proxy!=null){ this.proxy= new ProxyBuilder(proxy); _visitables.get("proxy").add(this.proxy);} else { this.proxy = null; _visitables.get("proxy").remove(this.proxy); } return (A) this;
  }
  public Boolean hasProxy() {
    return this.proxy != null;
  }
  public A withNewProxy(String httpProxy,String httpsProxy,String noProxy) {
    return (A)withProxy(new Proxy(httpProxy, httpsProxy, noProxy));
  }
  public InstallConfigFluent.ProxyNested<A> withNewProxy() {
    return new InstallConfigFluentImpl.ProxyNestedImpl();
  }
  public InstallConfigFluent.ProxyNested<A> withNewProxyLike(Proxy item) {
    return new InstallConfigFluentImpl.ProxyNestedImpl(item);
  }
  public InstallConfigFluent.ProxyNested<A> editProxy() {
    return withNewProxyLike(getProxy());
  }
  public InstallConfigFluent.ProxyNested<A> editOrNewProxy() {
    return withNewProxyLike(getProxy() != null ? getProxy(): new ProxyBuilder().build());
  }
  public InstallConfigFluent.ProxyNested<A> editOrNewProxyLike(Proxy item) {
    return withNewProxyLike(getProxy() != null ? getProxy(): item);
  }
  public String getPublish() {
    return this.publish;
  }
  public A withPublish(String publish) {
    this.publish=publish; return (A) this;
  }
  public Boolean hasPublish() {
    return this.publish != null;
  }
  public String getPullSecret() {
    return this.pullSecret;
  }
  public A withPullSecret(String pullSecret) {
    this.pullSecret=pullSecret; return (A) this;
  }
  public Boolean hasPullSecret() {
    return this.pullSecret != null;
  }
  public String getSshKey() {
    return this.sshKey;
  }
  public A withSshKey(String sshKey) {
    this.sshKey=sshKey; return (A) this;
  }
  public Boolean hasSshKey() {
    return this.sshKey != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InstallConfigFluentImpl that = (InstallConfigFluentImpl) o;
    if (additionalTrustBundle != null ? !additionalTrustBundle.equals(that.additionalTrustBundle) :that.additionalTrustBundle != null) return false;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (baseDomain != null ? !baseDomain.equals(that.baseDomain) :that.baseDomain != null) return false;
    if (bootstrapInPlace != null ? !bootstrapInPlace.equals(that.bootstrapInPlace) :that.bootstrapInPlace != null) return false;
    if (compute != null ? !compute.equals(that.compute) :that.compute != null) return false;
    if (controlPlane != null ? !controlPlane.equals(that.controlPlane) :that.controlPlane != null) return false;
    if (credentialsMode != null ? !credentialsMode.equals(that.credentialsMode) :that.credentialsMode != null) return false;
    if (fips != null ? !fips.equals(that.fips) :that.fips != null) return false;
    if (imageContentSources != null ? !imageContentSources.equals(that.imageContentSources) :that.imageContentSources != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (networking != null ? !networking.equals(that.networking) :that.networking != null) return false;
    if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
    if (proxy != null ? !proxy.equals(that.proxy) :that.proxy != null) return false;
    if (publish != null ? !publish.equals(that.publish) :that.publish != null) return false;
    if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
    if (sshKey != null ? !sshKey.equals(that.sshKey) :that.sshKey != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalTrustBundle,  apiVersion,  baseDomain,  bootstrapInPlace,  compute,  controlPlane,  credentialsMode,  fips,  imageContentSources,  kind,  metadata,  networking,  platform,  proxy,  publish,  pullSecret,  sshKey,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalTrustBundle != null) { sb.append("additionalTrustBundle:"); sb.append(additionalTrustBundle + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (baseDomain != null) { sb.append("baseDomain:"); sb.append(baseDomain + ","); }
    if (bootstrapInPlace != null) { sb.append("bootstrapInPlace:"); sb.append(bootstrapInPlace + ","); }
    if (compute != null && !compute.isEmpty()) { sb.append("compute:"); sb.append(compute + ","); }
    if (controlPlane != null) { sb.append("controlPlane:"); sb.append(controlPlane + ","); }
    if (credentialsMode != null) { sb.append("credentialsMode:"); sb.append(credentialsMode + ","); }
    if (fips != null) { sb.append("fips:"); sb.append(fips + ","); }
    if (imageContentSources != null && !imageContentSources.isEmpty()) { sb.append("imageContentSources:"); sb.append(imageContentSources + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (networking != null) { sb.append("networking:"); sb.append(networking + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (proxy != null) { sb.append("proxy:"); sb.append(proxy + ","); }
    if (publish != null) { sb.append("publish:"); sb.append(publish + ","); }
    if (pullSecret != null) { sb.append("pullSecret:"); sb.append(pullSecret + ","); }
    if (sshKey != null) { sb.append("sshKey:"); sb.append(sshKey + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withFips() {
    return withFips(true);
  }
  class BootstrapInPlaceNestedImpl<N> extends BootstrapInPlaceFluentImpl<InstallConfigFluent.BootstrapInPlaceNested<N>> implements InstallConfigFluent.BootstrapInPlaceNested<N>,Nested<N>{
    BootstrapInPlaceNestedImpl(BootstrapInPlace item) {
      this.builder = new BootstrapInPlaceBuilder(this, item);
    }
    BootstrapInPlaceNestedImpl() {
      this.builder = new BootstrapInPlaceBuilder(this);
    }
    BootstrapInPlaceBuilder builder;
    public N and() {
      return (N) InstallConfigFluentImpl.this.withBootstrapInPlace(builder.build());
    }
    public N endBootstrapInPlace() {
      return and();
    }
    
  }
  class ComputeNestedImpl<N> extends MachinePoolFluentImpl<InstallConfigFluent.ComputeNested<N>> implements InstallConfigFluent.ComputeNested<N>,Nested<N>{
    ComputeNestedImpl(Integer index,MachinePool item) {
      this.index = index;
      this.builder = new MachinePoolBuilder(this, item);
    }
    ComputeNestedImpl() {
      this.index = -1;
      this.builder = new MachinePoolBuilder(this);
    }
    MachinePoolBuilder builder;
    Integer index;
    public N and() {
      return (N) InstallConfigFluentImpl.this.setToCompute(index,builder.build());
    }
    public N endCompute() {
      return and();
    }
    
  }
  class ControlPlaneNestedImpl<N> extends MachinePoolFluentImpl<InstallConfigFluent.ControlPlaneNested<N>> implements InstallConfigFluent.ControlPlaneNested<N>,Nested<N>{
    ControlPlaneNestedImpl(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    ControlPlaneNestedImpl() {
      this.builder = new MachinePoolBuilder(this);
    }
    MachinePoolBuilder builder;
    public N and() {
      return (N) InstallConfigFluentImpl.this.withControlPlane(builder.build());
    }
    public N endControlPlane() {
      return and();
    }
    
  }
  class ImageContentSourcesNestedImpl<N> extends ImageContentSourceFluentImpl<InstallConfigFluent.ImageContentSourcesNested<N>> implements InstallConfigFluent.ImageContentSourcesNested<N>,Nested<N>{
    ImageContentSourcesNestedImpl(Integer index,ImageContentSource item) {
      this.index = index;
      this.builder = new ImageContentSourceBuilder(this, item);
    }
    ImageContentSourcesNestedImpl() {
      this.index = -1;
      this.builder = new ImageContentSourceBuilder(this);
    }
    ImageContentSourceBuilder builder;
    Integer index;
    public N and() {
      return (N) InstallConfigFluentImpl.this.setToImageContentSources(index,builder.build());
    }
    public N endImageContentSource() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<InstallConfigFluent.MetadataNested<N>> implements InstallConfigFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) InstallConfigFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class NetworkingNestedImpl<N> extends NetworkingFluentImpl<InstallConfigFluent.NetworkingNested<N>> implements InstallConfigFluent.NetworkingNested<N>,Nested<N>{
    NetworkingNestedImpl(Networking item) {
      this.builder = new NetworkingBuilder(this, item);
    }
    NetworkingNestedImpl() {
      this.builder = new NetworkingBuilder(this);
    }
    NetworkingBuilder builder;
    public N and() {
      return (N) InstallConfigFluentImpl.this.withNetworking(builder.build());
    }
    public N endNetworking() {
      return and();
    }
    
  }
  class PlatformNestedImpl<N> extends PlatformFluentImpl<InstallConfigFluent.PlatformNested<N>> implements InstallConfigFluent.PlatformNested<N>,Nested<N>{
    PlatformNestedImpl(Platform item) {
      this.builder = new PlatformBuilder(this, item);
    }
    PlatformNestedImpl() {
      this.builder = new PlatformBuilder(this);
    }
    PlatformBuilder builder;
    public N and() {
      return (N) InstallConfigFluentImpl.this.withPlatform(builder.build());
    }
    public N endPlatform() {
      return and();
    }
    
  }
  class ProxyNestedImpl<N> extends ProxyFluentImpl<InstallConfigFluent.ProxyNested<N>> implements InstallConfigFluent.ProxyNested<N>,Nested<N>{
    ProxyNestedImpl(Proxy item) {
      this.builder = new ProxyBuilder(this, item);
    }
    ProxyNestedImpl() {
      this.builder = new ProxyBuilder(this);
    }
    ProxyBuilder builder;
    public N and() {
      return (N) InstallConfigFluentImpl.this.withProxy(builder.build());
    }
    public N endProxy() {
      return and();
    }
    
  }
  
}