package io.fabric8.openshift.api.model.installer.alibabacloud.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>> extends BaseFluent<A> implements MachinePoolFluent<A>{
  public MachinePoolFluentImpl() {
  }
  public MachinePoolFluentImpl(MachinePool instance) {
    if (instance != null) {
      this.withImageID(instance.getImageID());
      this.withInstanceType(instance.getInstanceType());
      this.withSystemDiskCategory(instance.getSystemDiskCategory());
      this.withSystemDiskSize(instance.getSystemDiskSize());
      this.withZones(instance.getZones());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String imageID;
  private String instanceType;
  private String systemDiskCategory;
  private Integer systemDiskSize;
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public String getImageID() {
    return this.imageID;
  }
  public A withImageID(String imageID) {
    this.imageID=imageID; return (A) this;
  }
  public Boolean hasImageID() {
    return this.imageID != null;
  }
  public String getInstanceType() {
    return this.instanceType;
  }
  public A withInstanceType(String instanceType) {
    this.instanceType=instanceType; return (A) this;
  }
  public Boolean hasInstanceType() {
    return this.instanceType != null;
  }
  public String getSystemDiskCategory() {
    return this.systemDiskCategory;
  }
  public A withSystemDiskCategory(String systemDiskCategory) {
    this.systemDiskCategory=systemDiskCategory; return (A) this;
  }
  public Boolean hasSystemDiskCategory() {
    return this.systemDiskCategory != null;
  }
  public Integer getSystemDiskSize() {
    return this.systemDiskSize;
  }
  public A withSystemDiskSize(Integer systemDiskSize) {
    this.systemDiskSize=systemDiskSize; return (A) this;
  }
  public Boolean hasSystemDiskSize() {
    return this.systemDiskSize != null;
  }
  public A addToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  public A setToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A removeFromZones(java.lang.String... items) {
    for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
  }
  public A removeAllFromZones(Collection<String> items) {
    for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
  }
  public List<String> getZones() {
    return this.zones;
  }
  public String getZone(int index) {
    return this.zones.get(index);
  }
  public String getFirstZone() {
    return this.zones.get(0);
  }
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  public String getMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withZones(List<String> zones) {
    if (zones != null) {this.zones = new ArrayList(); for (String item : zones){this.addToZones(item);}} else { this.zones = null;} return (A) this;
  }
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {this.zones.clear(); _visitables.remove("zones"); }
    if (zones != null) {for (String item :zones){ this.addToZones(item);}} return (A) this;
  }
  public Boolean hasZones() {
    return zones != null && !zones.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluentImpl that = (MachinePoolFluentImpl) o;
    if (!java.util.Objects.equals(imageID, that.imageID)) return false;

    if (!java.util.Objects.equals(instanceType, that.instanceType)) return false;

    if (!java.util.Objects.equals(systemDiskCategory, that.systemDiskCategory)) return false;

    if (!java.util.Objects.equals(systemDiskSize, that.systemDiskSize)) return false;

    if (!java.util.Objects.equals(zones, that.zones)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(imageID,  instanceType,  systemDiskCategory,  systemDiskSize,  zones,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (imageID != null) { sb.append("imageID:"); sb.append(imageID + ","); }
    if (instanceType != null) { sb.append("instanceType:"); sb.append(instanceType + ","); }
    if (systemDiskCategory != null) { sb.append("systemDiskCategory:"); sb.append(systemDiskCategory + ","); }
    if (systemDiskSize != null) { sb.append("systemDiskSize:"); sb.append(systemDiskSize + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}