package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluentImpl<A extends PlatformFluent<A>> extends BaseFluent<A> implements PlatformFluent<A>{
  public PlatformFluentImpl() {
  }
  public PlatformFluentImpl(Platform instance) {
    if (instance != null) {
      this.withAmiID(instance.getAmiID());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withExperimentalPropagateUserTags(instance.getExperimentalPropagateUserTags());
      this.withHostedZone(instance.getHostedZone());
      this.withRegion(instance.getRegion());
      this.withServiceEndpoints(instance.getServiceEndpoints());
      this.withSubnets(instance.getSubnets());
      this.withUserTags(instance.getUserTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String amiID;
  private MachinePoolBuilder defaultMachinePlatform;
  private Boolean experimentalPropagateUserTags;
  private String hostedZone;
  private String region;
  private ArrayList<ServiceEndpointBuilder> serviceEndpoints = new ArrayList<ServiceEndpointBuilder>();
  private List<String> subnets = new ArrayList<String>();
  private Map<String,String> userTags;
  private Map<String,Object> additionalProperties;
  public String getAmiID() {
    return this.amiID;
  }
  public A withAmiID(String amiID) {
    this.amiID=amiID; return (A) this;
  }
  public Boolean hasAmiID() {
    return this.amiID != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} else { this.defaultMachinePlatform = null; _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform); } return (A) this;
  }
  public Boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl();
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl(item);
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform());
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): new MachinePoolBuilder().build());
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): item);
  }
  public Boolean getExperimentalPropagateUserTags() {
    return this.experimentalPropagateUserTags;
  }
  public A withExperimentalPropagateUserTags(Boolean experimentalPropagateUserTags) {
    this.experimentalPropagateUserTags=experimentalPropagateUserTags; return (A) this;
  }
  public Boolean hasExperimentalPropagateUserTags() {
    return this.experimentalPropagateUserTags != null;
  }
  public String getHostedZone() {
    return this.hostedZone;
  }
  public A withHostedZone(String hostedZone) {
    this.hostedZone=hostedZone; return (A) this;
  }
  public Boolean hasHostedZone() {
    return this.hostedZone != null;
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public A addToServiceEndpoints(int index,ServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<ServiceEndpointBuilder>();}
    ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
    if (index < 0 || index >= serviceEndpoints.size()) { _visitables.get("serviceEndpoints").add(builder); serviceEndpoints.add(builder); } else { _visitables.get("serviceEndpoints").add(index, builder); serviceEndpoints.add(index, builder);}
    return (A)this;
  }
  public A setToServiceEndpoints(int index,ServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<ServiceEndpointBuilder>();}
    ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
    if (index < 0 || index >= serviceEndpoints.size()) { _visitables.get("serviceEndpoints").add(builder); serviceEndpoints.add(builder); } else { _visitables.get("serviceEndpoints").set(index, builder); serviceEndpoints.set(index, builder);}
    return (A)this;
  }
  public A addToServiceEndpoints(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint... items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<ServiceEndpointBuilder>();}
    for (ServiceEndpoint item : items) {ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  public A addAllToServiceEndpoints(Collection<ServiceEndpoint> items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<ServiceEndpointBuilder>();}
    for (ServiceEndpoint item : items) {ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  public A removeFromServiceEndpoints(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint... items) {
    for (ServiceEndpoint item : items) {ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceEndpoints(Collection<ServiceEndpoint> items) {
    for (ServiceEndpoint item : items) {ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceEndpoints(Predicate<ServiceEndpointBuilder> predicate) {
    if (serviceEndpoints == null) return (A) this;
    final Iterator<ServiceEndpointBuilder> each = serviceEndpoints.iterator();
    final List visitables = _visitables.get("serviceEndpoints");
    while (each.hasNext()) {
      ServiceEndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildServiceEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServiceEndpoint> getServiceEndpoints() {
    return serviceEndpoints != null ? build(serviceEndpoints) : null;
  }
  public List<ServiceEndpoint> buildServiceEndpoints() {
    return serviceEndpoints != null ? build(serviceEndpoints) : null;
  }
  public ServiceEndpoint buildServiceEndpoint(int index) {
    return this.serviceEndpoints.get(index).build();
  }
  public ServiceEndpoint buildFirstServiceEndpoint() {
    return this.serviceEndpoints.get(0).build();
  }
  public ServiceEndpoint buildLastServiceEndpoint() {
    return this.serviceEndpoints.get(serviceEndpoints.size() - 1).build();
  }
  public ServiceEndpoint buildMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
    for (ServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
    for (ServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceEndpoints(List<ServiceEndpoint> serviceEndpoints) {
    if (this.serviceEndpoints != null) { _visitables.get("serviceEndpoints").clear();}
    if (serviceEndpoints != null) {this.serviceEndpoints = new ArrayList(); for (ServiceEndpoint item : serviceEndpoints){this.addToServiceEndpoints(item);}} else { this.serviceEndpoints = null;} return (A) this;
  }
  public A withServiceEndpoints(io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint... serviceEndpoints) {
    if (this.serviceEndpoints != null) {this.serviceEndpoints.clear(); _visitables.remove("serviceEndpoints"); }
    if (serviceEndpoints != null) {for (ServiceEndpoint item :serviceEndpoints){ this.addToServiceEndpoints(item);}} return (A) this;
  }
  public Boolean hasServiceEndpoints() {
    return serviceEndpoints != null && !serviceEndpoints.isEmpty();
  }
  public A addNewServiceEndpoint(String name,String url) {
    return (A)addToServiceEndpoints(new ServiceEndpoint(name, url));
  }
  public PlatformFluentImpl.ServiceEndpointsNested<A> addNewServiceEndpoint() {
    return new PlatformFluentImpl.ServiceEndpointsNestedImpl();
  }
  public PlatformFluentImpl.ServiceEndpointsNested<A> addNewServiceEndpointLike(ServiceEndpoint item) {
    return new PlatformFluentImpl.ServiceEndpointsNestedImpl(-1, item);
  }
  public PlatformFluentImpl.ServiceEndpointsNested<A> setNewServiceEndpointLike(int index,ServiceEndpoint item) {
    return new PlatformFluentImpl.ServiceEndpointsNestedImpl(index, item);
  }
  public PlatformFluentImpl.ServiceEndpointsNested<A> editServiceEndpoint(int index) {
    if (serviceEndpoints.size() <= index) throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public PlatformFluentImpl.ServiceEndpointsNested<A> editFirstServiceEndpoint() {
    if (serviceEndpoints.size() == 0) throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(0, buildServiceEndpoint(0));
  }
  public PlatformFluentImpl.ServiceEndpointsNested<A> editLastServiceEndpoint() {
    int index = serviceEndpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public PlatformFluentImpl.ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<serviceEndpoints.size();i++) { 
    if (predicate.test(serviceEndpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  public A addToSubnets(int index,String item) {
    if (this.subnets == null) {this.subnets = new ArrayList<String>();}
    this.subnets.add(index, item);
    return (A)this;
  }
  public A setToSubnets(int index,String item) {
    if (this.subnets == null) {this.subnets = new ArrayList<String>();}
    this.subnets.set(index, item); return (A)this;
  }
  public A addToSubnets(java.lang.String... items) {
    if (this.subnets == null) {this.subnets = new ArrayList<String>();}
    for (String item : items) {this.subnets.add(item);} return (A)this;
  }
  public A addAllToSubnets(Collection<String> items) {
    if (this.subnets == null) {this.subnets = new ArrayList<String>();}
    for (String item : items) {this.subnets.add(item);} return (A)this;
  }
  public A removeFromSubnets(java.lang.String... items) {
    for (String item : items) {if (this.subnets!= null){ this.subnets.remove(item);}} return (A)this;
  }
  public A removeAllFromSubnets(Collection<String> items) {
    for (String item : items) {if (this.subnets!= null){ this.subnets.remove(item);}} return (A)this;
  }
  public List<String> getSubnets() {
    return this.subnets;
  }
  public String getSubnet(int index) {
    return this.subnets.get(index);
  }
  public String getFirstSubnet() {
    return this.subnets.get(0);
  }
  public String getLastSubnet() {
    return this.subnets.get(subnets.size() - 1);
  }
  public String getMatchingSubnet(Predicate<String> predicate) {
    for (String item: subnets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSubnet(Predicate<String> predicate) {
    for (String item: subnets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubnets(List<String> subnets) {
    if (subnets != null) {this.subnets = new ArrayList(); for (String item : subnets){this.addToSubnets(item);}} else { this.subnets = null;} return (A) this;
  }
  public A withSubnets(java.lang.String... subnets) {
    if (this.subnets != null) {this.subnets.clear(); _visitables.remove("subnets"); }
    if (subnets != null) {for (String item :subnets){ this.addToSubnets(item);}} return (A) this;
  }
  public Boolean hasSubnets() {
    return subnets != null && !subnets.isEmpty();
  }
  public A addToUserTags(String key,String value) {
    if(this.userTags == null && key != null && value != null) { this.userTags = new LinkedHashMap(); }
    if(key != null && value != null) {this.userTags.put(key, value);} return (A)this;
  }
  public A addToUserTags(Map<String,String> map) {
    if(this.userTags == null && map != null) { this.userTags = new LinkedHashMap(); }
    if(map != null) { this.userTags.putAll(map);} return (A)this;
  }
  public A removeFromUserTags(String key) {
    if(this.userTags == null) { return (A) this; }
    if(key != null && this.userTags != null) {this.userTags.remove(key);} return (A)this;
  }
  public A removeFromUserTags(Map<String,String> map) {
    if(this.userTags == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.userTags != null){this.userTags.remove(key);}}} return (A)this;
  }
  public Map<String,String> getUserTags() {
    return this.userTags;
  }
  public <K,V>A withUserTags(Map<String,String> userTags) {
    if (userTags == null) { this.userTags =  null;} else {this.userTags = new LinkedHashMap(userTags);} return (A) this;
  }
  public Boolean hasUserTags() {
    return this.userTags != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluentImpl that = (PlatformFluentImpl) o;
    if (!java.util.Objects.equals(amiID, that.amiID)) return false;

    if (!java.util.Objects.equals(defaultMachinePlatform, that.defaultMachinePlatform)) return false;

    if (!java.util.Objects.equals(experimentalPropagateUserTags, that.experimentalPropagateUserTags)) return false;

    if (!java.util.Objects.equals(hostedZone, that.hostedZone)) return false;

    if (!java.util.Objects.equals(region, that.region)) return false;

    if (!java.util.Objects.equals(serviceEndpoints, that.serviceEndpoints)) return false;

    if (!java.util.Objects.equals(subnets, that.subnets)) return false;

    if (!java.util.Objects.equals(userTags, that.userTags)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(amiID,  defaultMachinePlatform,  experimentalPropagateUserTags,  hostedZone,  region,  serviceEndpoints,  subnets,  userTags,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (amiID != null) { sb.append("amiID:"); sb.append(amiID + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (experimentalPropagateUserTags != null) { sb.append("experimentalPropagateUserTags:"); sb.append(experimentalPropagateUserTags + ","); }
    if (hostedZone != null) { sb.append("hostedZone:"); sb.append(hostedZone + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (serviceEndpoints != null) { sb.append("serviceEndpoints:"); sb.append(serviceEndpoints + ","); }
    if (subnets != null && !subnets.isEmpty()) { sb.append("subnets:"); sb.append(subnets + ","); }
    if (userTags != null && !userTags.isEmpty()) { sb.append("userTags:"); sb.append(userTags + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withExperimentalPropagateUserTags() {
    return withExperimentalPropagateUserTags(true);
  }
  class DefaultMachinePlatformNestedImpl<N> extends MachinePoolFluentImpl<PlatformFluentImpl.DefaultMachinePlatformNested<N>> implements PlatformFluentImpl.DefaultMachinePlatformNested<N>,Nested<N>{
    DefaultMachinePlatformNestedImpl(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    DefaultMachinePlatformNestedImpl() {
      this.builder = new MachinePoolBuilder(this);
    }
    MachinePoolBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withDefaultMachinePlatform(builder.build());
    }
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  }
  class ServiceEndpointsNestedImpl<N> extends ServiceEndpointFluentImpl<PlatformFluentImpl.ServiceEndpointsNested<N>> implements PlatformFluentImpl.ServiceEndpointsNested<N>,Nested<N>{
    ServiceEndpointsNestedImpl(int index,ServiceEndpoint item) {
      this.index = index;
      this.builder = new ServiceEndpointBuilder(this, item);
    }
    ServiceEndpointsNestedImpl() {
      this.index = -1;
      this.builder = new ServiceEndpointBuilder(this);
    }
    ServiceEndpointBuilder builder;
    int index;
    public N and() {
      return (N) PlatformFluentImpl.this.setToServiceEndpoints(index,builder.build());
    }
    public N endServiceEndpoint() {
      return and();
    }
    
  }
  
}