package io.fabric8.openshift.api.model.installer.baremetal.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HostBuilder extends HostFluentImpl<HostBuilder> implements VisitableBuilder<Host,HostBuilder>{
  public HostBuilder() {
    this(false);
  }
  public HostBuilder(Boolean validationEnabled) {
    this(new Host(), validationEnabled);
  }
  public HostBuilder(HostFluent<?> fluent) {
    this(fluent, false);
  }
  public HostBuilder(HostFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Host(), validationEnabled);
  }
  public HostBuilder(HostFluent<?> fluent,Host instance) {
    this(fluent, instance, false);
  }
  public HostBuilder(HostFluent<?> fluent,Host instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBmc(instance.getBmc());
      fluent.withBootMACAddress(instance.getBootMACAddress());
      fluent.withBootMode(instance.getBootMode());
      fluent.withHardwareProfile(instance.getHardwareProfile());
      fluent.withName(instance.getName());
      fluent.withNetworkConfig(instance.getNetworkConfig());
      fluent.withRole(instance.getRole());
      fluent.withRootDeviceHints(instance.getRootDeviceHints());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HostBuilder(Host instance) {
    this(instance,false);
  }
  public HostBuilder(Host instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBmc(instance.getBmc());
      this.withBootMACAddress(instance.getBootMACAddress());
      this.withBootMode(instance.getBootMode());
      this.withHardwareProfile(instance.getHardwareProfile());
      this.withName(instance.getName());
      this.withNetworkConfig(instance.getNetworkConfig());
      this.withRole(instance.getRole());
      this.withRootDeviceHints(instance.getRootDeviceHints());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HostFluent<?> fluent;
  Boolean validationEnabled;
  public Host build() {
    Host buildable = new Host(fluent.getBmc(),fluent.getBootMACAddress(),fluent.getBootMode(),fluent.getHardwareProfile(),fluent.getName(),fluent.getNetworkConfig(),fluent.getRole(),fluent.getRootDeviceHints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}