package io.fabric8.openshift.api.model.installer.ibmcloud.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BootVolumeBuilder extends BootVolumeFluentImpl<BootVolumeBuilder> implements VisitableBuilder<BootVolume,BootVolumeBuilder>{
  public BootVolumeBuilder() {
    this(false);
  }
  public BootVolumeBuilder(Boolean validationEnabled) {
    this(new BootVolume(), validationEnabled);
  }
  public BootVolumeBuilder(BootVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public BootVolumeBuilder(BootVolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BootVolume(), validationEnabled);
  }
  public BootVolumeBuilder(BootVolumeFluent<?> fluent,BootVolume instance) {
    this(fluent, instance, false);
  }
  public BootVolumeBuilder(BootVolumeFluent<?> fluent,BootVolume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEncryptionKey(instance.getEncryptionKey());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BootVolumeBuilder(BootVolume instance) {
    this(instance,false);
  }
  public BootVolumeBuilder(BootVolume instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEncryptionKey(instance.getEncryptionKey());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BootVolumeFluent<?> fluent;
  Boolean validationEnabled;
  public BootVolume build() {
    BootVolume buildable = new BootVolume(fluent.getEncryptionKey());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}