package io.fabric8.openshift.api.model.installer.ibmcloud.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluentImpl<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withRegion(instance.getRegion());
      fluent.withResourceGroupName(instance.getResourceGroupName());
      fluent.withSubnets(instance.getSubnets());
      fluent.withVpc(instance.getVpc());
      fluent.withVpcResourceGroupName(instance.getVpcResourceGroupName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withRegion(instance.getRegion());
      this.withResourceGroupName(instance.getResourceGroupName());
      this.withSubnets(instance.getSubnets());
      this.withVpc(instance.getVpc());
      this.withVpcResourceGroupName(instance.getVpcResourceGroupName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getDefaultMachinePlatform(),fluent.getRegion(),fluent.getResourceGroupName(),fluent.getSubnets(),fluent.getVpc(),fluent.getVpcResourceGroupName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}