package io.fabric8.openshift.api.model.installer.ibmcloud.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluentImpl<A extends PlatformFluent<A>> extends BaseFluent<A> implements PlatformFluent<A>{
  public PlatformFluentImpl() {
  }
  public PlatformFluentImpl(Platform instance) {
    if (instance != null) {
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withRegion(instance.getRegion());
      this.withResourceGroupName(instance.getResourceGroupName());
      this.withSubnets(instance.getSubnets());
      this.withVpc(instance.getVpc());
      this.withVpcResourceGroupName(instance.getVpcResourceGroupName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private MachinePoolBuilder defaultMachinePlatform;
  private String region;
  private String resourceGroupName;
  private List<String> subnets = new ArrayList<String>();
  private String vpc;
  private String vpcResourceGroupName;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} else { this.defaultMachinePlatform = null; _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform); } return (A) this;
  }
  public Boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl();
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl(item);
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform());
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): new MachinePoolBuilder().build());
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): item);
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public String getResourceGroupName() {
    return this.resourceGroupName;
  }
  public A withResourceGroupName(String resourceGroupName) {
    this.resourceGroupName=resourceGroupName; return (A) this;
  }
  public Boolean hasResourceGroupName() {
    return this.resourceGroupName != null;
  }
  public A addToSubnets(int index,String item) {
    if (this.subnets == null) {this.subnets = new ArrayList<String>();}
    this.subnets.add(index, item);
    return (A)this;
  }
  public A setToSubnets(int index,String item) {
    if (this.subnets == null) {this.subnets = new ArrayList<String>();}
    this.subnets.set(index, item); return (A)this;
  }
  public A addToSubnets(java.lang.String... items) {
    if (this.subnets == null) {this.subnets = new ArrayList<String>();}
    for (String item : items) {this.subnets.add(item);} return (A)this;
  }
  public A addAllToSubnets(Collection<String> items) {
    if (this.subnets == null) {this.subnets = new ArrayList<String>();}
    for (String item : items) {this.subnets.add(item);} return (A)this;
  }
  public A removeFromSubnets(java.lang.String... items) {
    for (String item : items) {if (this.subnets!= null){ this.subnets.remove(item);}} return (A)this;
  }
  public A removeAllFromSubnets(Collection<String> items) {
    for (String item : items) {if (this.subnets!= null){ this.subnets.remove(item);}} return (A)this;
  }
  public List<String> getSubnets() {
    return this.subnets;
  }
  public String getSubnet(int index) {
    return this.subnets.get(index);
  }
  public String getFirstSubnet() {
    return this.subnets.get(0);
  }
  public String getLastSubnet() {
    return this.subnets.get(subnets.size() - 1);
  }
  public String getMatchingSubnet(Predicate<String> predicate) {
    for (String item: subnets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSubnet(Predicate<String> predicate) {
    for (String item: subnets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubnets(List<String> subnets) {
    if (subnets != null) {this.subnets = new ArrayList(); for (String item : subnets){this.addToSubnets(item);}} else { this.subnets = null;} return (A) this;
  }
  public A withSubnets(java.lang.String... subnets) {
    if (this.subnets != null) {this.subnets.clear(); _visitables.remove("subnets"); }
    if (subnets != null) {for (String item :subnets){ this.addToSubnets(item);}} return (A) this;
  }
  public Boolean hasSubnets() {
    return subnets != null && !subnets.isEmpty();
  }
  public String getVpc() {
    return this.vpc;
  }
  public A withVpc(String vpc) {
    this.vpc=vpc; return (A) this;
  }
  public Boolean hasVpc() {
    return this.vpc != null;
  }
  public String getVpcResourceGroupName() {
    return this.vpcResourceGroupName;
  }
  public A withVpcResourceGroupName(String vpcResourceGroupName) {
    this.vpcResourceGroupName=vpcResourceGroupName; return (A) this;
  }
  public Boolean hasVpcResourceGroupName() {
    return this.vpcResourceGroupName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluentImpl that = (PlatformFluentImpl) o;
    if (!java.util.Objects.equals(defaultMachinePlatform, that.defaultMachinePlatform)) return false;

    if (!java.util.Objects.equals(region, that.region)) return false;

    if (!java.util.Objects.equals(resourceGroupName, that.resourceGroupName)) return false;

    if (!java.util.Objects.equals(subnets, that.subnets)) return false;

    if (!java.util.Objects.equals(vpc, that.vpc)) return false;

    if (!java.util.Objects.equals(vpcResourceGroupName, that.vpcResourceGroupName)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(defaultMachinePlatform,  region,  resourceGroupName,  subnets,  vpc,  vpcResourceGroupName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (resourceGroupName != null) { sb.append("resourceGroupName:"); sb.append(resourceGroupName + ","); }
    if (subnets != null && !subnets.isEmpty()) { sb.append("subnets:"); sb.append(subnets + ","); }
    if (vpc != null) { sb.append("vpc:"); sb.append(vpc + ","); }
    if (vpcResourceGroupName != null) { sb.append("vpcResourceGroupName:"); sb.append(vpcResourceGroupName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DefaultMachinePlatformNestedImpl<N> extends MachinePoolFluentImpl<PlatformFluentImpl.DefaultMachinePlatformNested<N>> implements PlatformFluentImpl.DefaultMachinePlatformNested<N>,Nested<N>{
    DefaultMachinePlatformNestedImpl(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    DefaultMachinePlatformNestedImpl() {
      this.builder = new MachinePoolBuilder(this);
    }
    MachinePoolBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withDefaultMachinePlatform(builder.build());
    }
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  }
  
}