package io.fabric8.openshift.api.model.installer.libvirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DnsmasqOptionBuilder extends DnsmasqOptionFluentImpl<DnsmasqOptionBuilder> implements VisitableBuilder<DnsmasqOption,DnsmasqOptionBuilder>{
  public DnsmasqOptionBuilder() {
    this(false);
  }
  public DnsmasqOptionBuilder(Boolean validationEnabled) {
    this(new DnsmasqOption(), validationEnabled);
  }
  public DnsmasqOptionBuilder(DnsmasqOptionFluent<?> fluent) {
    this(fluent, false);
  }
  public DnsmasqOptionBuilder(DnsmasqOptionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DnsmasqOption(), validationEnabled);
  }
  public DnsmasqOptionBuilder(DnsmasqOptionFluent<?> fluent,DnsmasqOption instance) {
    this(fluent, instance, false);
  }
  public DnsmasqOptionBuilder(DnsmasqOptionFluent<?> fluent,DnsmasqOption instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DnsmasqOptionBuilder(DnsmasqOption instance) {
    this(instance,false);
  }
  public DnsmasqOptionBuilder(DnsmasqOption instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DnsmasqOptionFluent<?> fluent;
  Boolean validationEnabled;
  public DnsmasqOption build() {
    DnsmasqOption buildable = new DnsmasqOption(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}