package io.fabric8.openshift.api.model.installer.libvirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkBuilder extends NetworkFluentImpl<NetworkBuilder> implements VisitableBuilder<Network,NetworkBuilder>{
  public NetworkBuilder() {
    this(false);
  }
  public NetworkBuilder(Boolean validationEnabled) {
    this(new Network(), validationEnabled);
  }
  public NetworkBuilder(NetworkFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkBuilder(NetworkFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Network(), validationEnabled);
  }
  public NetworkBuilder(NetworkFluent<?> fluent,Network instance) {
    this(fluent, instance, false);
  }
  public NetworkBuilder(NetworkFluent<?> fluent,Network instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDnsmasqOptions(instance.getDnsmasqOptions());
      fluent.withIf(instance.getIf());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkBuilder(Network instance) {
    this(instance,false);
  }
  public NetworkBuilder(Network instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDnsmasqOptions(instance.getDnsmasqOptions());
      this.withIf(instance.getIf());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkFluent<?> fluent;
  Boolean validationEnabled;
  public Network build() {
    Network buildable = new Network(fluent.getDnsmasqOptions(),fluent.getIf());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}