package io.fabric8.openshift.api.model.installer.openstack.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>> extends BaseFluent<A> implements MachinePoolFluent<A>{
  public MachinePoolFluentImpl() {
  }
  public MachinePoolFluentImpl(MachinePool instance) {
    if (instance != null) {
      this.withAdditionalNetworkIDs(instance.getAdditionalNetworkIDs());
      this.withAdditionalSecurityGroupIDs(instance.getAdditionalSecurityGroupIDs());
      this.withRootVolume(instance.getRootVolume());
      this.withServerGroupPolicy(instance.getServerGroupPolicy());
      this.withType(instance.getType());
      this.withZones(instance.getZones());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> additionalNetworkIDs = new ArrayList<String>();
  private List<String> additionalSecurityGroupIDs = new ArrayList<String>();
  private RootVolumeBuilder rootVolume;
  private String serverGroupPolicy;
  private String type;
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToAdditionalNetworkIDs(int index,String item) {
    if (this.additionalNetworkIDs == null) {this.additionalNetworkIDs = new ArrayList<String>();}
    this.additionalNetworkIDs.add(index, item);
    return (A)this;
  }
  public A setToAdditionalNetworkIDs(int index,String item) {
    if (this.additionalNetworkIDs == null) {this.additionalNetworkIDs = new ArrayList<String>();}
    this.additionalNetworkIDs.set(index, item); return (A)this;
  }
  public A addToAdditionalNetworkIDs(java.lang.String... items) {
    if (this.additionalNetworkIDs == null) {this.additionalNetworkIDs = new ArrayList<String>();}
    for (String item : items) {this.additionalNetworkIDs.add(item);} return (A)this;
  }
  public A addAllToAdditionalNetworkIDs(Collection<String> items) {
    if (this.additionalNetworkIDs == null) {this.additionalNetworkIDs = new ArrayList<String>();}
    for (String item : items) {this.additionalNetworkIDs.add(item);} return (A)this;
  }
  public A removeFromAdditionalNetworkIDs(java.lang.String... items) {
    for (String item : items) {if (this.additionalNetworkIDs!= null){ this.additionalNetworkIDs.remove(item);}} return (A)this;
  }
  public A removeAllFromAdditionalNetworkIDs(Collection<String> items) {
    for (String item : items) {if (this.additionalNetworkIDs!= null){ this.additionalNetworkIDs.remove(item);}} return (A)this;
  }
  public List<String> getAdditionalNetworkIDs() {
    return this.additionalNetworkIDs;
  }
  public String getAdditionalNetworkID(int index) {
    return this.additionalNetworkIDs.get(index);
  }
  public String getFirstAdditionalNetworkID() {
    return this.additionalNetworkIDs.get(0);
  }
  public String getLastAdditionalNetworkID() {
    return this.additionalNetworkIDs.get(additionalNetworkIDs.size() - 1);
  }
  public String getMatchingAdditionalNetworkID(Predicate<String> predicate) {
    for (String item: additionalNetworkIDs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAdditionalNetworkID(Predicate<String> predicate) {
    for (String item: additionalNetworkIDs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalNetworkIDs(List<String> additionalNetworkIDs) {
    if (additionalNetworkIDs != null) {this.additionalNetworkIDs = new ArrayList(); for (String item : additionalNetworkIDs){this.addToAdditionalNetworkIDs(item);}} else { this.additionalNetworkIDs = null;} return (A) this;
  }
  public A withAdditionalNetworkIDs(java.lang.String... additionalNetworkIDs) {
    if (this.additionalNetworkIDs != null) {this.additionalNetworkIDs.clear(); _visitables.remove("additionalNetworkIDs"); }
    if (additionalNetworkIDs != null) {for (String item :additionalNetworkIDs){ this.addToAdditionalNetworkIDs(item);}} return (A) this;
  }
  public Boolean hasAdditionalNetworkIDs() {
    return additionalNetworkIDs != null && !additionalNetworkIDs.isEmpty();
  }
  public A addToAdditionalSecurityGroupIDs(int index,String item) {
    if (this.additionalSecurityGroupIDs == null) {this.additionalSecurityGroupIDs = new ArrayList<String>();}
    this.additionalSecurityGroupIDs.add(index, item);
    return (A)this;
  }
  public A setToAdditionalSecurityGroupIDs(int index,String item) {
    if (this.additionalSecurityGroupIDs == null) {this.additionalSecurityGroupIDs = new ArrayList<String>();}
    this.additionalSecurityGroupIDs.set(index, item); return (A)this;
  }
  public A addToAdditionalSecurityGroupIDs(java.lang.String... items) {
    if (this.additionalSecurityGroupIDs == null) {this.additionalSecurityGroupIDs = new ArrayList<String>();}
    for (String item : items) {this.additionalSecurityGroupIDs.add(item);} return (A)this;
  }
  public A addAllToAdditionalSecurityGroupIDs(Collection<String> items) {
    if (this.additionalSecurityGroupIDs == null) {this.additionalSecurityGroupIDs = new ArrayList<String>();}
    for (String item : items) {this.additionalSecurityGroupIDs.add(item);} return (A)this;
  }
  public A removeFromAdditionalSecurityGroupIDs(java.lang.String... items) {
    for (String item : items) {if (this.additionalSecurityGroupIDs!= null){ this.additionalSecurityGroupIDs.remove(item);}} return (A)this;
  }
  public A removeAllFromAdditionalSecurityGroupIDs(Collection<String> items) {
    for (String item : items) {if (this.additionalSecurityGroupIDs!= null){ this.additionalSecurityGroupIDs.remove(item);}} return (A)this;
  }
  public List<String> getAdditionalSecurityGroupIDs() {
    return this.additionalSecurityGroupIDs;
  }
  public String getAdditionalSecurityGroupID(int index) {
    return this.additionalSecurityGroupIDs.get(index);
  }
  public String getFirstAdditionalSecurityGroupID() {
    return this.additionalSecurityGroupIDs.get(0);
  }
  public String getLastAdditionalSecurityGroupID() {
    return this.additionalSecurityGroupIDs.get(additionalSecurityGroupIDs.size() - 1);
  }
  public String getMatchingAdditionalSecurityGroupID(Predicate<String> predicate) {
    for (String item: additionalSecurityGroupIDs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAdditionalSecurityGroupID(Predicate<String> predicate) {
    for (String item: additionalSecurityGroupIDs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalSecurityGroupIDs(List<String> additionalSecurityGroupIDs) {
    if (additionalSecurityGroupIDs != null) {this.additionalSecurityGroupIDs = new ArrayList(); for (String item : additionalSecurityGroupIDs){this.addToAdditionalSecurityGroupIDs(item);}} else { this.additionalSecurityGroupIDs = null;} return (A) this;
  }
  public A withAdditionalSecurityGroupIDs(java.lang.String... additionalSecurityGroupIDs) {
    if (this.additionalSecurityGroupIDs != null) {this.additionalSecurityGroupIDs.clear(); _visitables.remove("additionalSecurityGroupIDs"); }
    if (additionalSecurityGroupIDs != null) {for (String item :additionalSecurityGroupIDs){ this.addToAdditionalSecurityGroupIDs(item);}} return (A) this;
  }
  public Boolean hasAdditionalSecurityGroupIDs() {
    return additionalSecurityGroupIDs != null && !additionalSecurityGroupIDs.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildRootVolume instead.
   * @return The buildable object.
   */
  @Deprecated
  public RootVolume getRootVolume() {
    return this.rootVolume!=null ?this.rootVolume.build():null;
  }
  public RootVolume buildRootVolume() {
    return this.rootVolume!=null ?this.rootVolume.build():null;
  }
  public A withRootVolume(RootVolume rootVolume) {
    _visitables.get("rootVolume").remove(this.rootVolume);
    if (rootVolume!=null){ this.rootVolume= new RootVolumeBuilder(rootVolume); _visitables.get("rootVolume").add(this.rootVolume);} else { this.rootVolume = null; _visitables.get("rootVolume").remove(this.rootVolume); } return (A) this;
  }
  public Boolean hasRootVolume() {
    return this.rootVolume != null;
  }
  public MachinePoolFluentImpl.RootVolumeNested<A> withNewRootVolume() {
    return new MachinePoolFluentImpl.RootVolumeNestedImpl();
  }
  public MachinePoolFluentImpl.RootVolumeNested<A> withNewRootVolumeLike(RootVolume item) {
    return new MachinePoolFluentImpl.RootVolumeNestedImpl(item);
  }
  public MachinePoolFluentImpl.RootVolumeNested<A> editRootVolume() {
    return withNewRootVolumeLike(getRootVolume());
  }
  public MachinePoolFluentImpl.RootVolumeNested<A> editOrNewRootVolume() {
    return withNewRootVolumeLike(getRootVolume() != null ? getRootVolume(): new RootVolumeBuilder().build());
  }
  public MachinePoolFluentImpl.RootVolumeNested<A> editOrNewRootVolumeLike(RootVolume item) {
    return withNewRootVolumeLike(getRootVolume() != null ? getRootVolume(): item);
  }
  public String getServerGroupPolicy() {
    return this.serverGroupPolicy;
  }
  public A withServerGroupPolicy(String serverGroupPolicy) {
    this.serverGroupPolicy=serverGroupPolicy; return (A) this;
  }
  public Boolean hasServerGroupPolicy() {
    return this.serverGroupPolicy != null;
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  public A setToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A removeFromZones(java.lang.String... items) {
    for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
  }
  public A removeAllFromZones(Collection<String> items) {
    for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
  }
  public List<String> getZones() {
    return this.zones;
  }
  public String getZone(int index) {
    return this.zones.get(index);
  }
  public String getFirstZone() {
    return this.zones.get(0);
  }
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  public String getMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withZones(List<String> zones) {
    if (zones != null) {this.zones = new ArrayList(); for (String item : zones){this.addToZones(item);}} else { this.zones = null;} return (A) this;
  }
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {this.zones.clear(); _visitables.remove("zones"); }
    if (zones != null) {for (String item :zones){ this.addToZones(item);}} return (A) this;
  }
  public Boolean hasZones() {
    return zones != null && !zones.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluentImpl that = (MachinePoolFluentImpl) o;
    if (!java.util.Objects.equals(additionalNetworkIDs, that.additionalNetworkIDs)) return false;

    if (!java.util.Objects.equals(additionalSecurityGroupIDs, that.additionalSecurityGroupIDs)) return false;

    if (!java.util.Objects.equals(rootVolume, that.rootVolume)) return false;

    if (!java.util.Objects.equals(serverGroupPolicy, that.serverGroupPolicy)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(zones, that.zones)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalNetworkIDs,  additionalSecurityGroupIDs,  rootVolume,  serverGroupPolicy,  type,  zones,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalNetworkIDs != null && !additionalNetworkIDs.isEmpty()) { sb.append("additionalNetworkIDs:"); sb.append(additionalNetworkIDs + ","); }
    if (additionalSecurityGroupIDs != null && !additionalSecurityGroupIDs.isEmpty()) { sb.append("additionalSecurityGroupIDs:"); sb.append(additionalSecurityGroupIDs + ","); }
    if (rootVolume != null) { sb.append("rootVolume:"); sb.append(rootVolume + ","); }
    if (serverGroupPolicy != null) { sb.append("serverGroupPolicy:"); sb.append(serverGroupPolicy + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class RootVolumeNestedImpl<N> extends RootVolumeFluentImpl<MachinePoolFluentImpl.RootVolumeNested<N>> implements MachinePoolFluentImpl.RootVolumeNested<N>,Nested<N>{
    RootVolumeNestedImpl(RootVolume item) {
      this.builder = new RootVolumeBuilder(this, item);
    }
    RootVolumeNestedImpl() {
      this.builder = new RootVolumeBuilder(this);
    }
    RootVolumeBuilder builder;
    public N and() {
      return (N) MachinePoolFluentImpl.this.withRootVolume(builder.build());
    }
    public N endRootVolume() {
      return and();
    }
    
  }
  
}