package io.fabric8.openshift.api.model.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformBuilder extends PlatformFluentImpl<PlatformBuilder> implements VisitableBuilder<Platform,PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(PlatformFluent<?> fluent,Platform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAffinityGroups(instance.getAffinityGroups());
      fluent.withApiVip(instance.getApiVip());
      fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      fluent.withIngressVip(instance.getIngressVip());
      fluent.withOvirtClusterId(instance.getOvirtClusterId());
      fluent.withOvirtNetworkName(instance.getOvirtNetworkName());
      fluent.withOvirtStorageDomainId(instance.getOvirtStorageDomainId());
      fluent.withVnicProfileID(instance.getVnicProfileID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(Platform instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAffinityGroups(instance.getAffinityGroups());
      this.withApiVip(instance.getApiVip());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withIngressVip(instance.getIngressVip());
      this.withOvirtClusterId(instance.getOvirtClusterId());
      this.withOvirtNetworkName(instance.getOvirtNetworkName());
      this.withOvirtStorageDomainId(instance.getOvirtStorageDomainId());
      this.withVnicProfileID(instance.getVnicProfileID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PlatformFluent<?> fluent;
  Boolean validationEnabled;
  public Platform build() {
    Platform buildable = new Platform(fluent.getAffinityGroups(),fluent.getApiVip(),fluent.getDefaultMachinePlatform(),fluent.getIngressVip(),fluent.getOvirtClusterId(),fluent.getOvirtNetworkName(),fluent.getOvirtStorageDomainId(),fluent.getVnicProfileID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}