package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class InstallConfigFluentImpl<A extends InstallConfigFluent<A>> extends BaseFluent<A> implements InstallConfigFluent<A>{
  public InstallConfigFluentImpl() {
  }
  public InstallConfigFluentImpl(InstallConfig instance) {
    if (instance != null) {
      this.withAdditionalTrustBundle(instance.getAdditionalTrustBundle());
      this.withApiVersion(instance.getApiVersion());
      this.withBaseDomain(instance.getBaseDomain());
      this.withBootstrapInPlace(instance.getBootstrapInPlace());
      this.withCompute(instance.getCompute());
      this.withControlPlane(instance.getControlPlane());
      this.withCredentialsMode(instance.getCredentialsMode());
      this.withFips(instance.getFips());
      this.withImageContentSources(instance.getImageContentSources());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withNetworking(instance.getNetworking());
      this.withPlatform(instance.getPlatform());
      this.withProxy(instance.getProxy());
      this.withPublish(instance.getPublish());
      this.withPullSecret(instance.getPullSecret());
      this.withSshKey(instance.getSshKey());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String additionalTrustBundle;
  private String apiVersion;
  private String baseDomain;
  private BootstrapInPlaceBuilder bootstrapInPlace;
  private ArrayList<MachinePoolBuilder> compute = new ArrayList<MachinePoolBuilder>();
  private MachinePoolBuilder controlPlane;
  private String credentialsMode;
  private Boolean fips;
  private ArrayList<ImageContentSourceBuilder> imageContentSources = new ArrayList<ImageContentSourceBuilder>();
  private String kind;
  private ObjectMetaBuilder metadata;
  private NetworkingBuilder networking;
  private PlatformBuilder platform;
  private ProxyBuilder proxy;
  private String publish;
  private String pullSecret;
  private String sshKey;
  private Map<String,Object> additionalProperties;
  public String getAdditionalTrustBundle() {
    return this.additionalTrustBundle;
  }
  public A withAdditionalTrustBundle(String additionalTrustBundle) {
    this.additionalTrustBundle=additionalTrustBundle; return (A) this;
  }
  public Boolean hasAdditionalTrustBundle() {
    return this.additionalTrustBundle != null;
  }
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getBaseDomain() {
    return this.baseDomain;
  }
  public A withBaseDomain(String baseDomain) {
    this.baseDomain=baseDomain; return (A) this;
  }
  public Boolean hasBaseDomain() {
    return this.baseDomain != null;
  }
  
  /**
   * This method has been deprecated, please use method buildBootstrapInPlace instead.
   * @return The buildable object.
   */
  @Deprecated
  public BootstrapInPlace getBootstrapInPlace() {
    return this.bootstrapInPlace!=null ?this.bootstrapInPlace.build():null;
  }
  public BootstrapInPlace buildBootstrapInPlace() {
    return this.bootstrapInPlace!=null ?this.bootstrapInPlace.build():null;
  }
  public A withBootstrapInPlace(BootstrapInPlace bootstrapInPlace) {
    _visitables.get("bootstrapInPlace").remove(this.bootstrapInPlace);
    if (bootstrapInPlace!=null){ this.bootstrapInPlace= new BootstrapInPlaceBuilder(bootstrapInPlace); _visitables.get("bootstrapInPlace").add(this.bootstrapInPlace);} else { this.bootstrapInPlace = null; _visitables.get("bootstrapInPlace").remove(this.bootstrapInPlace); } return (A) this;
  }
  public Boolean hasBootstrapInPlace() {
    return this.bootstrapInPlace != null;
  }
  public A withNewBootstrapInPlace(String installationDisk) {
    return (A)withBootstrapInPlace(new BootstrapInPlace(installationDisk));
  }
  public InstallConfigFluentImpl.BootstrapInPlaceNested<A> withNewBootstrapInPlace() {
    return new InstallConfigFluentImpl.BootstrapInPlaceNestedImpl();
  }
  public InstallConfigFluentImpl.BootstrapInPlaceNested<A> withNewBootstrapInPlaceLike(BootstrapInPlace item) {
    return new InstallConfigFluentImpl.BootstrapInPlaceNestedImpl(item);
  }
  public InstallConfigFluentImpl.BootstrapInPlaceNested<A> editBootstrapInPlace() {
    return withNewBootstrapInPlaceLike(getBootstrapInPlace());
  }
  public InstallConfigFluentImpl.BootstrapInPlaceNested<A> editOrNewBootstrapInPlace() {
    return withNewBootstrapInPlaceLike(getBootstrapInPlace() != null ? getBootstrapInPlace(): new BootstrapInPlaceBuilder().build());
  }
  public InstallConfigFluentImpl.BootstrapInPlaceNested<A> editOrNewBootstrapInPlaceLike(BootstrapInPlace item) {
    return withNewBootstrapInPlaceLike(getBootstrapInPlace() != null ? getBootstrapInPlace(): item);
  }
  public A addToCompute(int index,MachinePool item) {
    if (this.compute == null) {this.compute = new ArrayList<MachinePoolBuilder>();}
    MachinePoolBuilder builder = new MachinePoolBuilder(item);
    if (index < 0 || index >= compute.size()) { _visitables.get("compute").add(builder); compute.add(builder); } else { _visitables.get("compute").add(index, builder); compute.add(index, builder);}
    return (A)this;
  }
  public A setToCompute(int index,MachinePool item) {
    if (this.compute == null) {this.compute = new ArrayList<MachinePoolBuilder>();}
    MachinePoolBuilder builder = new MachinePoolBuilder(item);
    if (index < 0 || index >= compute.size()) { _visitables.get("compute").add(builder); compute.add(builder); } else { _visitables.get("compute").set(index, builder); compute.set(index, builder);}
    return (A)this;
  }
  public A addToCompute(io.fabric8.openshift.api.model.installer.v1.MachinePool... items) {
    if (this.compute == null) {this.compute = new ArrayList<MachinePoolBuilder>();}
    for (MachinePool item : items) {MachinePoolBuilder builder = new MachinePoolBuilder(item);_visitables.get("compute").add(builder);this.compute.add(builder);} return (A)this;
  }
  public A addAllToCompute(Collection<MachinePool> items) {
    if (this.compute == null) {this.compute = new ArrayList<MachinePoolBuilder>();}
    for (MachinePool item : items) {MachinePoolBuilder builder = new MachinePoolBuilder(item);_visitables.get("compute").add(builder);this.compute.add(builder);} return (A)this;
  }
  public A removeFromCompute(io.fabric8.openshift.api.model.installer.v1.MachinePool... items) {
    for (MachinePool item : items) {MachinePoolBuilder builder = new MachinePoolBuilder(item);_visitables.get("compute").remove(builder);if (this.compute != null) {this.compute.remove(builder);}} return (A)this;
  }
  public A removeAllFromCompute(Collection<MachinePool> items) {
    for (MachinePool item : items) {MachinePoolBuilder builder = new MachinePoolBuilder(item);_visitables.get("compute").remove(builder);if (this.compute != null) {this.compute.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCompute(Predicate<MachinePoolBuilder> predicate) {
    if (compute == null) return (A) this;
    final Iterator<MachinePoolBuilder> each = compute.iterator();
    final List visitables = _visitables.get("compute");
    while (each.hasNext()) {
      MachinePoolBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildCompute instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MachinePool> getCompute() {
    return compute != null ? build(compute) : null;
  }
  public List<MachinePool> buildCompute() {
    return compute != null ? build(compute) : null;
  }
  public MachinePool buildCompute(int index) {
    return this.compute.get(index).build();
  }
  public MachinePool buildFirstCompute() {
    return this.compute.get(0).build();
  }
  public MachinePool buildLastCompute() {
    return this.compute.get(compute.size() - 1).build();
  }
  public MachinePool buildMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
    for (MachinePoolBuilder item: compute) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
    for (MachinePoolBuilder item: compute) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCompute(List<MachinePool> compute) {
    if (this.compute != null) { _visitables.get("compute").clear();}
    if (compute != null) {this.compute = new ArrayList(); for (MachinePool item : compute){this.addToCompute(item);}} else { this.compute = null;} return (A) this;
  }
  public A withCompute(io.fabric8.openshift.api.model.installer.v1.MachinePool... compute) {
    if (this.compute != null) {this.compute.clear(); _visitables.remove("compute"); }
    if (compute != null) {for (MachinePool item :compute){ this.addToCompute(item);}} return (A) this;
  }
  public Boolean hasCompute() {
    return compute != null && !compute.isEmpty();
  }
  public InstallConfigFluentImpl.ComputeNested<A> addNewCompute() {
    return new InstallConfigFluentImpl.ComputeNestedImpl();
  }
  public InstallConfigFluentImpl.ComputeNested<A> addNewComputeLike(MachinePool item) {
    return new InstallConfigFluentImpl.ComputeNestedImpl(-1, item);
  }
  public InstallConfigFluentImpl.ComputeNested<A> setNewComputeLike(int index,MachinePool item) {
    return new InstallConfigFluentImpl.ComputeNestedImpl(index, item);
  }
  public InstallConfigFluentImpl.ComputeNested<A> editCompute(int index) {
    if (compute.size() <= index) throw new RuntimeException("Can't edit compute. Index exceeds size.");
    return setNewComputeLike(index, buildCompute(index));
  }
  public InstallConfigFluentImpl.ComputeNested<A> editFirstCompute() {
    if (compute.size() == 0) throw new RuntimeException("Can't edit first compute. The list is empty.");
    return setNewComputeLike(0, buildCompute(0));
  }
  public InstallConfigFluentImpl.ComputeNested<A> editLastCompute() {
    int index = compute.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last compute. The list is empty.");
    return setNewComputeLike(index, buildCompute(index));
  }
  public InstallConfigFluentImpl.ComputeNested<A> editMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
    int index = -1;
    for (int i=0;i<compute.size();i++) { 
    if (predicate.test(compute.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching compute. No match found.");
    return setNewComputeLike(index, buildCompute(index));
  }
  
  /**
   * This method has been deprecated, please use method buildControlPlane instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getControlPlane() {
    return this.controlPlane!=null ?this.controlPlane.build():null;
  }
  public MachinePool buildControlPlane() {
    return this.controlPlane!=null ?this.controlPlane.build():null;
  }
  public A withControlPlane(MachinePool controlPlane) {
    _visitables.get("controlPlane").remove(this.controlPlane);
    if (controlPlane!=null){ this.controlPlane= new MachinePoolBuilder(controlPlane); _visitables.get("controlPlane").add(this.controlPlane);} else { this.controlPlane = null; _visitables.get("controlPlane").remove(this.controlPlane); } return (A) this;
  }
  public Boolean hasControlPlane() {
    return this.controlPlane != null;
  }
  public InstallConfigFluentImpl.ControlPlaneNested<A> withNewControlPlane() {
    return new InstallConfigFluentImpl.ControlPlaneNestedImpl();
  }
  public InstallConfigFluentImpl.ControlPlaneNested<A> withNewControlPlaneLike(MachinePool item) {
    return new InstallConfigFluentImpl.ControlPlaneNestedImpl(item);
  }
  public InstallConfigFluentImpl.ControlPlaneNested<A> editControlPlane() {
    return withNewControlPlaneLike(getControlPlane());
  }
  public InstallConfigFluentImpl.ControlPlaneNested<A> editOrNewControlPlane() {
    return withNewControlPlaneLike(getControlPlane() != null ? getControlPlane(): new MachinePoolBuilder().build());
  }
  public InstallConfigFluentImpl.ControlPlaneNested<A> editOrNewControlPlaneLike(MachinePool item) {
    return withNewControlPlaneLike(getControlPlane() != null ? getControlPlane(): item);
  }
  public String getCredentialsMode() {
    return this.credentialsMode;
  }
  public A withCredentialsMode(String credentialsMode) {
    this.credentialsMode=credentialsMode; return (A) this;
  }
  public Boolean hasCredentialsMode() {
    return this.credentialsMode != null;
  }
  public Boolean getFips() {
    return this.fips;
  }
  public A withFips(Boolean fips) {
    this.fips=fips; return (A) this;
  }
  public Boolean hasFips() {
    return this.fips != null;
  }
  public A addToImageContentSources(int index,ImageContentSource item) {
    if (this.imageContentSources == null) {this.imageContentSources = new ArrayList<ImageContentSourceBuilder>();}
    ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
    if (index < 0 || index >= imageContentSources.size()) { _visitables.get("imageContentSources").add(builder); imageContentSources.add(builder); } else { _visitables.get("imageContentSources").add(index, builder); imageContentSources.add(index, builder);}
    return (A)this;
  }
  public A setToImageContentSources(int index,ImageContentSource item) {
    if (this.imageContentSources == null) {this.imageContentSources = new ArrayList<ImageContentSourceBuilder>();}
    ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
    if (index < 0 || index >= imageContentSources.size()) { _visitables.get("imageContentSources").add(builder); imageContentSources.add(builder); } else { _visitables.get("imageContentSources").set(index, builder); imageContentSources.set(index, builder);}
    return (A)this;
  }
  public A addToImageContentSources(io.fabric8.openshift.api.model.installer.v1.ImageContentSource... items) {
    if (this.imageContentSources == null) {this.imageContentSources = new ArrayList<ImageContentSourceBuilder>();}
    for (ImageContentSource item : items) {ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);_visitables.get("imageContentSources").add(builder);this.imageContentSources.add(builder);} return (A)this;
  }
  public A addAllToImageContentSources(Collection<ImageContentSource> items) {
    if (this.imageContentSources == null) {this.imageContentSources = new ArrayList<ImageContentSourceBuilder>();}
    for (ImageContentSource item : items) {ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);_visitables.get("imageContentSources").add(builder);this.imageContentSources.add(builder);} return (A)this;
  }
  public A removeFromImageContentSources(io.fabric8.openshift.api.model.installer.v1.ImageContentSource... items) {
    for (ImageContentSource item : items) {ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);_visitables.get("imageContentSources").remove(builder);if (this.imageContentSources != null) {this.imageContentSources.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageContentSources(Collection<ImageContentSource> items) {
    for (ImageContentSource item : items) {ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);_visitables.get("imageContentSources").remove(builder);if (this.imageContentSources != null) {this.imageContentSources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageContentSources(Predicate<ImageContentSourceBuilder> predicate) {
    if (imageContentSources == null) return (A) this;
    final Iterator<ImageContentSourceBuilder> each = imageContentSources.iterator();
    final List visitables = _visitables.get("imageContentSources");
    while (each.hasNext()) {
      ImageContentSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImageContentSources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageContentSource> getImageContentSources() {
    return imageContentSources != null ? build(imageContentSources) : null;
  }
  public List<ImageContentSource> buildImageContentSources() {
    return imageContentSources != null ? build(imageContentSources) : null;
  }
  public ImageContentSource buildImageContentSource(int index) {
    return this.imageContentSources.get(index).build();
  }
  public ImageContentSource buildFirstImageContentSource() {
    return this.imageContentSources.get(0).build();
  }
  public ImageContentSource buildLastImageContentSource() {
    return this.imageContentSources.get(imageContentSources.size() - 1).build();
  }
  public ImageContentSource buildMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
    for (ImageContentSourceBuilder item: imageContentSources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
    for (ImageContentSourceBuilder item: imageContentSources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImageContentSources(List<ImageContentSource> imageContentSources) {
    if (this.imageContentSources != null) { _visitables.get("imageContentSources").clear();}
    if (imageContentSources != null) {this.imageContentSources = new ArrayList(); for (ImageContentSource item : imageContentSources){this.addToImageContentSources(item);}} else { this.imageContentSources = null;} return (A) this;
  }
  public A withImageContentSources(io.fabric8.openshift.api.model.installer.v1.ImageContentSource... imageContentSources) {
    if (this.imageContentSources != null) {this.imageContentSources.clear(); _visitables.remove("imageContentSources"); }
    if (imageContentSources != null) {for (ImageContentSource item :imageContentSources){ this.addToImageContentSources(item);}} return (A) this;
  }
  public Boolean hasImageContentSources() {
    return imageContentSources != null && !imageContentSources.isEmpty();
  }
  public InstallConfigFluentImpl.ImageContentSourcesNested<A> addNewImageContentSource() {
    return new InstallConfigFluentImpl.ImageContentSourcesNestedImpl();
  }
  public InstallConfigFluentImpl.ImageContentSourcesNested<A> addNewImageContentSourceLike(ImageContentSource item) {
    return new InstallConfigFluentImpl.ImageContentSourcesNestedImpl(-1, item);
  }
  public InstallConfigFluentImpl.ImageContentSourcesNested<A> setNewImageContentSourceLike(int index,ImageContentSource item) {
    return new InstallConfigFluentImpl.ImageContentSourcesNestedImpl(index, item);
  }
  public InstallConfigFluentImpl.ImageContentSourcesNested<A> editImageContentSource(int index) {
    if (imageContentSources.size() <= index) throw new RuntimeException("Can't edit imageContentSources. Index exceeds size.");
    return setNewImageContentSourceLike(index, buildImageContentSource(index));
  }
  public InstallConfigFluentImpl.ImageContentSourcesNested<A> editFirstImageContentSource() {
    if (imageContentSources.size() == 0) throw new RuntimeException("Can't edit first imageContentSources. The list is empty.");
    return setNewImageContentSourceLike(0, buildImageContentSource(0));
  }
  public InstallConfigFluentImpl.ImageContentSourcesNested<A> editLastImageContentSource() {
    int index = imageContentSources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imageContentSources. The list is empty.");
    return setNewImageContentSourceLike(index, buildImageContentSource(index));
  }
  public InstallConfigFluentImpl.ImageContentSourcesNested<A> editMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imageContentSources.size();i++) { 
    if (predicate.test(imageContentSources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imageContentSources. No match found.");
    return setNewImageContentSourceLike(index, buildImageContentSource(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public InstallConfigFluentImpl.MetadataNested<A> withNewMetadata() {
    return new InstallConfigFluentImpl.MetadataNestedImpl();
  }
  public InstallConfigFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new InstallConfigFluentImpl.MetadataNestedImpl(item);
  }
  public InstallConfigFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public InstallConfigFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public InstallConfigFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNetworking instead.
   * @return The buildable object.
   */
  @Deprecated
  public Networking getNetworking() {
    return this.networking!=null ?this.networking.build():null;
  }
  public Networking buildNetworking() {
    return this.networking!=null ?this.networking.build():null;
  }
  public A withNetworking(Networking networking) {
    _visitables.get("networking").remove(this.networking);
    if (networking!=null){ this.networking= new NetworkingBuilder(networking); _visitables.get("networking").add(this.networking);} else { this.networking = null; _visitables.get("networking").remove(this.networking); } return (A) this;
  }
  public Boolean hasNetworking() {
    return this.networking != null;
  }
  public InstallConfigFluentImpl.NetworkingNested<A> withNewNetworking() {
    return new InstallConfigFluentImpl.NetworkingNestedImpl();
  }
  public InstallConfigFluentImpl.NetworkingNested<A> withNewNetworkingLike(Networking item) {
    return new InstallConfigFluentImpl.NetworkingNestedImpl(item);
  }
  public InstallConfigFluentImpl.NetworkingNested<A> editNetworking() {
    return withNewNetworkingLike(getNetworking());
  }
  public InstallConfigFluentImpl.NetworkingNested<A> editOrNewNetworking() {
    return withNewNetworkingLike(getNetworking() != null ? getNetworking(): new NetworkingBuilder().build());
  }
  public InstallConfigFluentImpl.NetworkingNested<A> editOrNewNetworkingLike(Networking item) {
    return withNewNetworkingLike(getNetworking() != null ? getNetworking(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public Platform getPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  public Platform buildPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  public A withPlatform(Platform platform) {
    _visitables.get("platform").remove(this.platform);
    if (platform!=null){ this.platform= new PlatformBuilder(platform); _visitables.get("platform").add(this.platform);} else { this.platform = null; _visitables.get("platform").remove(this.platform); } return (A) this;
  }
  public Boolean hasPlatform() {
    return this.platform != null;
  }
  public InstallConfigFluentImpl.PlatformNested<A> withNewPlatform() {
    return new InstallConfigFluentImpl.PlatformNestedImpl();
  }
  public InstallConfigFluentImpl.PlatformNested<A> withNewPlatformLike(Platform item) {
    return new InstallConfigFluentImpl.PlatformNestedImpl(item);
  }
  public InstallConfigFluentImpl.PlatformNested<A> editPlatform() {
    return withNewPlatformLike(getPlatform());
  }
  public InstallConfigFluentImpl.PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(getPlatform() != null ? getPlatform(): new PlatformBuilder().build());
  }
  public InstallConfigFluentImpl.PlatformNested<A> editOrNewPlatformLike(Platform item) {
    return withNewPlatformLike(getPlatform() != null ? getPlatform(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildProxy instead.
   * @return The buildable object.
   */
  @Deprecated
  public Proxy getProxy() {
    return this.proxy!=null ?this.proxy.build():null;
  }
  public Proxy buildProxy() {
    return this.proxy!=null ?this.proxy.build():null;
  }
  public A withProxy(Proxy proxy) {
    _visitables.get("proxy").remove(this.proxy);
    if (proxy!=null){ this.proxy= new ProxyBuilder(proxy); _visitables.get("proxy").add(this.proxy);} else { this.proxy = null; _visitables.get("proxy").remove(this.proxy); } return (A) this;
  }
  public Boolean hasProxy() {
    return this.proxy != null;
  }
  public A withNewProxy(String httpProxy,String httpsProxy,String noProxy) {
    return (A)withProxy(new Proxy(httpProxy, httpsProxy, noProxy));
  }
  public InstallConfigFluentImpl.ProxyNested<A> withNewProxy() {
    return new InstallConfigFluentImpl.ProxyNestedImpl();
  }
  public InstallConfigFluentImpl.ProxyNested<A> withNewProxyLike(Proxy item) {
    return new InstallConfigFluentImpl.ProxyNestedImpl(item);
  }
  public InstallConfigFluentImpl.ProxyNested<A> editProxy() {
    return withNewProxyLike(getProxy());
  }
  public InstallConfigFluentImpl.ProxyNested<A> editOrNewProxy() {
    return withNewProxyLike(getProxy() != null ? getProxy(): new ProxyBuilder().build());
  }
  public InstallConfigFluentImpl.ProxyNested<A> editOrNewProxyLike(Proxy item) {
    return withNewProxyLike(getProxy() != null ? getProxy(): item);
  }
  public String getPublish() {
    return this.publish;
  }
  public A withPublish(String publish) {
    this.publish=publish; return (A) this;
  }
  public Boolean hasPublish() {
    return this.publish != null;
  }
  public String getPullSecret() {
    return this.pullSecret;
  }
  public A withPullSecret(String pullSecret) {
    this.pullSecret=pullSecret; return (A) this;
  }
  public Boolean hasPullSecret() {
    return this.pullSecret != null;
  }
  public String getSshKey() {
    return this.sshKey;
  }
  public A withSshKey(String sshKey) {
    this.sshKey=sshKey; return (A) this;
  }
  public Boolean hasSshKey() {
    return this.sshKey != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InstallConfigFluentImpl that = (InstallConfigFluentImpl) o;
    if (!java.util.Objects.equals(additionalTrustBundle, that.additionalTrustBundle)) return false;

    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(baseDomain, that.baseDomain)) return false;

    if (!java.util.Objects.equals(bootstrapInPlace, that.bootstrapInPlace)) return false;

    if (!java.util.Objects.equals(compute, that.compute)) return false;

    if (!java.util.Objects.equals(controlPlane, that.controlPlane)) return false;

    if (!java.util.Objects.equals(credentialsMode, that.credentialsMode)) return false;

    if (!java.util.Objects.equals(fips, that.fips)) return false;

    if (!java.util.Objects.equals(imageContentSources, that.imageContentSources)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(networking, that.networking)) return false;

    if (!java.util.Objects.equals(platform, that.platform)) return false;

    if (!java.util.Objects.equals(proxy, that.proxy)) return false;

    if (!java.util.Objects.equals(publish, that.publish)) return false;

    if (!java.util.Objects.equals(pullSecret, that.pullSecret)) return false;

    if (!java.util.Objects.equals(sshKey, that.sshKey)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalTrustBundle,  apiVersion,  baseDomain,  bootstrapInPlace,  compute,  controlPlane,  credentialsMode,  fips,  imageContentSources,  kind,  metadata,  networking,  platform,  proxy,  publish,  pullSecret,  sshKey,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalTrustBundle != null) { sb.append("additionalTrustBundle:"); sb.append(additionalTrustBundle + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (baseDomain != null) { sb.append("baseDomain:"); sb.append(baseDomain + ","); }
    if (bootstrapInPlace != null) { sb.append("bootstrapInPlace:"); sb.append(bootstrapInPlace + ","); }
    if (compute != null) { sb.append("compute:"); sb.append(compute + ","); }
    if (controlPlane != null) { sb.append("controlPlane:"); sb.append(controlPlane + ","); }
    if (credentialsMode != null) { sb.append("credentialsMode:"); sb.append(credentialsMode + ","); }
    if (fips != null) { sb.append("fips:"); sb.append(fips + ","); }
    if (imageContentSources != null) { sb.append("imageContentSources:"); sb.append(imageContentSources + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (networking != null) { sb.append("networking:"); sb.append(networking + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (proxy != null) { sb.append("proxy:"); sb.append(proxy + ","); }
    if (publish != null) { sb.append("publish:"); sb.append(publish + ","); }
    if (pullSecret != null) { sb.append("pullSecret:"); sb.append(pullSecret + ","); }
    if (sshKey != null) { sb.append("sshKey:"); sb.append(sshKey + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withFips() {
    return withFips(true);
  }
  class BootstrapInPlaceNestedImpl<N> extends BootstrapInPlaceFluentImpl<InstallConfigFluentImpl.BootstrapInPlaceNested<N>> implements InstallConfigFluentImpl.BootstrapInPlaceNested<N>,Nested<N>{
    BootstrapInPlaceNestedImpl(BootstrapInPlace item) {
      this.builder = new BootstrapInPlaceBuilder(this, item);
    }
    BootstrapInPlaceNestedImpl() {
      this.builder = new BootstrapInPlaceBuilder(this);
    }
    BootstrapInPlaceBuilder builder;
    public N and() {
      return (N) InstallConfigFluentImpl.this.withBootstrapInPlace(builder.build());
    }
    public N endBootstrapInPlace() {
      return and();
    }
    
  }
  class ComputeNestedImpl<N> extends MachinePoolFluentImpl<InstallConfigFluentImpl.ComputeNested<N>> implements InstallConfigFluentImpl.ComputeNested<N>,Nested<N>{
    ComputeNestedImpl(int index,MachinePool item) {
      this.index = index;
      this.builder = new MachinePoolBuilder(this, item);
    }
    ComputeNestedImpl() {
      this.index = -1;
      this.builder = new MachinePoolBuilder(this);
    }
    MachinePoolBuilder builder;
    int index;
    public N and() {
      return (N) InstallConfigFluentImpl.this.setToCompute(index,builder.build());
    }
    public N endCompute() {
      return and();
    }
    
  }
  class ControlPlaneNestedImpl<N> extends MachinePoolFluentImpl<InstallConfigFluentImpl.ControlPlaneNested<N>> implements InstallConfigFluentImpl.ControlPlaneNested<N>,Nested<N>{
    ControlPlaneNestedImpl(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    ControlPlaneNestedImpl() {
      this.builder = new MachinePoolBuilder(this);
    }
    MachinePoolBuilder builder;
    public N and() {
      return (N) InstallConfigFluentImpl.this.withControlPlane(builder.build());
    }
    public N endControlPlane() {
      return and();
    }
    
  }
  class ImageContentSourcesNestedImpl<N> extends ImageContentSourceFluentImpl<InstallConfigFluentImpl.ImageContentSourcesNested<N>> implements InstallConfigFluentImpl.ImageContentSourcesNested<N>,Nested<N>{
    ImageContentSourcesNestedImpl(int index,ImageContentSource item) {
      this.index = index;
      this.builder = new ImageContentSourceBuilder(this, item);
    }
    ImageContentSourcesNestedImpl() {
      this.index = -1;
      this.builder = new ImageContentSourceBuilder(this);
    }
    ImageContentSourceBuilder builder;
    int index;
    public N and() {
      return (N) InstallConfigFluentImpl.this.setToImageContentSources(index,builder.build());
    }
    public N endImageContentSource() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<InstallConfigFluentImpl.MetadataNested<N>> implements InstallConfigFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) InstallConfigFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class NetworkingNestedImpl<N> extends NetworkingFluentImpl<InstallConfigFluentImpl.NetworkingNested<N>> implements InstallConfigFluentImpl.NetworkingNested<N>,Nested<N>{
    NetworkingNestedImpl(Networking item) {
      this.builder = new NetworkingBuilder(this, item);
    }
    NetworkingNestedImpl() {
      this.builder = new NetworkingBuilder(this);
    }
    NetworkingBuilder builder;
    public N and() {
      return (N) InstallConfigFluentImpl.this.withNetworking(builder.build());
    }
    public N endNetworking() {
      return and();
    }
    
  }
  class PlatformNestedImpl<N> extends PlatformFluentImpl<InstallConfigFluentImpl.PlatformNested<N>> implements InstallConfigFluentImpl.PlatformNested<N>,Nested<N>{
    PlatformNestedImpl(Platform item) {
      this.builder = new PlatformBuilder(this, item);
    }
    PlatformNestedImpl() {
      this.builder = new PlatformBuilder(this);
    }
    PlatformBuilder builder;
    public N and() {
      return (N) InstallConfigFluentImpl.this.withPlatform(builder.build());
    }
    public N endPlatform() {
      return and();
    }
    
  }
  class ProxyNestedImpl<N> extends ProxyFluentImpl<InstallConfigFluentImpl.ProxyNested<N>> implements InstallConfigFluentImpl.ProxyNested<N>,Nested<N>{
    ProxyNestedImpl(Proxy item) {
      this.builder = new ProxyBuilder(this, item);
    }
    ProxyNestedImpl() {
      this.builder = new ProxyBuilder(this);
    }
    ProxyBuilder builder;
    public N and() {
      return (N) InstallConfigFluentImpl.this.withProxy(builder.build());
    }
    public N endProxy() {
      return and();
    }
    
  }
  
}