package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineNetworkEntryBuilder extends MachineNetworkEntryFluentImpl<MachineNetworkEntryBuilder> implements VisitableBuilder<MachineNetworkEntry,MachineNetworkEntryBuilder>{
  public MachineNetworkEntryBuilder() {
    this(false);
  }
  public MachineNetworkEntryBuilder(Boolean validationEnabled) {
    this(new MachineNetworkEntry(), validationEnabled);
  }
  public MachineNetworkEntryBuilder(MachineNetworkEntryFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineNetworkEntryBuilder(MachineNetworkEntryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineNetworkEntry(), validationEnabled);
  }
  public MachineNetworkEntryBuilder(MachineNetworkEntryFluent<?> fluent,MachineNetworkEntry instance) {
    this(fluent, instance, false);
  }
  public MachineNetworkEntryBuilder(MachineNetworkEntryFluent<?> fluent,MachineNetworkEntry instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCidr(instance.getCidr());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineNetworkEntryBuilder(MachineNetworkEntry instance) {
    this(instance,false);
  }
  public MachineNetworkEntryBuilder(MachineNetworkEntry instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCidr(instance.getCidr());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineNetworkEntryFluent<?> fluent;
  Boolean validationEnabled;
  public MachineNetworkEntry build() {
    MachineNetworkEntry buildable = new MachineNetworkEntry(fluent.getCidr());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}