package io.fabric8.openshift.api.model.installer.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface MachinePoolFluent<A extends MachinePoolFluent<A>> extends Fluent<A>{
  public String getArchitecture();
  public A withArchitecture(String architecture);
  public Boolean hasArchitecture();
  public String getHyperthreading();
  public A withHyperthreading(String hyperthreading);
  public Boolean hasHyperthreading();
  public String getName();
  public A withName(String name);
  public Boolean hasName();
  
  /**
   * This method has been deprecated, please use method buildPlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePoolPlatform getPlatform();
  public MachinePoolPlatform buildPlatform();
  public A withPlatform(MachinePoolPlatform platform);
  public Boolean hasPlatform();
  public MachinePoolFluent.PlatformNested<A> withNewPlatform();
  public MachinePoolFluent.PlatformNested<A> withNewPlatformLike(MachinePoolPlatform item);
  public MachinePoolFluent.PlatformNested<A> editPlatform();
  public MachinePoolFluent.PlatformNested<A> editOrNewPlatform();
  public MachinePoolFluent.PlatformNested<A> editOrNewPlatformLike(MachinePoolPlatform item);
  public Long getReplicas();
  public A withReplicas(Long replicas);
  public Boolean hasReplicas();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface PlatformNested<N> extends Nested<N>,MachinePoolPlatformFluent<MachinePoolFluent.PlatformNested<N>>{
    public N and();
    public N endPlatform();
    
  }
  
}