package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkingBuilder extends NetworkingFluentImpl<NetworkingBuilder> implements VisitableBuilder<Networking,NetworkingBuilder>{
  public NetworkingBuilder() {
    this(false);
  }
  public NetworkingBuilder(Boolean validationEnabled) {
    this(new Networking(), validationEnabled);
  }
  public NetworkingBuilder(NetworkingFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkingBuilder(NetworkingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Networking(), validationEnabled);
  }
  public NetworkingBuilder(NetworkingFluent<?> fluent,Networking instance) {
    this(fluent, instance, false);
  }
  public NetworkingBuilder(NetworkingFluent<?> fluent,Networking instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClusterNetwork(instance.getClusterNetwork());
      fluent.withDeprecatedClusterNetworks(instance.getDeprecatedClusterNetworks());
      fluent.withMachineCIDR(instance.getMachineCIDR());
      fluent.withMachineNetwork(instance.getMachineNetwork());
      fluent.withNetworkType(instance.getNetworkType());
      fluent.withServiceCIDR(instance.getServiceCIDR());
      fluent.withServiceNetwork(instance.getServiceNetwork());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkingBuilder(Networking instance) {
    this(instance,false);
  }
  public NetworkingBuilder(Networking instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClusterNetwork(instance.getClusterNetwork());
      this.withDeprecatedClusterNetworks(instance.getDeprecatedClusterNetworks());
      this.withMachineCIDR(instance.getMachineCIDR());
      this.withMachineNetwork(instance.getMachineNetwork());
      this.withNetworkType(instance.getNetworkType());
      this.withServiceCIDR(instance.getServiceCIDR());
      this.withServiceNetwork(instance.getServiceNetwork());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkingFluent<?> fluent;
  Boolean validationEnabled;
  public Networking build() {
    Networking buildable = new Networking(fluent.getClusterNetwork(),fluent.getDeprecatedClusterNetworks(),fluent.getMachineCIDR(),fluent.getMachineNetwork(),fluent.getNetworkType(),fluent.getServiceCIDR(),fluent.getServiceNetwork(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}