package io.fabric8.openshift.api.model.installer.vsphere.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformFluentImpl<A extends PlatformFluent<A>> extends BaseFluent<A> implements PlatformFluent<A>{
  public PlatformFluentImpl() {
  }
  public PlatformFluentImpl(Platform instance) {
    if (instance != null) {
      this.withApiVIP(instance.getApiVIP());
      this.withCluster(instance.getCluster());
      this.withClusterOSImage(instance.getClusterOSImage());
      this.withDatacenter(instance.getDatacenter());
      this.withDefaultDatastore(instance.getDefaultDatastore());
      this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
      this.withDiskType(instance.getDiskType());
      this.withFolder(instance.getFolder());
      this.withIngressVIP(instance.getIngressVIP());
      this.withNetwork(instance.getNetwork());
      this.withPassword(instance.getPassword());
      this.withResourcePool(instance.getResourcePool());
      this.withUsername(instance.getUsername());
      this.withVCenter(instance.getVCenter());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVIP;
  private String cluster;
  private String clusterOSImage;
  private String datacenter;
  private String defaultDatastore;
  private MachinePoolBuilder defaultMachinePlatform;
  private String diskType;
  private String folder;
  private String ingressVIP;
  private String network;
  private String password;
  private String resourcePool;
  private String username;
  private String vCenter;
  private Map<String,Object> additionalProperties;
  public String getApiVIP() {
    return this.apiVIP;
  }
  public A withApiVIP(String apiVIP) {
    this.apiVIP=apiVIP; return (A) this;
  }
  public Boolean hasApiVIP() {
    return this.apiVIP != null;
  }
  public String getCluster() {
    return this.cluster;
  }
  public A withCluster(String cluster) {
    this.cluster=cluster; return (A) this;
  }
  public Boolean hasCluster() {
    return this.cluster != null;
  }
  public String getClusterOSImage() {
    return this.clusterOSImage;
  }
  public A withClusterOSImage(String clusterOSImage) {
    this.clusterOSImage=clusterOSImage; return (A) this;
  }
  public Boolean hasClusterOSImage() {
    return this.clusterOSImage != null;
  }
  public String getDatacenter() {
    return this.datacenter;
  }
  public A withDatacenter(String datacenter) {
    this.datacenter=datacenter; return (A) this;
  }
  public Boolean hasDatacenter() {
    return this.datacenter != null;
  }
  public String getDefaultDatastore() {
    return this.defaultDatastore;
  }
  public A withDefaultDatastore(String defaultDatastore) {
    this.defaultDatastore=defaultDatastore; return (A) this;
  }
  public Boolean hasDefaultDatastore() {
    return this.defaultDatastore != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDefaultMachinePlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePool getDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} else { this.defaultMachinePlatform = null; _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform); } return (A) this;
  }
  public Boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl();
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new PlatformFluentImpl.DefaultMachinePlatformNestedImpl(item);
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform());
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): new MachinePoolBuilder().build());
  }
  public PlatformFluentImpl.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(getDefaultMachinePlatform() != null ? getDefaultMachinePlatform(): item);
  }
  public String getDiskType() {
    return this.diskType;
  }
  public A withDiskType(String diskType) {
    this.diskType=diskType; return (A) this;
  }
  public Boolean hasDiskType() {
    return this.diskType != null;
  }
  public String getFolder() {
    return this.folder;
  }
  public A withFolder(String folder) {
    this.folder=folder; return (A) this;
  }
  public Boolean hasFolder() {
    return this.folder != null;
  }
  public String getIngressVIP() {
    return this.ingressVIP;
  }
  public A withIngressVIP(String ingressVIP) {
    this.ingressVIP=ingressVIP; return (A) this;
  }
  public Boolean hasIngressVIP() {
    return this.ingressVIP != null;
  }
  public String getNetwork() {
    return this.network;
  }
  public A withNetwork(String network) {
    this.network=network; return (A) this;
  }
  public Boolean hasNetwork() {
    return this.network != null;
  }
  public String getPassword() {
    return this.password;
  }
  public A withPassword(String password) {
    this.password=password; return (A) this;
  }
  public Boolean hasPassword() {
    return this.password != null;
  }
  public String getResourcePool() {
    return this.resourcePool;
  }
  public A withResourcePool(String resourcePool) {
    this.resourcePool=resourcePool; return (A) this;
  }
  public Boolean hasResourcePool() {
    return this.resourcePool != null;
  }
  public String getUsername() {
    return this.username;
  }
  public A withUsername(String username) {
    this.username=username; return (A) this;
  }
  public Boolean hasUsername() {
    return this.username != null;
  }
  public String getVCenter() {
    return this.vCenter;
  }
  public A withVCenter(String vCenter) {
    this.vCenter=vCenter; return (A) this;
  }
  public Boolean hasVCenter() {
    return this.vCenter != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluentImpl that = (PlatformFluentImpl) o;
    if (!java.util.Objects.equals(apiVIP, that.apiVIP)) return false;

    if (!java.util.Objects.equals(cluster, that.cluster)) return false;

    if (!java.util.Objects.equals(clusterOSImage, that.clusterOSImage)) return false;

    if (!java.util.Objects.equals(datacenter, that.datacenter)) return false;

    if (!java.util.Objects.equals(defaultDatastore, that.defaultDatastore)) return false;

    if (!java.util.Objects.equals(defaultMachinePlatform, that.defaultMachinePlatform)) return false;

    if (!java.util.Objects.equals(diskType, that.diskType)) return false;

    if (!java.util.Objects.equals(folder, that.folder)) return false;

    if (!java.util.Objects.equals(ingressVIP, that.ingressVIP)) return false;

    if (!java.util.Objects.equals(network, that.network)) return false;

    if (!java.util.Objects.equals(password, that.password)) return false;

    if (!java.util.Objects.equals(resourcePool, that.resourcePool)) return false;

    if (!java.util.Objects.equals(username, that.username)) return false;

    if (!java.util.Objects.equals(vCenter, that.vCenter)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVIP,  cluster,  clusterOSImage,  datacenter,  defaultDatastore,  defaultMachinePlatform,  diskType,  folder,  ingressVIP,  network,  password,  resourcePool,  username,  vCenter,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVIP != null) { sb.append("apiVIP:"); sb.append(apiVIP + ","); }
    if (cluster != null) { sb.append("cluster:"); sb.append(cluster + ","); }
    if (clusterOSImage != null) { sb.append("clusterOSImage:"); sb.append(clusterOSImage + ","); }
    if (datacenter != null) { sb.append("datacenter:"); sb.append(datacenter + ","); }
    if (defaultDatastore != null) { sb.append("defaultDatastore:"); sb.append(defaultDatastore + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (diskType != null) { sb.append("diskType:"); sb.append(diskType + ","); }
    if (folder != null) { sb.append("folder:"); sb.append(folder + ","); }
    if (ingressVIP != null) { sb.append("ingressVIP:"); sb.append(ingressVIP + ","); }
    if (network != null) { sb.append("network:"); sb.append(network + ","); }
    if (password != null) { sb.append("password:"); sb.append(password + ","); }
    if (resourcePool != null) { sb.append("resourcePool:"); sb.append(resourcePool + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (vCenter != null) { sb.append("vCenter:"); sb.append(vCenter + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DefaultMachinePlatformNestedImpl<N> extends MachinePoolFluentImpl<PlatformFluentImpl.DefaultMachinePlatformNested<N>> implements PlatformFluentImpl.DefaultMachinePlatformNested<N>,Nested<N>{
    DefaultMachinePlatformNestedImpl(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    DefaultMachinePlatformNestedImpl() {
      this.builder = new MachinePoolBuilder(this);
    }
    MachinePoolBuilder builder;
    public N and() {
      return (N) PlatformFluentImpl.this.withDefaultMachinePlatform(builder.build());
    }
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  }
  
}