package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CustomerManagedKeyBuilder extends CustomerManagedKeyFluent<CustomerManagedKeyBuilder> implements VisitableBuilder<CustomerManagedKey,CustomerManagedKeyBuilder>{
  public CustomerManagedKeyBuilder() {
    this(new CustomerManagedKey());
  }
  
  public CustomerManagedKeyBuilder(CustomerManagedKeyFluent<?> fluent) {
    this(fluent, new CustomerManagedKey());
  }
  
  public CustomerManagedKeyBuilder(CustomerManagedKeyFluent<?> fluent,CustomerManagedKey instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CustomerManagedKeyBuilder(CustomerManagedKey instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CustomerManagedKeyFluent<?> fluent;
  
  public CustomerManagedKey build() {
    CustomerManagedKey buildable = new CustomerManagedKey(fluent.buildKeyVault(),fluent.getUserAssignedIdentityKey());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}