package io.fabric8.openshift.api.model.installer.azure.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CustomerManagedKeyFluent<A extends CustomerManagedKeyFluent<A>> extends BaseFluent<A>{
  public CustomerManagedKeyFluent() {
  }
  
  public CustomerManagedKeyFluent(CustomerManagedKey instance) {
    this.copyInstance(instance);
  }
  private KeyVaultBuilder keyVault;
  private String userAssignedIdentityKey;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CustomerManagedKey instance) {
    instance = (instance != null ? instance : new CustomerManagedKey());
    if (instance != null) {
          this.withKeyVault(instance.getKeyVault());
          this.withUserAssignedIdentityKey(instance.getUserAssignedIdentityKey());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public KeyVault buildKeyVault() {
    return this.keyVault != null ? this.keyVault.build() : null;
  }
  
  public A withKeyVault(KeyVault keyVault) {
    this._visitables.remove("keyVault");
    if (keyVault != null) {
        this.keyVault = new KeyVaultBuilder(keyVault);
        this._visitables.get("keyVault").add(this.keyVault);
    } else {
        this.keyVault = null;
        this._visitables.get("keyVault").remove(this.keyVault);
    }
    return (A) this;
  }
  
  public boolean hasKeyVault() {
    return this.keyVault != null;
  }
  
  public A withNewKeyVault(String keyName,String name,String resourceGroup) {
    return (A)withKeyVault(new KeyVault(keyName, name, resourceGroup));
  }
  
  public KeyVaultNested<A> withNewKeyVault() {
    return new KeyVaultNested(null);
  }
  
  public KeyVaultNested<A> withNewKeyVaultLike(KeyVault item) {
    return new KeyVaultNested(item);
  }
  
  public KeyVaultNested<A> editKeyVault() {
    return withNewKeyVaultLike(java.util.Optional.ofNullable(buildKeyVault()).orElse(null));
  }
  
  public KeyVaultNested<A> editOrNewKeyVault() {
    return withNewKeyVaultLike(java.util.Optional.ofNullable(buildKeyVault()).orElse(new KeyVaultBuilder().build()));
  }
  
  public KeyVaultNested<A> editOrNewKeyVaultLike(KeyVault item) {
    return withNewKeyVaultLike(java.util.Optional.ofNullable(buildKeyVault()).orElse(item));
  }
  
  public String getUserAssignedIdentityKey() {
    return this.userAssignedIdentityKey;
  }
  
  public A withUserAssignedIdentityKey(String userAssignedIdentityKey) {
    this.userAssignedIdentityKey = userAssignedIdentityKey;
    return (A) this;
  }
  
  public boolean hasUserAssignedIdentityKey() {
    return this.userAssignedIdentityKey != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CustomerManagedKeyFluent that = (CustomerManagedKeyFluent) o;
    if (!java.util.Objects.equals(keyVault, that.keyVault)) return false;
    if (!java.util.Objects.equals(userAssignedIdentityKey, that.userAssignedIdentityKey)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(keyVault,  userAssignedIdentityKey,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (keyVault != null) { sb.append("keyVault:"); sb.append(keyVault + ","); }
    if (userAssignedIdentityKey != null) { sb.append("userAssignedIdentityKey:"); sb.append(userAssignedIdentityKey + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class KeyVaultNested<N> extends KeyVaultFluent<KeyVaultNested<N>> implements Nested<N>{
    KeyVaultNested(KeyVault item) {
      this.builder = new KeyVaultBuilder(this, item);
    }
    KeyVaultBuilder builder;
    
    public N and() {
      return (N) CustomerManagedKeyFluent.this.withKeyVault(builder.build());
    }
    
    public N endKeyVault() {
      return and();
    }
    
  
  }

}