package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SecuritySettingsBuilder extends SecuritySettingsFluent<SecuritySettingsBuilder> implements VisitableBuilder<SecuritySettings,SecuritySettingsBuilder>{
  public SecuritySettingsBuilder() {
    this(new SecuritySettings());
  }
  
  public SecuritySettingsBuilder(SecuritySettingsFluent<?> fluent) {
    this(fluent, new SecuritySettings());
  }
  
  public SecuritySettingsBuilder(SecuritySettingsFluent<?> fluent,SecuritySettings instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SecuritySettingsBuilder(SecuritySettings instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SecuritySettingsFluent<?> fluent;
  
  public SecuritySettings build() {
    SecuritySettings buildable = new SecuritySettings(fluent.buildConfidentialVM(),fluent.getSecurityType(),fluent.buildTrustedLaunch());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}