package io.fabric8.openshift.api.model.installer.azure.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VMDiskSecurityProfileFluent<A extends VMDiskSecurityProfileFluent<A>> extends BaseFluent<A>{
  public VMDiskSecurityProfileFluent() {
  }
  
  public VMDiskSecurityProfileFluent(VMDiskSecurityProfile instance) {
    this.copyInstance(instance);
  }
  private DiskEncryptionSetBuilder diskEncryptionSet;
  private String securityEncryptionType;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VMDiskSecurityProfile instance) {
    instance = (instance != null ? instance : new VMDiskSecurityProfile());
    if (instance != null) {
          this.withDiskEncryptionSet(instance.getDiskEncryptionSet());
          this.withSecurityEncryptionType(instance.getSecurityEncryptionType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public DiskEncryptionSet buildDiskEncryptionSet() {
    return this.diskEncryptionSet != null ? this.diskEncryptionSet.build() : null;
  }
  
  public A withDiskEncryptionSet(DiskEncryptionSet diskEncryptionSet) {
    this._visitables.remove("diskEncryptionSet");
    if (diskEncryptionSet != null) {
        this.diskEncryptionSet = new DiskEncryptionSetBuilder(diskEncryptionSet);
        this._visitables.get("diskEncryptionSet").add(this.diskEncryptionSet);
    } else {
        this.diskEncryptionSet = null;
        this._visitables.get("diskEncryptionSet").remove(this.diskEncryptionSet);
    }
    return (A) this;
  }
  
  public boolean hasDiskEncryptionSet() {
    return this.diskEncryptionSet != null;
  }
  
  public A withNewDiskEncryptionSet(String name,String resourceGroup,String subscriptionId) {
    return (A)withDiskEncryptionSet(new DiskEncryptionSet(name, resourceGroup, subscriptionId));
  }
  
  public DiskEncryptionSetNested<A> withNewDiskEncryptionSet() {
    return new DiskEncryptionSetNested(null);
  }
  
  public DiskEncryptionSetNested<A> withNewDiskEncryptionSetLike(DiskEncryptionSet item) {
    return new DiskEncryptionSetNested(item);
  }
  
  public DiskEncryptionSetNested<A> editDiskEncryptionSet() {
    return withNewDiskEncryptionSetLike(java.util.Optional.ofNullable(buildDiskEncryptionSet()).orElse(null));
  }
  
  public DiskEncryptionSetNested<A> editOrNewDiskEncryptionSet() {
    return withNewDiskEncryptionSetLike(java.util.Optional.ofNullable(buildDiskEncryptionSet()).orElse(new DiskEncryptionSetBuilder().build()));
  }
  
  public DiskEncryptionSetNested<A> editOrNewDiskEncryptionSetLike(DiskEncryptionSet item) {
    return withNewDiskEncryptionSetLike(java.util.Optional.ofNullable(buildDiskEncryptionSet()).orElse(item));
  }
  
  public String getSecurityEncryptionType() {
    return this.securityEncryptionType;
  }
  
  public A withSecurityEncryptionType(String securityEncryptionType) {
    this.securityEncryptionType = securityEncryptionType;
    return (A) this;
  }
  
  public boolean hasSecurityEncryptionType() {
    return this.securityEncryptionType != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VMDiskSecurityProfileFluent that = (VMDiskSecurityProfileFluent) o;
    if (!java.util.Objects.equals(diskEncryptionSet, that.diskEncryptionSet)) return false;
    if (!java.util.Objects.equals(securityEncryptionType, that.securityEncryptionType)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(diskEncryptionSet,  securityEncryptionType,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (diskEncryptionSet != null) { sb.append("diskEncryptionSet:"); sb.append(diskEncryptionSet + ","); }
    if (securityEncryptionType != null) { sb.append("securityEncryptionType:"); sb.append(securityEncryptionType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DiskEncryptionSetNested<N> extends DiskEncryptionSetFluent<DiskEncryptionSetNested<N>> implements Nested<N>{
    DiskEncryptionSetNested(DiskEncryptionSet item) {
      this.builder = new DiskEncryptionSetBuilder(this, item);
    }
    DiskEncryptionSetBuilder builder;
    
    public N and() {
      return (N) VMDiskSecurityProfileFluent.this.withDiskEncryptionSet(builder.build());
    }
    
    public N endDiskEncryptionSet() {
      return and();
    }
    
  
  }

}