
package io.fabric8.openshift.api.model.installer.nutanix.v1;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.openshift.api.model.machine.v1.NutanixVMDiskDeviceProperties;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * DataDisk defines a data disk for a Machine VM.
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataSourceImage",
    "deviceProperties",
    "diskSize",
    "storageConfig"
})
@ToString
@EqualsAndHashCode
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
@Generated("io.fabric8.kubernetes.schema.generator.model.ModelGenerator")
public class DataDisk implements Editable<DataDiskBuilder>, KubernetesResource
{

    @JsonProperty("dataSourceImage")
    private StorageResourceReference dataSourceImage;
    @JsonProperty("deviceProperties")
    private NutanixVMDiskDeviceProperties deviceProperties;
    @JsonProperty("diskSize")
    private Quantity diskSize;
    @JsonProperty("storageConfig")
    private StorageConfig storageConfig;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     */
    public DataDisk() {
    }

    public DataDisk(StorageResourceReference dataSourceImage, NutanixVMDiskDeviceProperties deviceProperties, Quantity diskSize, StorageConfig storageConfig) {
        super();
        this.dataSourceImage = dataSourceImage;
        this.deviceProperties = deviceProperties;
        this.diskSize = diskSize;
        this.storageConfig = storageConfig;
    }

    /**
     * DataDisk defines a data disk for a Machine VM.
     */
    @JsonProperty("dataSourceImage")
    public StorageResourceReference getDataSourceImage() {
        return dataSourceImage;
    }

    /**
     * DataDisk defines a data disk for a Machine VM.
     */
    @JsonProperty("dataSourceImage")
    public void setDataSourceImage(StorageResourceReference dataSourceImage) {
        this.dataSourceImage = dataSourceImage;
    }

    /**
     * DataDisk defines a data disk for a Machine VM.
     */
    @JsonProperty("deviceProperties")
    public NutanixVMDiskDeviceProperties getDeviceProperties() {
        return deviceProperties;
    }

    /**
     * DataDisk defines a data disk for a Machine VM.
     */
    @JsonProperty("deviceProperties")
    public void setDeviceProperties(NutanixVMDiskDeviceProperties deviceProperties) {
        this.deviceProperties = deviceProperties;
    }

    /**
     * DataDisk defines a data disk for a Machine VM.
     */
    @JsonProperty("diskSize")
    public Quantity getDiskSize() {
        return diskSize;
    }

    /**
     * DataDisk defines a data disk for a Machine VM.
     */
    @JsonProperty("diskSize")
    public void setDiskSize(Quantity diskSize) {
        this.diskSize = diskSize;
    }

    /**
     * DataDisk defines a data disk for a Machine VM.
     */
    @JsonProperty("storageConfig")
    public StorageConfig getStorageConfig() {
        return storageConfig;
    }

    /**
     * DataDisk defines a data disk for a Machine VM.
     */
    @JsonProperty("storageConfig")
    public void setStorageConfig(StorageConfig storageConfig) {
        this.storageConfig = storageConfig;
    }

    @JsonIgnore
    public DataDiskBuilder edit() {
        return new DataDiskBuilder(this);
    }

    @JsonIgnore
    public DataDiskBuilder toBuilder() {
        return edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

}
