package io.fabric8.openshift.api.model.installer.openstack.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class FixedIPFluent<A extends FixedIPFluent<A>> extends BaseFluent<A>{
  public FixedIPFluent() {
  }
  
  public FixedIPFluent(FixedIP instance) {
    this.copyInstance(instance);
  }
  private SubnetFilterBuilder subnet;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(FixedIP instance) {
    instance = (instance != null ? instance : new FixedIP());
    if (instance != null) {
          this.withSubnet(instance.getSubnet());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SubnetFilter buildSubnet() {
    return this.subnet != null ? this.subnet.build() : null;
  }
  
  public A withSubnet(SubnetFilter subnet) {
    this._visitables.remove("subnet");
    if (subnet != null) {
        this.subnet = new SubnetFilterBuilder(subnet);
        this._visitables.get("subnet").add(this.subnet);
    } else {
        this.subnet = null;
        this._visitables.get("subnet").remove(this.subnet);
    }
    return (A) this;
  }
  
  public boolean hasSubnet() {
    return this.subnet != null;
  }
  
  public A withNewSubnet(String id,String name) {
    return (A)withSubnet(new SubnetFilter(id, name));
  }
  
  public SubnetNested<A> withNewSubnet() {
    return new SubnetNested(null);
  }
  
  public SubnetNested<A> withNewSubnetLike(SubnetFilter item) {
    return new SubnetNested(item);
  }
  
  public SubnetNested<A> editSubnet() {
    return withNewSubnetLike(java.util.Optional.ofNullable(buildSubnet()).orElse(null));
  }
  
  public SubnetNested<A> editOrNewSubnet() {
    return withNewSubnetLike(java.util.Optional.ofNullable(buildSubnet()).orElse(new SubnetFilterBuilder().build()));
  }
  
  public SubnetNested<A> editOrNewSubnetLike(SubnetFilter item) {
    return withNewSubnetLike(java.util.Optional.ofNullable(buildSubnet()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    FixedIPFluent that = (FixedIPFluent) o;
    if (!java.util.Objects.equals(subnet, that.subnet)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(subnet,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (subnet != null) { sb.append("subnet:"); sb.append(subnet + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SubnetNested<N> extends SubnetFilterFluent<SubnetNested<N>> implements Nested<N>{
    SubnetNested(SubnetFilter item) {
      this.builder = new SubnetFilterBuilder(this, item);
    }
    SubnetFilterBuilder builder;
    
    public N and() {
      return (N) FixedIPFluent.this.withSubnet(builder.build());
    }
    
    public N endSubnet() {
      return and();
    }
    
  
  }

}