package io.fabric8.openshift.api.model.installer.powervs.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;
import io.fabric8.openshift.api.model.config.v1.PowerVSServiceEndpoint;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MetadataFluent<A extends MetadataFluent<A>> extends BaseFluent<A>{
  public MetadataFluent() {
  }
  
  public MetadataFluent(Metadata instance) {
    this.copyInstance(instance);
  }
  private String baseDomain;
  private String cisInstanceCRN;
  private String dnsInstanceCRN;
  private String powerVSResourceGroup;
  private String region;
  private List<PowerVSServiceEndpoint> serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();
  private String serviceInstanceGUID;
  private String transitGatewayName;
  private String vpcRegion;
  private String zone;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Metadata instance) {
    instance = (instance != null ? instance : new Metadata());
    if (instance != null) {
          this.withBaseDomain(instance.getBaseDomain());
          this.withCisInstanceCRN(instance.getCisInstanceCRN());
          this.withDnsInstanceCRN(instance.getDnsInstanceCRN());
          this.withPowerVSResourceGroup(instance.getPowerVSResourceGroup());
          this.withRegion(instance.getRegion());
          this.withServiceEndpoints(instance.getServiceEndpoints());
          this.withServiceInstanceGUID(instance.getServiceInstanceGUID());
          this.withTransitGatewayName(instance.getTransitGatewayName());
          this.withVpcRegion(instance.getVpcRegion());
          this.withZone(instance.getZone());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBaseDomain() {
    return this.baseDomain;
  }
  
  public A withBaseDomain(String baseDomain) {
    this.baseDomain = baseDomain;
    return (A) this;
  }
  
  public boolean hasBaseDomain() {
    return this.baseDomain != null;
  }
  
  public String getCisInstanceCRN() {
    return this.cisInstanceCRN;
  }
  
  public A withCisInstanceCRN(String cisInstanceCRN) {
    this.cisInstanceCRN = cisInstanceCRN;
    return (A) this;
  }
  
  public boolean hasCisInstanceCRN() {
    return this.cisInstanceCRN != null;
  }
  
  public String getDnsInstanceCRN() {
    return this.dnsInstanceCRN;
  }
  
  public A withDnsInstanceCRN(String dnsInstanceCRN) {
    this.dnsInstanceCRN = dnsInstanceCRN;
    return (A) this;
  }
  
  public boolean hasDnsInstanceCRN() {
    return this.dnsInstanceCRN != null;
  }
  
  public String getPowerVSResourceGroup() {
    return this.powerVSResourceGroup;
  }
  
  public A withPowerVSResourceGroup(String powerVSResourceGroup) {
    this.powerVSResourceGroup = powerVSResourceGroup;
    return (A) this;
  }
  
  public boolean hasPowerVSResourceGroup() {
    return this.powerVSResourceGroup != null;
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public A addToServiceEndpoints(int index,PowerVSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();}
    this.serviceEndpoints.add(index, item);
    return (A)this;
  }
  
  public A setToServiceEndpoints(int index,PowerVSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();}
    this.serviceEndpoints.set(index, item); return (A)this;
  }
  
  public A addToServiceEndpoints(io.fabric8.openshift.api.model.config.v1.PowerVSServiceEndpoint... items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();}
    for (PowerVSServiceEndpoint item : items) {this.serviceEndpoints.add(item);} return (A)this;
  }
  
  public A addAllToServiceEndpoints(Collection<PowerVSServiceEndpoint> items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<PowerVSServiceEndpoint>();}
    for (PowerVSServiceEndpoint item : items) {this.serviceEndpoints.add(item);} return (A)this;
  }
  
  public A removeFromServiceEndpoints(io.fabric8.openshift.api.model.config.v1.PowerVSServiceEndpoint... items) {
    if (this.serviceEndpoints == null) return (A)this;
    for (PowerVSServiceEndpoint item : items) { this.serviceEndpoints.remove(item);} return (A)this;
  }
  
  public A removeAllFromServiceEndpoints(Collection<PowerVSServiceEndpoint> items) {
    if (this.serviceEndpoints == null) return (A)this;
    for (PowerVSServiceEndpoint item : items) { this.serviceEndpoints.remove(item);} return (A)this;
  }
  
  public List<PowerVSServiceEndpoint> getServiceEndpoints() {
    return this.serviceEndpoints;
  }
  
  public PowerVSServiceEndpoint getServiceEndpoint(int index) {
    return this.serviceEndpoints.get(index);
  }
  
  public PowerVSServiceEndpoint getFirstServiceEndpoint() {
    return this.serviceEndpoints.get(0);
  }
  
  public PowerVSServiceEndpoint getLastServiceEndpoint() {
    return this.serviceEndpoints.get(serviceEndpoints.size() - 1);
  }
  
  public PowerVSServiceEndpoint getMatchingServiceEndpoint(Predicate<PowerVSServiceEndpoint> predicate) {
      for (PowerVSServiceEndpoint item : serviceEndpoints) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingServiceEndpoint(Predicate<PowerVSServiceEndpoint> predicate) {
      for (PowerVSServiceEndpoint item : serviceEndpoints) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withServiceEndpoints(List<PowerVSServiceEndpoint> serviceEndpoints) {
    if (serviceEndpoints != null) {
        this.serviceEndpoints = new ArrayList();
        for (PowerVSServiceEndpoint item : serviceEndpoints) {
          this.addToServiceEndpoints(item);
        }
    } else {
      this.serviceEndpoints = null;
    }
    return (A) this;
  }
  
  public A withServiceEndpoints(io.fabric8.openshift.api.model.config.v1.PowerVSServiceEndpoint... serviceEndpoints) {
    if (this.serviceEndpoints != null) {
        this.serviceEndpoints.clear();
        _visitables.remove("serviceEndpoints");
    }
    if (serviceEndpoints != null) {
      for (PowerVSServiceEndpoint item : serviceEndpoints) {
        this.addToServiceEndpoints(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasServiceEndpoints() {
    return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
  }
  
  public A addNewServiceEndpoint(String name,String url) {
    return (A)addToServiceEndpoints(new PowerVSServiceEndpoint(name, url));
  }
  
  public String getServiceInstanceGUID() {
    return this.serviceInstanceGUID;
  }
  
  public A withServiceInstanceGUID(String serviceInstanceGUID) {
    this.serviceInstanceGUID = serviceInstanceGUID;
    return (A) this;
  }
  
  public boolean hasServiceInstanceGUID() {
    return this.serviceInstanceGUID != null;
  }
  
  public String getTransitGatewayName() {
    return this.transitGatewayName;
  }
  
  public A withTransitGatewayName(String transitGatewayName) {
    this.transitGatewayName = transitGatewayName;
    return (A) this;
  }
  
  public boolean hasTransitGatewayName() {
    return this.transitGatewayName != null;
  }
  
  public String getVpcRegion() {
    return this.vpcRegion;
  }
  
  public A withVpcRegion(String vpcRegion) {
    this.vpcRegion = vpcRegion;
    return (A) this;
  }
  
  public boolean hasVpcRegion() {
    return this.vpcRegion != null;
  }
  
  public String getZone() {
    return this.zone;
  }
  
  public A withZone(String zone) {
    this.zone = zone;
    return (A) this;
  }
  
  public boolean hasZone() {
    return this.zone != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MetadataFluent that = (MetadataFluent) o;
    if (!java.util.Objects.equals(baseDomain, that.baseDomain)) return false;
    if (!java.util.Objects.equals(cisInstanceCRN, that.cisInstanceCRN)) return false;
    if (!java.util.Objects.equals(dnsInstanceCRN, that.dnsInstanceCRN)) return false;
    if (!java.util.Objects.equals(powerVSResourceGroup, that.powerVSResourceGroup)) return false;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(serviceEndpoints, that.serviceEndpoints)) return false;
    if (!java.util.Objects.equals(serviceInstanceGUID, that.serviceInstanceGUID)) return false;
    if (!java.util.Objects.equals(transitGatewayName, that.transitGatewayName)) return false;
    if (!java.util.Objects.equals(vpcRegion, that.vpcRegion)) return false;
    if (!java.util.Objects.equals(zone, that.zone)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(baseDomain,  cisInstanceCRN,  dnsInstanceCRN,  powerVSResourceGroup,  region,  serviceEndpoints,  serviceInstanceGUID,  transitGatewayName,  vpcRegion,  zone,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseDomain != null) { sb.append("baseDomain:"); sb.append(baseDomain + ","); }
    if (cisInstanceCRN != null) { sb.append("cisInstanceCRN:"); sb.append(cisInstanceCRN + ","); }
    if (dnsInstanceCRN != null) { sb.append("dnsInstanceCRN:"); sb.append(dnsInstanceCRN + ","); }
    if (powerVSResourceGroup != null) { sb.append("powerVSResourceGroup:"); sb.append(powerVSResourceGroup + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (serviceEndpoints != null && !serviceEndpoints.isEmpty()) { sb.append("serviceEndpoints:"); sb.append(serviceEndpoints + ","); }
    if (serviceInstanceGUID != null) { sb.append("serviceInstanceGUID:"); sb.append(serviceInstanceGUID + ","); }
    if (transitGatewayName != null) { sb.append("transitGatewayName:"); sb.append(transitGatewayName + ","); }
    if (vpcRegion != null) { sb.append("vpcRegion:"); sb.append(vpcRegion + ","); }
    if (zone != null) { sb.append("zone:"); sb.append(zone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}