package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.openshift.api.model.config.v1.VSpherePlatformNodeNetworking;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.openshift.api.model.config.v1.VSpherePlatformLoadBalancer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlatformFluent<A extends PlatformFluent<A>> extends BaseFluent<A>{
  public PlatformFluent() {
  }
  
  public PlatformFluent(Platform instance) {
    this.copyInstance(instance);
  }
  private String apiVIP;
  private List<String> apiVIPs = new ArrayList<String>();
  private String cluster;
  private String clusterOSImage;
  private String datacenter;
  private String defaultDatastore;
  private MachinePoolBuilder defaultMachinePlatform;
  private String diskType;
  private ArrayList<FailureDomainBuilder> failureDomains = new ArrayList<FailureDomainBuilder>();
  private String folder;
  private ArrayList<HostBuilder> hosts = new ArrayList<HostBuilder>();
  private String ingressVIP;
  private List<String> ingressVIPs = new ArrayList<String>();
  private VSpherePlatformLoadBalancer loadBalancer;
  private String network;
  private VSpherePlatformNodeNetworking nodeNetworking;
  private String password;
  private String resourcePool;
  private String username;
  private String vCenter;
  private ArrayList<VCenterBuilder> vcenters = new ArrayList<VCenterBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Platform instance) {
    instance = (instance != null ? instance : new Platform());
    if (instance != null) {
          this.withApiVIP(instance.getApiVIP());
          this.withApiVIPs(instance.getApiVIPs());
          this.withCluster(instance.getCluster());
          this.withClusterOSImage(instance.getClusterOSImage());
          this.withDatacenter(instance.getDatacenter());
          this.withDefaultDatastore(instance.getDefaultDatastore());
          this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
          this.withDiskType(instance.getDiskType());
          this.withFailureDomains(instance.getFailureDomains());
          this.withFolder(instance.getFolder());
          this.withHosts(instance.getHosts());
          this.withIngressVIP(instance.getIngressVIP());
          this.withIngressVIPs(instance.getIngressVIPs());
          this.withLoadBalancer(instance.getLoadBalancer());
          this.withNetwork(instance.getNetwork());
          this.withNodeNetworking(instance.getNodeNetworking());
          this.withPassword(instance.getPassword());
          this.withResourcePool(instance.getResourcePool());
          this.withUsername(instance.getUsername());
          this.withVCenter(instance.getVCenter());
          this.withVcenters(instance.getVcenters());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVIP() {
    return this.apiVIP;
  }
  
  public A withApiVIP(String apiVIP) {
    this.apiVIP = apiVIP;
    return (A) this;
  }
  
  public boolean hasApiVIP() {
    return this.apiVIP != null;
  }
  
  public A addToApiVIPs(int index,String item) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    this.apiVIPs.add(index, item);
    return (A)this;
  }
  
  public A setToApiVIPs(int index,String item) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    this.apiVIPs.set(index, item); return (A)this;
  }
  
  public A addToApiVIPs(java.lang.String... items) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    for (String item : items) {this.apiVIPs.add(item);} return (A)this;
  }
  
  public A addAllToApiVIPs(Collection<String> items) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    for (String item : items) {this.apiVIPs.add(item);} return (A)this;
  }
  
  public A removeFromApiVIPs(java.lang.String... items) {
    if (this.apiVIPs == null) return (A)this;
    for (String item : items) { this.apiVIPs.remove(item);} return (A)this;
  }
  
  public A removeAllFromApiVIPs(Collection<String> items) {
    if (this.apiVIPs == null) return (A)this;
    for (String item : items) { this.apiVIPs.remove(item);} return (A)this;
  }
  
  public List<String> getApiVIPs() {
    return this.apiVIPs;
  }
  
  public String getApiVIP(int index) {
    return this.apiVIPs.get(index);
  }
  
  public String getFirstApiVIP() {
    return this.apiVIPs.get(0);
  }
  
  public String getLastApiVIP() {
    return this.apiVIPs.get(apiVIPs.size() - 1);
  }
  
  public String getMatchingApiVIP(Predicate<String> predicate) {
      for (String item : apiVIPs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingApiVIP(Predicate<String> predicate) {
      for (String item : apiVIPs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withApiVIPs(List<String> apiVIPs) {
    if (apiVIPs != null) {
        this.apiVIPs = new ArrayList();
        for (String item : apiVIPs) {
          this.addToApiVIPs(item);
        }
    } else {
      this.apiVIPs = null;
    }
    return (A) this;
  }
  
  public A withApiVIPs(java.lang.String... apiVIPs) {
    if (this.apiVIPs != null) {
        this.apiVIPs.clear();
        _visitables.remove("apiVIPs");
    }
    if (apiVIPs != null) {
      for (String item : apiVIPs) {
        this.addToApiVIPs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasApiVIPs() {
    return this.apiVIPs != null && !this.apiVIPs.isEmpty();
  }
  
  public String getCluster() {
    return this.cluster;
  }
  
  public A withCluster(String cluster) {
    this.cluster = cluster;
    return (A) this;
  }
  
  public boolean hasCluster() {
    return this.cluster != null;
  }
  
  public String getClusterOSImage() {
    return this.clusterOSImage;
  }
  
  public A withClusterOSImage(String clusterOSImage) {
    this.clusterOSImage = clusterOSImage;
    return (A) this;
  }
  
  public boolean hasClusterOSImage() {
    return this.clusterOSImage != null;
  }
  
  public String getDatacenter() {
    return this.datacenter;
  }
  
  public A withDatacenter(String datacenter) {
    this.datacenter = datacenter;
    return (A) this;
  }
  
  public boolean hasDatacenter() {
    return this.datacenter != null;
  }
  
  public String getDefaultDatastore() {
    return this.defaultDatastore;
  }
  
  public A withDefaultDatastore(String defaultDatastore) {
    this.defaultDatastore = defaultDatastore;
    return (A) this;
  }
  
  public boolean hasDefaultDatastore() {
    return this.defaultDatastore != null;
  }
  
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
  }
  
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    this._visitables.remove("defaultMachinePlatform");
    if (defaultMachinePlatform != null) {
        this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
        this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
    } else {
        this.defaultMachinePlatform = null;
        this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    }
    return (A) this;
  }
  
  public boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new DefaultMachinePlatformNested(null);
  }
  
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new DefaultMachinePlatformNested(item);
  }
  
  public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(null));
  }
  
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
  }
  
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(item));
  }
  
  public String getDiskType() {
    return this.diskType;
  }
  
  public A withDiskType(String diskType) {
    this.diskType = diskType;
    return (A) this;
  }
  
  public boolean hasDiskType() {
    return this.diskType != null;
  }
  
  public A addToFailureDomains(int index,FailureDomain item) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<FailureDomainBuilder>();}
    FailureDomainBuilder builder = new FailureDomainBuilder(item);
    if (index < 0 || index >= failureDomains.size()) { _visitables.get("failureDomains").add(builder); failureDomains.add(builder); } else { _visitables.get("failureDomains").add(index, builder); failureDomains.add(index, builder);}
    return (A)this;
  }
  
  public A setToFailureDomains(int index,FailureDomain item) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<FailureDomainBuilder>();}
    FailureDomainBuilder builder = new FailureDomainBuilder(item);
    if (index < 0 || index >= failureDomains.size()) { _visitables.get("failureDomains").add(builder); failureDomains.add(builder); } else { _visitables.get("failureDomains").set(index, builder); failureDomains.set(index, builder);}
    return (A)this;
  }
  
  public A addToFailureDomains(io.fabric8.openshift.api.model.installer.vsphere.v1.FailureDomain... items) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<FailureDomainBuilder>();}
    for (FailureDomain item : items) {FailureDomainBuilder builder = new FailureDomainBuilder(item);_visitables.get("failureDomains").add(builder);this.failureDomains.add(builder);} return (A)this;
  }
  
  public A addAllToFailureDomains(Collection<FailureDomain> items) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<FailureDomainBuilder>();}
    for (FailureDomain item : items) {FailureDomainBuilder builder = new FailureDomainBuilder(item);_visitables.get("failureDomains").add(builder);this.failureDomains.add(builder);} return (A)this;
  }
  
  public A removeFromFailureDomains(io.fabric8.openshift.api.model.installer.vsphere.v1.FailureDomain... items) {
    if (this.failureDomains == null) return (A)this;
    for (FailureDomain item : items) {FailureDomainBuilder builder = new FailureDomainBuilder(item);_visitables.get("failureDomains").remove(builder); this.failureDomains.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFailureDomains(Collection<FailureDomain> items) {
    if (this.failureDomains == null) return (A)this;
    for (FailureDomain item : items) {FailureDomainBuilder builder = new FailureDomainBuilder(item);_visitables.get("failureDomains").remove(builder); this.failureDomains.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFailureDomains(Predicate<FailureDomainBuilder> predicate) {
    if (failureDomains == null) return (A) this;
    final Iterator<FailureDomainBuilder> each = failureDomains.iterator();
    final List visitables = _visitables.get("failureDomains");
    while (each.hasNext()) {
      FailureDomainBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<FailureDomain> buildFailureDomains() {
    return this.failureDomains != null ? build(failureDomains) : null;
  }
  
  public FailureDomain buildFailureDomain(int index) {
    return this.failureDomains.get(index).build();
  }
  
  public FailureDomain buildFirstFailureDomain() {
    return this.failureDomains.get(0).build();
  }
  
  public FailureDomain buildLastFailureDomain() {
    return this.failureDomains.get(failureDomains.size() - 1).build();
  }
  
  public FailureDomain buildMatchingFailureDomain(Predicate<FailureDomainBuilder> predicate) {
      for (FailureDomainBuilder item : failureDomains) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFailureDomain(Predicate<FailureDomainBuilder> predicate) {
      for (FailureDomainBuilder item : failureDomains) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFailureDomains(List<FailureDomain> failureDomains) {
    if (this.failureDomains != null) {
      this._visitables.get("failureDomains").clear();
    }
    if (failureDomains != null) {
        this.failureDomains = new ArrayList();
        for (FailureDomain item : failureDomains) {
          this.addToFailureDomains(item);
        }
    } else {
      this.failureDomains = null;
    }
    return (A) this;
  }
  
  public A withFailureDomains(io.fabric8.openshift.api.model.installer.vsphere.v1.FailureDomain... failureDomains) {
    if (this.failureDomains != null) {
        this.failureDomains.clear();
        _visitables.remove("failureDomains");
    }
    if (failureDomains != null) {
      for (FailureDomain item : failureDomains) {
        this.addToFailureDomains(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFailureDomains() {
    return this.failureDomains != null && !this.failureDomains.isEmpty();
  }
  
  public FailureDomainsNested<A> addNewFailureDomain() {
    return new FailureDomainsNested(-1, null);
  }
  
  public FailureDomainsNested<A> addNewFailureDomainLike(FailureDomain item) {
    return new FailureDomainsNested(-1, item);
  }
  
  public FailureDomainsNested<A> setNewFailureDomainLike(int index,FailureDomain item) {
    return new FailureDomainsNested(index, item);
  }
  
  public FailureDomainsNested<A> editFailureDomain(int index) {
    if (failureDomains.size() <= index) throw new RuntimeException("Can't edit failureDomains. Index exceeds size.");
    return setNewFailureDomainLike(index, buildFailureDomain(index));
  }
  
  public FailureDomainsNested<A> editFirstFailureDomain() {
    if (failureDomains.size() == 0) throw new RuntimeException("Can't edit first failureDomains. The list is empty.");
    return setNewFailureDomainLike(0, buildFailureDomain(0));
  }
  
  public FailureDomainsNested<A> editLastFailureDomain() {
    int index = failureDomains.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last failureDomains. The list is empty.");
    return setNewFailureDomainLike(index, buildFailureDomain(index));
  }
  
  public FailureDomainsNested<A> editMatchingFailureDomain(Predicate<FailureDomainBuilder> predicate) {
    int index = -1;
    for (int i=0;i<failureDomains.size();i++) { 
    if (predicate.test(failureDomains.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching failureDomains. No match found.");
    return setNewFailureDomainLike(index, buildFailureDomain(index));
  }
  
  public String getFolder() {
    return this.folder;
  }
  
  public A withFolder(String folder) {
    this.folder = folder;
    return (A) this;
  }
  
  public boolean hasFolder() {
    return this.folder != null;
  }
  
  public A addToHosts(int index,Host item) {
    if (this.hosts == null) {this.hosts = new ArrayList<HostBuilder>();}
    HostBuilder builder = new HostBuilder(item);
    if (index < 0 || index >= hosts.size()) { _visitables.get("hosts").add(builder); hosts.add(builder); } else { _visitables.get("hosts").add(index, builder); hosts.add(index, builder);}
    return (A)this;
  }
  
  public A setToHosts(int index,Host item) {
    if (this.hosts == null) {this.hosts = new ArrayList<HostBuilder>();}
    HostBuilder builder = new HostBuilder(item);
    if (index < 0 || index >= hosts.size()) { _visitables.get("hosts").add(builder); hosts.add(builder); } else { _visitables.get("hosts").set(index, builder); hosts.set(index, builder);}
    return (A)this;
  }
  
  public A addToHosts(io.fabric8.openshift.api.model.installer.vsphere.v1.Host... items) {
    if (this.hosts == null) {this.hosts = new ArrayList<HostBuilder>();}
    for (Host item : items) {HostBuilder builder = new HostBuilder(item);_visitables.get("hosts").add(builder);this.hosts.add(builder);} return (A)this;
  }
  
  public A addAllToHosts(Collection<Host> items) {
    if (this.hosts == null) {this.hosts = new ArrayList<HostBuilder>();}
    for (Host item : items) {HostBuilder builder = new HostBuilder(item);_visitables.get("hosts").add(builder);this.hosts.add(builder);} return (A)this;
  }
  
  public A removeFromHosts(io.fabric8.openshift.api.model.installer.vsphere.v1.Host... items) {
    if (this.hosts == null) return (A)this;
    for (Host item : items) {HostBuilder builder = new HostBuilder(item);_visitables.get("hosts").remove(builder); this.hosts.remove(builder);} return (A)this;
  }
  
  public A removeAllFromHosts(Collection<Host> items) {
    if (this.hosts == null) return (A)this;
    for (Host item : items) {HostBuilder builder = new HostBuilder(item);_visitables.get("hosts").remove(builder); this.hosts.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromHosts(Predicate<HostBuilder> predicate) {
    if (hosts == null) return (A) this;
    final Iterator<HostBuilder> each = hosts.iterator();
    final List visitables = _visitables.get("hosts");
    while (each.hasNext()) {
      HostBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Host> buildHosts() {
    return this.hosts != null ? build(hosts) : null;
  }
  
  public Host buildHost(int index) {
    return this.hosts.get(index).build();
  }
  
  public Host buildFirstHost() {
    return this.hosts.get(0).build();
  }
  
  public Host buildLastHost() {
    return this.hosts.get(hosts.size() - 1).build();
  }
  
  public Host buildMatchingHost(Predicate<HostBuilder> predicate) {
      for (HostBuilder item : hosts) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingHost(Predicate<HostBuilder> predicate) {
      for (HostBuilder item : hosts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHosts(List<Host> hosts) {
    if (this.hosts != null) {
      this._visitables.get("hosts").clear();
    }
    if (hosts != null) {
        this.hosts = new ArrayList();
        for (Host item : hosts) {
          this.addToHosts(item);
        }
    } else {
      this.hosts = null;
    }
    return (A) this;
  }
  
  public A withHosts(io.fabric8.openshift.api.model.installer.vsphere.v1.Host... hosts) {
    if (this.hosts != null) {
        this.hosts.clear();
        _visitables.remove("hosts");
    }
    if (hosts != null) {
      for (Host item : hosts) {
        this.addToHosts(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasHosts() {
    return this.hosts != null && !this.hosts.isEmpty();
  }
  
  public HostsNested<A> addNewHost() {
    return new HostsNested(-1, null);
  }
  
  public HostsNested<A> addNewHostLike(Host item) {
    return new HostsNested(-1, item);
  }
  
  public HostsNested<A> setNewHostLike(int index,Host item) {
    return new HostsNested(index, item);
  }
  
  public HostsNested<A> editHost(int index) {
    if (hosts.size() <= index) throw new RuntimeException("Can't edit hosts. Index exceeds size.");
    return setNewHostLike(index, buildHost(index));
  }
  
  public HostsNested<A> editFirstHost() {
    if (hosts.size() == 0) throw new RuntimeException("Can't edit first hosts. The list is empty.");
    return setNewHostLike(0, buildHost(0));
  }
  
  public HostsNested<A> editLastHost() {
    int index = hosts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last hosts. The list is empty.");
    return setNewHostLike(index, buildHost(index));
  }
  
  public HostsNested<A> editMatchingHost(Predicate<HostBuilder> predicate) {
    int index = -1;
    for (int i=0;i<hosts.size();i++) { 
    if (predicate.test(hosts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching hosts. No match found.");
    return setNewHostLike(index, buildHost(index));
  }
  
  public String getIngressVIP() {
    return this.ingressVIP;
  }
  
  public A withIngressVIP(String ingressVIP) {
    this.ingressVIP = ingressVIP;
    return (A) this;
  }
  
  public boolean hasIngressVIP() {
    return this.ingressVIP != null;
  }
  
  public A addToIngressVIPs(int index,String item) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    this.ingressVIPs.add(index, item);
    return (A)this;
  }
  
  public A setToIngressVIPs(int index,String item) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    this.ingressVIPs.set(index, item); return (A)this;
  }
  
  public A addToIngressVIPs(java.lang.String... items) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    for (String item : items) {this.ingressVIPs.add(item);} return (A)this;
  }
  
  public A addAllToIngressVIPs(Collection<String> items) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    for (String item : items) {this.ingressVIPs.add(item);} return (A)this;
  }
  
  public A removeFromIngressVIPs(java.lang.String... items) {
    if (this.ingressVIPs == null) return (A)this;
    for (String item : items) { this.ingressVIPs.remove(item);} return (A)this;
  }
  
  public A removeAllFromIngressVIPs(Collection<String> items) {
    if (this.ingressVIPs == null) return (A)this;
    for (String item : items) { this.ingressVIPs.remove(item);} return (A)this;
  }
  
  public List<String> getIngressVIPs() {
    return this.ingressVIPs;
  }
  
  public String getIngressVIP(int index) {
    return this.ingressVIPs.get(index);
  }
  
  public String getFirstIngressVIP() {
    return this.ingressVIPs.get(0);
  }
  
  public String getLastIngressVIP() {
    return this.ingressVIPs.get(ingressVIPs.size() - 1);
  }
  
  public String getMatchingIngressVIP(Predicate<String> predicate) {
      for (String item : ingressVIPs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingIngressVIP(Predicate<String> predicate) {
      for (String item : ingressVIPs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIngressVIPs(List<String> ingressVIPs) {
    if (ingressVIPs != null) {
        this.ingressVIPs = new ArrayList();
        for (String item : ingressVIPs) {
          this.addToIngressVIPs(item);
        }
    } else {
      this.ingressVIPs = null;
    }
    return (A) this;
  }
  
  public A withIngressVIPs(java.lang.String... ingressVIPs) {
    if (this.ingressVIPs != null) {
        this.ingressVIPs.clear();
        _visitables.remove("ingressVIPs");
    }
    if (ingressVIPs != null) {
      for (String item : ingressVIPs) {
        this.addToIngressVIPs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasIngressVIPs() {
    return this.ingressVIPs != null && !this.ingressVIPs.isEmpty();
  }
  
  public VSpherePlatformLoadBalancer getLoadBalancer() {
    return this.loadBalancer;
  }
  
  public A withLoadBalancer(VSpherePlatformLoadBalancer loadBalancer) {
    this.loadBalancer = loadBalancer;
    return (A) this;
  }
  
  public boolean hasLoadBalancer() {
    return this.loadBalancer != null;
  }
  
  public A withNewLoadBalancer(String type) {
    return (A)withLoadBalancer(new VSpherePlatformLoadBalancer(type));
  }
  
  public String getNetwork() {
    return this.network;
  }
  
  public A withNetwork(String network) {
    this.network = network;
    return (A) this;
  }
  
  public boolean hasNetwork() {
    return this.network != null;
  }
  
  public VSpherePlatformNodeNetworking getNodeNetworking() {
    return this.nodeNetworking;
  }
  
  public A withNodeNetworking(VSpherePlatformNodeNetworking nodeNetworking) {
    this.nodeNetworking = nodeNetworking;
    return (A) this;
  }
  
  public boolean hasNodeNetworking() {
    return this.nodeNetworking != null;
  }
  
  public String getPassword() {
    return this.password;
  }
  
  public A withPassword(String password) {
    this.password = password;
    return (A) this;
  }
  
  public boolean hasPassword() {
    return this.password != null;
  }
  
  public String getResourcePool() {
    return this.resourcePool;
  }
  
  public A withResourcePool(String resourcePool) {
    this.resourcePool = resourcePool;
    return (A) this;
  }
  
  public boolean hasResourcePool() {
    return this.resourcePool != null;
  }
  
  public String getUsername() {
    return this.username;
  }
  
  public A withUsername(String username) {
    this.username = username;
    return (A) this;
  }
  
  public boolean hasUsername() {
    return this.username != null;
  }
  
  public String getVCenter() {
    return this.vCenter;
  }
  
  public A withVCenter(String vCenter) {
    this.vCenter = vCenter;
    return (A) this;
  }
  
  public boolean hasVCenter() {
    return this.vCenter != null;
  }
  
  public A addToVcenters(int index,VCenter item) {
    if (this.vcenters == null) {this.vcenters = new ArrayList<VCenterBuilder>();}
    VCenterBuilder builder = new VCenterBuilder(item);
    if (index < 0 || index >= vcenters.size()) { _visitables.get("vcenters").add(builder); vcenters.add(builder); } else { _visitables.get("vcenters").add(index, builder); vcenters.add(index, builder);}
    return (A)this;
  }
  
  public A setToVcenters(int index,VCenter item) {
    if (this.vcenters == null) {this.vcenters = new ArrayList<VCenterBuilder>();}
    VCenterBuilder builder = new VCenterBuilder(item);
    if (index < 0 || index >= vcenters.size()) { _visitables.get("vcenters").add(builder); vcenters.add(builder); } else { _visitables.get("vcenters").set(index, builder); vcenters.set(index, builder);}
    return (A)this;
  }
  
  public A addToVcenters(io.fabric8.openshift.api.model.installer.vsphere.v1.VCenter... items) {
    if (this.vcenters == null) {this.vcenters = new ArrayList<VCenterBuilder>();}
    for (VCenter item : items) {VCenterBuilder builder = new VCenterBuilder(item);_visitables.get("vcenters").add(builder);this.vcenters.add(builder);} return (A)this;
  }
  
  public A addAllToVcenters(Collection<VCenter> items) {
    if (this.vcenters == null) {this.vcenters = new ArrayList<VCenterBuilder>();}
    for (VCenter item : items) {VCenterBuilder builder = new VCenterBuilder(item);_visitables.get("vcenters").add(builder);this.vcenters.add(builder);} return (A)this;
  }
  
  public A removeFromVcenters(io.fabric8.openshift.api.model.installer.vsphere.v1.VCenter... items) {
    if (this.vcenters == null) return (A)this;
    for (VCenter item : items) {VCenterBuilder builder = new VCenterBuilder(item);_visitables.get("vcenters").remove(builder); this.vcenters.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVcenters(Collection<VCenter> items) {
    if (this.vcenters == null) return (A)this;
    for (VCenter item : items) {VCenterBuilder builder = new VCenterBuilder(item);_visitables.get("vcenters").remove(builder); this.vcenters.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVcenters(Predicate<VCenterBuilder> predicate) {
    if (vcenters == null) return (A) this;
    final Iterator<VCenterBuilder> each = vcenters.iterator();
    final List visitables = _visitables.get("vcenters");
    while (each.hasNext()) {
      VCenterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<VCenter> buildVcenters() {
    return this.vcenters != null ? build(vcenters) : null;
  }
  
  public VCenter buildVcenter(int index) {
    return this.vcenters.get(index).build();
  }
  
  public VCenter buildFirstVcenter() {
    return this.vcenters.get(0).build();
  }
  
  public VCenter buildLastVcenter() {
    return this.vcenters.get(vcenters.size() - 1).build();
  }
  
  public VCenter buildMatchingVcenter(Predicate<VCenterBuilder> predicate) {
      for (VCenterBuilder item : vcenters) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVcenter(Predicate<VCenterBuilder> predicate) {
      for (VCenterBuilder item : vcenters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVcenters(List<VCenter> vcenters) {
    if (this.vcenters != null) {
      this._visitables.get("vcenters").clear();
    }
    if (vcenters != null) {
        this.vcenters = new ArrayList();
        for (VCenter item : vcenters) {
          this.addToVcenters(item);
        }
    } else {
      this.vcenters = null;
    }
    return (A) this;
  }
  
  public A withVcenters(io.fabric8.openshift.api.model.installer.vsphere.v1.VCenter... vcenters) {
    if (this.vcenters != null) {
        this.vcenters.clear();
        _visitables.remove("vcenters");
    }
    if (vcenters != null) {
      for (VCenter item : vcenters) {
        this.addToVcenters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVcenters() {
    return this.vcenters != null && !this.vcenters.isEmpty();
  }
  
  public VcentersNested<A> addNewVcenter() {
    return new VcentersNested(-1, null);
  }
  
  public VcentersNested<A> addNewVcenterLike(VCenter item) {
    return new VcentersNested(-1, item);
  }
  
  public VcentersNested<A> setNewVcenterLike(int index,VCenter item) {
    return new VcentersNested(index, item);
  }
  
  public VcentersNested<A> editVcenter(int index) {
    if (vcenters.size() <= index) throw new RuntimeException("Can't edit vcenters. Index exceeds size.");
    return setNewVcenterLike(index, buildVcenter(index));
  }
  
  public VcentersNested<A> editFirstVcenter() {
    if (vcenters.size() == 0) throw new RuntimeException("Can't edit first vcenters. The list is empty.");
    return setNewVcenterLike(0, buildVcenter(0));
  }
  
  public VcentersNested<A> editLastVcenter() {
    int index = vcenters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last vcenters. The list is empty.");
    return setNewVcenterLike(index, buildVcenter(index));
  }
  
  public VcentersNested<A> editMatchingVcenter(Predicate<VCenterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<vcenters.size();i++) { 
    if (predicate.test(vcenters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching vcenters. No match found.");
    return setNewVcenterLike(index, buildVcenter(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluent that = (PlatformFluent) o;
    if (!java.util.Objects.equals(apiVIP, that.apiVIP)) return false;
    if (!java.util.Objects.equals(apiVIPs, that.apiVIPs)) return false;
    if (!java.util.Objects.equals(cluster, that.cluster)) return false;
    if (!java.util.Objects.equals(clusterOSImage, that.clusterOSImage)) return false;
    if (!java.util.Objects.equals(datacenter, that.datacenter)) return false;
    if (!java.util.Objects.equals(defaultDatastore, that.defaultDatastore)) return false;
    if (!java.util.Objects.equals(defaultMachinePlatform, that.defaultMachinePlatform)) return false;
    if (!java.util.Objects.equals(diskType, that.diskType)) return false;
    if (!java.util.Objects.equals(failureDomains, that.failureDomains)) return false;
    if (!java.util.Objects.equals(folder, that.folder)) return false;
    if (!java.util.Objects.equals(hosts, that.hosts)) return false;
    if (!java.util.Objects.equals(ingressVIP, that.ingressVIP)) return false;
    if (!java.util.Objects.equals(ingressVIPs, that.ingressVIPs)) return false;
    if (!java.util.Objects.equals(loadBalancer, that.loadBalancer)) return false;
    if (!java.util.Objects.equals(network, that.network)) return false;
    if (!java.util.Objects.equals(nodeNetworking, that.nodeNetworking)) return false;
    if (!java.util.Objects.equals(password, that.password)) return false;
    if (!java.util.Objects.equals(resourcePool, that.resourcePool)) return false;
    if (!java.util.Objects.equals(username, that.username)) return false;
    if (!java.util.Objects.equals(vCenter, that.vCenter)) return false;
    if (!java.util.Objects.equals(vcenters, that.vcenters)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVIP,  apiVIPs,  cluster,  clusterOSImage,  datacenter,  defaultDatastore,  defaultMachinePlatform,  diskType,  failureDomains,  folder,  hosts,  ingressVIP,  ingressVIPs,  loadBalancer,  network,  nodeNetworking,  password,  resourcePool,  username,  vCenter,  vcenters,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVIP != null) { sb.append("apiVIP:"); sb.append(apiVIP + ","); }
    if (apiVIPs != null && !apiVIPs.isEmpty()) { sb.append("apiVIPs:"); sb.append(apiVIPs + ","); }
    if (cluster != null) { sb.append("cluster:"); sb.append(cluster + ","); }
    if (clusterOSImage != null) { sb.append("clusterOSImage:"); sb.append(clusterOSImage + ","); }
    if (datacenter != null) { sb.append("datacenter:"); sb.append(datacenter + ","); }
    if (defaultDatastore != null) { sb.append("defaultDatastore:"); sb.append(defaultDatastore + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (diskType != null) { sb.append("diskType:"); sb.append(diskType + ","); }
    if (failureDomains != null && !failureDomains.isEmpty()) { sb.append("failureDomains:"); sb.append(failureDomains + ","); }
    if (folder != null) { sb.append("folder:"); sb.append(folder + ","); }
    if (hosts != null && !hosts.isEmpty()) { sb.append("hosts:"); sb.append(hosts + ","); }
    if (ingressVIP != null) { sb.append("ingressVIP:"); sb.append(ingressVIP + ","); }
    if (ingressVIPs != null && !ingressVIPs.isEmpty()) { sb.append("ingressVIPs:"); sb.append(ingressVIPs + ","); }
    if (loadBalancer != null) { sb.append("loadBalancer:"); sb.append(loadBalancer + ","); }
    if (network != null) { sb.append("network:"); sb.append(network + ","); }
    if (nodeNetworking != null) { sb.append("nodeNetworking:"); sb.append(nodeNetworking + ","); }
    if (password != null) { sb.append("password:"); sb.append(password + ","); }
    if (resourcePool != null) { sb.append("resourcePool:"); sb.append(resourcePool + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (vCenter != null) { sb.append("vCenter:"); sb.append(vCenter + ","); }
    if (vcenters != null && !vcenters.isEmpty()) { sb.append("vcenters:"); sb.append(vcenters + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DefaultMachinePlatformNested<N> extends MachinePoolFluent<DefaultMachinePlatformNested<N>> implements Nested<N>{
    DefaultMachinePlatformNested(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    MachinePoolBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withDefaultMachinePlatform(builder.build());
    }
    
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  
  }
  public class FailureDomainsNested<N> extends FailureDomainFluent<FailureDomainsNested<N>> implements Nested<N>{
    FailureDomainsNested(int index,FailureDomain item) {
      this.index = index;
      this.builder = new FailureDomainBuilder(this, item);
    }
    FailureDomainBuilder builder;
    int index;
    
    public N and() {
      return (N) PlatformFluent.this.setToFailureDomains(index,builder.build());
    }
    
    public N endFailureDomain() {
      return and();
    }
    
  
  }
  public class HostsNested<N> extends HostFluent<HostsNested<N>> implements Nested<N>{
    HostsNested(int index,Host item) {
      this.index = index;
      this.builder = new HostBuilder(this, item);
    }
    HostBuilder builder;
    int index;
    
    public N and() {
      return (N) PlatformFluent.this.setToHosts(index,builder.build());
    }
    
    public N endHost() {
      return and();
    }
    
  
  }
  public class VcentersNested<N> extends VCenterFluent<VcentersNested<N>> implements Nested<N>{
    VcentersNested(int index,VCenter item) {
      this.index = index;
      this.builder = new VCenterBuilder(this, item);
    }
    VCenterBuilder builder;
    int index;
    
    public N and() {
      return (N) PlatformFluent.this.setToVcenters(index,builder.build());
    }
    
    public N endVcenter() {
      return and();
    }
    
  
  }

}