/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.installer.vsphere.v1.NetworkDeviceSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkDeviceSpecFluent<A extends NetworkDeviceSpecFluent<A>>
extends BaseFluent<A> {
    private String gateway;
    private List<String> ipAddrs = new ArrayList<String>();
    private List<String> nameservers = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public NetworkDeviceSpecFluent() {
    }

    public NetworkDeviceSpecFluent(NetworkDeviceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkDeviceSpec instance) {
        NetworkDeviceSpec networkDeviceSpec = instance = instance != null ? instance : new NetworkDeviceSpec();
        if (instance != null) {
            this.withGateway(instance.getGateway());
            this.withIpAddrs(instance.getIpAddrs());
            this.withNameservers(instance.getNameservers());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getGateway() {
        return this.gateway;
    }

    public A withGateway(String gateway) {
        this.gateway = gateway;
        return (A)((Object)this);
    }

    public boolean hasGateway() {
        return this.gateway != null;
    }

    public A addToIpAddrs(int index, String item) {
        if (this.ipAddrs == null) {
            this.ipAddrs = new ArrayList<String>();
        }
        this.ipAddrs.add(index, item);
        return (A)((Object)this);
    }

    public A setToIpAddrs(int index, String item) {
        if (this.ipAddrs == null) {
            this.ipAddrs = new ArrayList<String>();
        }
        this.ipAddrs.set(index, item);
        return (A)((Object)this);
    }

    public A addToIpAddrs(String ... items) {
        if (this.ipAddrs == null) {
            this.ipAddrs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddrs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIpAddrs(Collection<String> items) {
        if (this.ipAddrs == null) {
            this.ipAddrs = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddrs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIpAddrs(String ... items) {
        if (this.ipAddrs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipAddrs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIpAddrs(Collection<String> items) {
        if (this.ipAddrs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.ipAddrs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getIpAddrs() {
        return this.ipAddrs;
    }

    public String getIpAddr(int index) {
        return this.ipAddrs.get(index);
    }

    public String getFirstIpAddr() {
        return this.ipAddrs.get(0);
    }

    public String getLastIpAddr() {
        return this.ipAddrs.get(this.ipAddrs.size() - 1);
    }

    public String getMatchingIpAddr(Predicate<String> predicate) {
        for (String item : this.ipAddrs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIpAddr(Predicate<String> predicate) {
        for (String item : this.ipAddrs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIpAddrs(List<String> ipAddrs) {
        if (ipAddrs != null) {
            this.ipAddrs = new ArrayList<String>();
            for (String item : ipAddrs) {
                this.addToIpAddrs(item);
            }
        } else {
            this.ipAddrs = null;
        }
        return (A)((Object)this);
    }

    public A withIpAddrs(String ... ipAddrs) {
        if (this.ipAddrs != null) {
            this.ipAddrs.clear();
            this._visitables.remove((Object)"ipAddrs");
        }
        if (ipAddrs != null) {
            for (String item : ipAddrs) {
                this.addToIpAddrs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIpAddrs() {
        return this.ipAddrs != null && !this.ipAddrs.isEmpty();
    }

    public A addToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.add(index, item);
        return (A)((Object)this);
    }

    public A setToNameservers(int index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.set(index, item);
        return (A)((Object)this);
    }

    public A addToNameservers(String ... items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromNameservers(String ... items) {
        if (this.nameservers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.nameservers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.nameservers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getNameservers() {
        return this.nameservers;
    }

    public String getNameserver(int index) {
        return this.nameservers.get(index);
    }

    public String getFirstNameserver() {
        return this.nameservers.get(0);
    }

    public String getLastNameserver() {
        return this.nameservers.get(this.nameservers.size() - 1);
    }

    public String getMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNameservers(List<String> nameservers) {
        if (nameservers != null) {
            this.nameservers = new ArrayList<String>();
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        } else {
            this.nameservers = null;
        }
        return (A)((Object)this);
    }

    public A withNameservers(String ... nameservers) {
        if (this.nameservers != null) {
            this.nameservers.clear();
            this._visitables.remove((Object)"nameservers");
        }
        if (nameservers != null) {
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasNameservers() {
        return this.nameservers != null && !this.nameservers.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkDeviceSpecFluent that = (NetworkDeviceSpecFluent)((Object)o);
        if (!Objects.equals(this.gateway, that.gateway)) {
            return false;
        }
        if (!Objects.equals(this.ipAddrs, that.ipAddrs)) {
            return false;
        }
        if (!Objects.equals(this.nameservers, that.nameservers)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.gateway, this.ipAddrs, this.nameservers, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.gateway != null) {
            sb.append("gateway:");
            sb.append(this.gateway + ",");
        }
        if (this.ipAddrs != null && !this.ipAddrs.isEmpty()) {
            sb.append("ipAddrs:");
            sb.append(this.ipAddrs + ",");
        }
        if (this.nameservers != null && !this.nameservers.isEmpty()) {
            sb.append("nameservers:");
            sb.append(this.nameservers + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

