/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.aws.v1.EC2Metadata;
import io.fabric8.openshift.api.model.installer.aws.v1.EC2MetadataBuilder;
import io.fabric8.openshift.api.model.installer.aws.v1.EC2MetadataFluent;
import io.fabric8.openshift.api.model.installer.aws.v1.EC2RootVolume;
import io.fabric8.openshift.api.model.installer.aws.v1.EC2RootVolumeBuilder;
import io.fabric8.openshift.api.model.installer.aws.v1.EC2RootVolumeFluent;
import io.fabric8.openshift.api.model.installer.aws.v1.MachinePool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private List<String> additionalSecurityGroupIDs = new ArrayList<String>();
    private String amiID;
    private String iamProfile;
    private String iamRole;
    private EC2MetadataBuilder metadataService;
    private EC2RootVolumeBuilder rootVolume;
    private String type;
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withAdditionalSecurityGroupIDs(instance.getAdditionalSecurityGroupIDs());
            this.withAmiID(instance.getAmiID());
            this.withIamProfile(instance.getIamProfile());
            this.withIamRole(instance.getIamRole());
            this.withMetadataService(instance.getMetadataService());
            this.withRootVolume(instance.getRootVolume());
            this.withType(instance.getType());
            this.withZones(instance.getZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAdditionalSecurityGroupIDs(int index, String item) {
        if (this.additionalSecurityGroupIDs == null) {
            this.additionalSecurityGroupIDs = new ArrayList<String>();
        }
        this.additionalSecurityGroupIDs.add(index, item);
        return (A)((Object)this);
    }

    public A setToAdditionalSecurityGroupIDs(int index, String item) {
        if (this.additionalSecurityGroupIDs == null) {
            this.additionalSecurityGroupIDs = new ArrayList<String>();
        }
        this.additionalSecurityGroupIDs.set(index, item);
        return (A)((Object)this);
    }

    public A addToAdditionalSecurityGroupIDs(String ... items) {
        if (this.additionalSecurityGroupIDs == null) {
            this.additionalSecurityGroupIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalSecurityGroupIDs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAdditionalSecurityGroupIDs(Collection<String> items) {
        if (this.additionalSecurityGroupIDs == null) {
            this.additionalSecurityGroupIDs = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalSecurityGroupIDs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalSecurityGroupIDs(String ... items) {
        if (this.additionalSecurityGroupIDs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.additionalSecurityGroupIDs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAdditionalSecurityGroupIDs(Collection<String> items) {
        if (this.additionalSecurityGroupIDs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.additionalSecurityGroupIDs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAdditionalSecurityGroupIDs() {
        return this.additionalSecurityGroupIDs;
    }

    public String getAdditionalSecurityGroupID(int index) {
        return this.additionalSecurityGroupIDs.get(index);
    }

    public String getFirstAdditionalSecurityGroupID() {
        return this.additionalSecurityGroupIDs.get(0);
    }

    public String getLastAdditionalSecurityGroupID() {
        return this.additionalSecurityGroupIDs.get(this.additionalSecurityGroupIDs.size() - 1);
    }

    public String getMatchingAdditionalSecurityGroupID(Predicate<String> predicate) {
        for (String item : this.additionalSecurityGroupIDs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAdditionalSecurityGroupID(Predicate<String> predicate) {
        for (String item : this.additionalSecurityGroupIDs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdditionalSecurityGroupIDs(List<String> additionalSecurityGroupIDs) {
        if (additionalSecurityGroupIDs != null) {
            this.additionalSecurityGroupIDs = new ArrayList<String>();
            for (String item : additionalSecurityGroupIDs) {
                this.addToAdditionalSecurityGroupIDs(item);
            }
        } else {
            this.additionalSecurityGroupIDs = null;
        }
        return (A)((Object)this);
    }

    public A withAdditionalSecurityGroupIDs(String ... additionalSecurityGroupIDs) {
        if (this.additionalSecurityGroupIDs != null) {
            this.additionalSecurityGroupIDs.clear();
            this._visitables.remove((Object)"additionalSecurityGroupIDs");
        }
        if (additionalSecurityGroupIDs != null) {
            for (String item : additionalSecurityGroupIDs) {
                this.addToAdditionalSecurityGroupIDs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAdditionalSecurityGroupIDs() {
        return this.additionalSecurityGroupIDs != null && !this.additionalSecurityGroupIDs.isEmpty();
    }

    public String getAmiID() {
        return this.amiID;
    }

    public A withAmiID(String amiID) {
        this.amiID = amiID;
        return (A)((Object)this);
    }

    public boolean hasAmiID() {
        return this.amiID != null;
    }

    public String getIamProfile() {
        return this.iamProfile;
    }

    public A withIamProfile(String iamProfile) {
        this.iamProfile = iamProfile;
        return (A)((Object)this);
    }

    public boolean hasIamProfile() {
        return this.iamProfile != null;
    }

    public String getIamRole() {
        return this.iamRole;
    }

    public A withIamRole(String iamRole) {
        this.iamRole = iamRole;
        return (A)((Object)this);
    }

    public boolean hasIamRole() {
        return this.iamRole != null;
    }

    public EC2Metadata buildMetadataService() {
        return this.metadataService != null ? this.metadataService.build() : null;
    }

    public A withMetadataService(EC2Metadata metadataService) {
        this._visitables.remove((Object)"metadataService");
        if (metadataService != null) {
            this.metadataService = new EC2MetadataBuilder(metadataService);
            this._visitables.get((Object)"metadataService").add(this.metadataService);
        } else {
            this.metadataService = null;
            this._visitables.get((Object)"metadataService").remove((Object)this.metadataService);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadataService() {
        return this.metadataService != null;
    }

    public A withNewMetadataService(String authentication) {
        return this.withMetadataService(new EC2Metadata(authentication));
    }

    public MetadataServiceNested<A> withNewMetadataService() {
        return new MetadataServiceNested(null);
    }

    public MetadataServiceNested<A> withNewMetadataServiceLike(EC2Metadata item) {
        return new MetadataServiceNested(item);
    }

    public MetadataServiceNested<A> editMetadataService() {
        return this.withNewMetadataServiceLike(Optional.ofNullable(this.buildMetadataService()).orElse(null));
    }

    public MetadataServiceNested<A> editOrNewMetadataService() {
        return this.withNewMetadataServiceLike(Optional.ofNullable(this.buildMetadataService()).orElse(new EC2MetadataBuilder().build()));
    }

    public MetadataServiceNested<A> editOrNewMetadataServiceLike(EC2Metadata item) {
        return this.withNewMetadataServiceLike(Optional.ofNullable(this.buildMetadataService()).orElse(item));
    }

    public EC2RootVolume buildRootVolume() {
        return this.rootVolume != null ? this.rootVolume.build() : null;
    }

    public A withRootVolume(EC2RootVolume rootVolume) {
        this._visitables.remove((Object)"rootVolume");
        if (rootVolume != null) {
            this.rootVolume = new EC2RootVolumeBuilder(rootVolume);
            this._visitables.get((Object)"rootVolume").add(this.rootVolume);
        } else {
            this.rootVolume = null;
            this._visitables.get((Object)"rootVolume").remove((Object)this.rootVolume);
        }
        return (A)((Object)this);
    }

    public boolean hasRootVolume() {
        return this.rootVolume != null;
    }

    public A withNewRootVolume(Integer iops, String kmsKeyARN, Integer size, String type) {
        return this.withRootVolume(new EC2RootVolume(iops, kmsKeyARN, size, type));
    }

    public RootVolumeNested<A> withNewRootVolume() {
        return new RootVolumeNested(null);
    }

    public RootVolumeNested<A> withNewRootVolumeLike(EC2RootVolume item) {
        return new RootVolumeNested(item);
    }

    public RootVolumeNested<A> editRootVolume() {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(null));
    }

    public RootVolumeNested<A> editOrNewRootVolume() {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(new EC2RootVolumeBuilder().build()));
    }

    public RootVolumeNested<A> editOrNewRootVolumeLike(EC2RootVolume item) {
        return this.withNewRootVolumeLike(Optional.ofNullable(this.buildRootVolume()).orElse(item));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)((Object)this);
    }

    public A setToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)((Object)this);
    }

    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromZones(String ... items) {
        if (this.zones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromZones(Collection<String> items) {
        if (this.zones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getZones() {
        return this.zones;
    }

    public String getZone(int index) {
        return this.zones.get(index);
    }

    public String getFirstZone() {
        return this.zones.get(0);
    }

    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)((Object)this);
    }

    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
            this._visitables.remove((Object)"zones");
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)((Object)o);
        if (!Objects.equals(this.additionalSecurityGroupIDs, that.additionalSecurityGroupIDs)) {
            return false;
        }
        if (!Objects.equals(this.amiID, that.amiID)) {
            return false;
        }
        if (!Objects.equals(this.iamProfile, that.iamProfile)) {
            return false;
        }
        if (!Objects.equals(this.iamRole, that.iamRole)) {
            return false;
        }
        if (!Objects.equals((Object)this.metadataService, (Object)that.metadataService)) {
            return false;
        }
        if (!Objects.equals((Object)this.rootVolume, (Object)that.rootVolume)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.zones, that.zones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalSecurityGroupIDs, this.amiID, this.iamProfile, this.iamRole, this.metadataService, this.rootVolume, this.type, this.zones, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalSecurityGroupIDs != null && !this.additionalSecurityGroupIDs.isEmpty()) {
            sb.append("additionalSecurityGroupIDs:");
            sb.append(String.valueOf(this.additionalSecurityGroupIDs) + ",");
        }
        if (this.amiID != null) {
            sb.append("amiID:");
            sb.append(this.amiID + ",");
        }
        if (this.iamProfile != null) {
            sb.append("iamProfile:");
            sb.append(this.iamProfile + ",");
        }
        if (this.iamRole != null) {
            sb.append("iamRole:");
            sb.append(this.iamRole + ",");
        }
        if (this.metadataService != null) {
            sb.append("metadataService:");
            sb.append(String.valueOf((Object)this.metadataService) + ",");
        }
        if (this.rootVolume != null) {
            sb.append("rootVolume:");
            sb.append(String.valueOf((Object)this.rootVolume) + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(String.valueOf(this.zones) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RootVolumeNested<N>
    extends EC2RootVolumeFluent<RootVolumeNested<N>>
    implements Nested<N> {
        EC2RootVolumeBuilder builder;

        RootVolumeNested(EC2RootVolume item) {
            this.builder = new EC2RootVolumeBuilder(this, item);
        }

        public N and() {
            return (N)MachinePoolFluent.this.withRootVolume(this.builder.build());
        }

        public N endRootVolume() {
            return this.and();
        }
    }

    public class MetadataServiceNested<N>
    extends EC2MetadataFluent<MetadataServiceNested<N>>
    implements Nested<N> {
        EC2MetadataBuilder builder;

        MetadataServiceNested(EC2Metadata item) {
            this.builder = new EC2MetadataBuilder(this, item);
        }

        public N and() {
            return (N)MachinePoolFluent.this.withMetadataService(this.builder.build());
        }

        public N endMetadataService() {
            return this.and();
        }
    }
}

