package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SubnetBuilder extends SubnetFluent<SubnetBuilder> implements VisitableBuilder<Subnet,SubnetBuilder>{
  public SubnetBuilder() {
    this(new Subnet());
  }
  
  public SubnetBuilder(SubnetFluent<?> fluent) {
    this(fluent, new Subnet());
  }
  
  public SubnetBuilder(SubnetFluent<?> fluent,Subnet instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SubnetBuilder(Subnet instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SubnetFluent<?> fluent;
  
  public Subnet build() {
    Subnet buildable = new Subnet(fluent.getId(),fluent.buildRoles());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}