package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SubnetFluent<A extends SubnetFluent<A>> extends BaseFluent<A>{
  public SubnetFluent() {
  }
  
  public SubnetFluent(Subnet instance) {
    this.copyInstance(instance);
  }
  private String id;
  private ArrayList<SubnetRoleBuilder> roles = new ArrayList<SubnetRoleBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Subnet instance) {
    instance = (instance != null ? instance : new Subnet());
    if (instance != null) {
          this.withId(instance.getId());
          this.withRoles(instance.getRoles());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getId() {
    return this.id;
  }
  
  public A withId(String id) {
    this.id = id;
    return (A) this;
  }
  
  public boolean hasId() {
    return this.id != null;
  }
  
  public A addToRoles(int index,SubnetRole item) {
    if (this.roles == null) {this.roles = new ArrayList<SubnetRoleBuilder>();}
    SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
    if (index < 0 || index >= roles.size()) {
        _visitables.get("roles").add(builder);
        roles.add(builder);
    } else {
        _visitables.get("roles").add(builder);
        roles.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToRoles(int index,SubnetRole item) {
    if (this.roles == null) {this.roles = new ArrayList<SubnetRoleBuilder>();}
    SubnetRoleBuilder builder = new SubnetRoleBuilder(item);
    if (index < 0 || index >= roles.size()) {
        _visitables.get("roles").add(builder);
        roles.add(builder);
    } else {
        _visitables.get("roles").add(builder);
        roles.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToRoles(io.fabric8.openshift.api.model.installer.aws.v1.SubnetRole... items) {
    if (this.roles == null) {this.roles = new ArrayList<SubnetRoleBuilder>();}
    for (SubnetRole item : items) {SubnetRoleBuilder builder = new SubnetRoleBuilder(item);_visitables.get("roles").add(builder);this.roles.add(builder);} return (A)this;
  }
  
  public A addAllToRoles(Collection<SubnetRole> items) {
    if (this.roles == null) {this.roles = new ArrayList<SubnetRoleBuilder>();}
    for (SubnetRole item : items) {SubnetRoleBuilder builder = new SubnetRoleBuilder(item);_visitables.get("roles").add(builder);this.roles.add(builder);} return (A)this;
  }
  
  public A removeFromRoles(io.fabric8.openshift.api.model.installer.aws.v1.SubnetRole... items) {
    if (this.roles == null) return (A)this;
    for (SubnetRole item : items) {SubnetRoleBuilder builder = new SubnetRoleBuilder(item);_visitables.get("roles").remove(builder); this.roles.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRoles(Collection<SubnetRole> items) {
    if (this.roles == null) return (A)this;
    for (SubnetRole item : items) {SubnetRoleBuilder builder = new SubnetRoleBuilder(item);_visitables.get("roles").remove(builder); this.roles.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRoles(Predicate<SubnetRoleBuilder> predicate) {
    if (roles == null) return (A) this;
    final Iterator<SubnetRoleBuilder> each = roles.iterator();
    final List visitables = _visitables.get("roles");
    while (each.hasNext()) {
      SubnetRoleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SubnetRole> buildRoles() {
    return this.roles != null ? build(roles) : null;
  }
  
  public SubnetRole buildRole(int index) {
    return this.roles.get(index).build();
  }
  
  public SubnetRole buildFirstRole() {
    return this.roles.get(0).build();
  }
  
  public SubnetRole buildLastRole() {
    return this.roles.get(roles.size() - 1).build();
  }
  
  public SubnetRole buildMatchingRole(Predicate<SubnetRoleBuilder> predicate) {
      for (SubnetRoleBuilder item : roles) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRole(Predicate<SubnetRoleBuilder> predicate) {
      for (SubnetRoleBuilder item : roles) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRoles(List<SubnetRole> roles) {
    if (this.roles != null) {
      this._visitables.get("roles").clear();
    }
    if (roles != null) {
        this.roles = new ArrayList();
        for (SubnetRole item : roles) {
          this.addToRoles(item);
        }
    } else {
      this.roles = null;
    }
    return (A) this;
  }
  
  public A withRoles(io.fabric8.openshift.api.model.installer.aws.v1.SubnetRole... roles) {
    if (this.roles != null) {
        this.roles.clear();
        _visitables.remove("roles");
    }
    if (roles != null) {
      for (SubnetRole item : roles) {
        this.addToRoles(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRoles() {
    return this.roles != null && !this.roles.isEmpty();
  }
  
  public A addNewRole(String type) {
    return (A)addToRoles(new SubnetRole(type));
  }
  
  public RolesNested<A> addNewRole() {
    return new RolesNested(-1, null);
  }
  
  public RolesNested<A> addNewRoleLike(SubnetRole item) {
    return new RolesNested(-1, item);
  }
  
  public RolesNested<A> setNewRoleLike(int index,SubnetRole item) {
    return new RolesNested(index, item);
  }
  
  public RolesNested<A> editRole(int index) {
    if (roles.size() <= index) throw new RuntimeException("Can't edit roles. Index exceeds size.");
    return setNewRoleLike(index, buildRole(index));
  }
  
  public RolesNested<A> editFirstRole() {
    if (roles.size() == 0) throw new RuntimeException("Can't edit first roles. The list is empty.");
    return setNewRoleLike(0, buildRole(0));
  }
  
  public RolesNested<A> editLastRole() {
    int index = roles.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last roles. The list is empty.");
    return setNewRoleLike(index, buildRole(index));
  }
  
  public RolesNested<A> editMatchingRole(Predicate<SubnetRoleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<roles.size();i++) { 
    if (predicate.test(roles.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching roles. No match found.");
    return setNewRoleLike(index, buildRole(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SubnetFluent that = (SubnetFluent) o;
    if (!java.util.Objects.equals(id, that.id)) return false;
    if (!java.util.Objects.equals(roles, that.roles)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(id,  roles,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (roles != null && !roles.isEmpty()) { sb.append("roles:"); sb.append(roles + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RolesNested<N> extends SubnetRoleFluent<RolesNested<N>> implements Nested<N>{
    RolesNested(int index,SubnetRole item) {
      this.index = index;
      this.builder = new SubnetRoleBuilder(this, item);
    }
    SubnetRoleBuilder builder;
    int index;
    
    public N and() {
      return (N) SubnetFluent.this.setToRoles(index,builder.build());
    }
    
    public N endRole() {
      return and();
    }
    
  
  }

}