package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SubnetRoleBuilder extends SubnetRoleFluent<SubnetRoleBuilder> implements VisitableBuilder<SubnetRole,SubnetRoleBuilder>{
  public SubnetRoleBuilder() {
    this(new SubnetRole());
  }
  
  public SubnetRoleBuilder(SubnetRoleFluent<?> fluent) {
    this(fluent, new SubnetRole());
  }
  
  public SubnetRoleBuilder(SubnetRoleFluent<?> fluent,SubnetRole instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SubnetRoleBuilder(SubnetRole instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SubnetRoleFluent<?> fluent;
  
  public SubnetRole build() {
    SubnetRole buildable = new SubnetRole(fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}