package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VPCBuilder extends VPCFluent<VPCBuilder> implements VisitableBuilder<VPC,VPCBuilder>{
  public VPCBuilder() {
    this(new VPC());
  }
  
  public VPCBuilder(VPCFluent<?> fluent) {
    this(fluent, new VPC());
  }
  
  public VPCBuilder(VPCFluent<?> fluent,VPC instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VPCBuilder(VPC instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VPCFluent<?> fluent;
  
  public VPC build() {
    VPC buildable = new VPC(fluent.buildSubnets());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}