package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VPCFluent<A extends VPCFluent<A>> extends BaseFluent<A>{
  public VPCFluent() {
  }
  
  public VPCFluent(VPC instance) {
    this.copyInstance(instance);
  }
  private ArrayList<SubnetBuilder> subnets = new ArrayList<SubnetBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VPC instance) {
    instance = (instance != null ? instance : new VPC());
    if (instance != null) {
          this.withSubnets(instance.getSubnets());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToSubnets(int index,Subnet item) {
    if (this.subnets == null) {this.subnets = new ArrayList<SubnetBuilder>();}
    SubnetBuilder builder = new SubnetBuilder(item);
    if (index < 0 || index >= subnets.size()) {
        _visitables.get("subnets").add(builder);
        subnets.add(builder);
    } else {
        _visitables.get("subnets").add(builder);
        subnets.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToSubnets(int index,Subnet item) {
    if (this.subnets == null) {this.subnets = new ArrayList<SubnetBuilder>();}
    SubnetBuilder builder = new SubnetBuilder(item);
    if (index < 0 || index >= subnets.size()) {
        _visitables.get("subnets").add(builder);
        subnets.add(builder);
    } else {
        _visitables.get("subnets").add(builder);
        subnets.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToSubnets(io.fabric8.openshift.api.model.installer.aws.v1.Subnet... items) {
    if (this.subnets == null) {this.subnets = new ArrayList<SubnetBuilder>();}
    for (Subnet item : items) {SubnetBuilder builder = new SubnetBuilder(item);_visitables.get("subnets").add(builder);this.subnets.add(builder);} return (A)this;
  }
  
  public A addAllToSubnets(Collection<Subnet> items) {
    if (this.subnets == null) {this.subnets = new ArrayList<SubnetBuilder>();}
    for (Subnet item : items) {SubnetBuilder builder = new SubnetBuilder(item);_visitables.get("subnets").add(builder);this.subnets.add(builder);} return (A)this;
  }
  
  public A removeFromSubnets(io.fabric8.openshift.api.model.installer.aws.v1.Subnet... items) {
    if (this.subnets == null) return (A)this;
    for (Subnet item : items) {SubnetBuilder builder = new SubnetBuilder(item);_visitables.get("subnets").remove(builder); this.subnets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSubnets(Collection<Subnet> items) {
    if (this.subnets == null) return (A)this;
    for (Subnet item : items) {SubnetBuilder builder = new SubnetBuilder(item);_visitables.get("subnets").remove(builder); this.subnets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSubnets(Predicate<SubnetBuilder> predicate) {
    if (subnets == null) return (A) this;
    final Iterator<SubnetBuilder> each = subnets.iterator();
    final List visitables = _visitables.get("subnets");
    while (each.hasNext()) {
      SubnetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Subnet> buildSubnets() {
    return this.subnets != null ? build(subnets) : null;
  }
  
  public Subnet buildSubnet(int index) {
    return this.subnets.get(index).build();
  }
  
  public Subnet buildFirstSubnet() {
    return this.subnets.get(0).build();
  }
  
  public Subnet buildLastSubnet() {
    return this.subnets.get(subnets.size() - 1).build();
  }
  
  public Subnet buildMatchingSubnet(Predicate<SubnetBuilder> predicate) {
      for (SubnetBuilder item : subnets) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSubnet(Predicate<SubnetBuilder> predicate) {
      for (SubnetBuilder item : subnets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSubnets(List<Subnet> subnets) {
    if (this.subnets != null) {
      this._visitables.get("subnets").clear();
    }
    if (subnets != null) {
        this.subnets = new ArrayList();
        for (Subnet item : subnets) {
          this.addToSubnets(item);
        }
    } else {
      this.subnets = null;
    }
    return (A) this;
  }
  
  public A withSubnets(io.fabric8.openshift.api.model.installer.aws.v1.Subnet... subnets) {
    if (this.subnets != null) {
        this.subnets.clear();
        _visitables.remove("subnets");
    }
    if (subnets != null) {
      for (Subnet item : subnets) {
        this.addToSubnets(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSubnets() {
    return this.subnets != null && !this.subnets.isEmpty();
  }
  
  public SubnetsNested<A> addNewSubnet() {
    return new SubnetsNested(-1, null);
  }
  
  public SubnetsNested<A> addNewSubnetLike(Subnet item) {
    return new SubnetsNested(-1, item);
  }
  
  public SubnetsNested<A> setNewSubnetLike(int index,Subnet item) {
    return new SubnetsNested(index, item);
  }
  
  public SubnetsNested<A> editSubnet(int index) {
    if (subnets.size() <= index) throw new RuntimeException("Can't edit subnets. Index exceeds size.");
    return setNewSubnetLike(index, buildSubnet(index));
  }
  
  public SubnetsNested<A> editFirstSubnet() {
    if (subnets.size() == 0) throw new RuntimeException("Can't edit first subnets. The list is empty.");
    return setNewSubnetLike(0, buildSubnet(0));
  }
  
  public SubnetsNested<A> editLastSubnet() {
    int index = subnets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subnets. The list is empty.");
    return setNewSubnetLike(index, buildSubnet(index));
  }
  
  public SubnetsNested<A> editMatchingSubnet(Predicate<SubnetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subnets.size();i++) { 
    if (predicate.test(subnets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subnets. No match found.");
    return setNewSubnetLike(index, buildSubnet(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VPCFluent that = (VPCFluent) o;
    if (!java.util.Objects.equals(subnets, that.subnets)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(subnets,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (subnets != null && !subnets.isEmpty()) { sb.append("subnets:"); sb.append(subnets + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SubnetsNested<N> extends SubnetFluent<SubnetsNested<N>> implements Nested<N>{
    SubnetsNested(int index,Subnet item) {
      this.index = index;
      this.builder = new SubnetBuilder(this, item);
    }
    SubnetBuilder builder;
    int index;
    
    public N and() {
      return (N) VPCFluent.this.setToSubnets(index,builder.build());
    }
    
    public N endSubnet() {
      return and();
    }
    
  
  }

}