package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BootDiagnosticsBuilder extends BootDiagnosticsFluent<BootDiagnosticsBuilder> implements VisitableBuilder<BootDiagnostics,BootDiagnosticsBuilder>{
  public BootDiagnosticsBuilder() {
    this(new BootDiagnostics());
  }
  
  public BootDiagnosticsBuilder(BootDiagnosticsFluent<?> fluent) {
    this(fluent, new BootDiagnostics());
  }
  
  public BootDiagnosticsBuilder(BootDiagnosticsFluent<?> fluent,BootDiagnostics instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BootDiagnosticsBuilder(BootDiagnostics instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BootDiagnosticsFluent<?> fluent;
  
  public BootDiagnostics build() {
    BootDiagnostics buildable = new BootDiagnostics(fluent.getResourceGroup(),fluent.getStorageAccountName(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}