package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KeyVaultBuilder extends KeyVaultFluent<KeyVaultBuilder> implements VisitableBuilder<KeyVault,KeyVaultBuilder>{
  public KeyVaultBuilder() {
    this(new KeyVault());
  }
  
  public KeyVaultBuilder(KeyVaultFluent<?> fluent) {
    this(fluent, new KeyVault());
  }
  
  public KeyVaultBuilder(KeyVaultFluent<?> fluent,KeyVault instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KeyVaultBuilder(KeyVault instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KeyVaultFluent<?> fluent;
  
  public KeyVault build() {
    KeyVault buildable = new KeyVault(fluent.getKeyName(),fluent.getName(),fluent.getResourceGroup());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}