package io.fabric8.openshift.api.model.installer.azure.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TrustedLaunchFluent<A extends TrustedLaunchFluent<A>> extends BaseFluent<A>{
  public TrustedLaunchFluent() {
  }
  
  public TrustedLaunchFluent(TrustedLaunch instance) {
    this.copyInstance(instance);
  }
  private UEFISettingsBuilder uefiSettings;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TrustedLaunch instance) {
    instance = (instance != null ? instance : new TrustedLaunch());
    if (instance != null) {
          this.withUefiSettings(instance.getUefiSettings());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public UEFISettings buildUefiSettings() {
    return this.uefiSettings != null ? this.uefiSettings.build() : null;
  }
  
  public A withUefiSettings(UEFISettings uefiSettings) {
    this._visitables.remove("uefiSettings");
    if (uefiSettings != null) {
        this.uefiSettings = new UEFISettingsBuilder(uefiSettings);
        this._visitables.get("uefiSettings").add(this.uefiSettings);
    } else {
        this.uefiSettings = null;
        this._visitables.get("uefiSettings").remove(this.uefiSettings);
    }
    return (A) this;
  }
  
  public boolean hasUefiSettings() {
    return this.uefiSettings != null;
  }
  
  public A withNewUefiSettings(String secureBoot,String virtualizedTrustedPlatformModule) {
    return (A)withUefiSettings(new UEFISettings(secureBoot, virtualizedTrustedPlatformModule));
  }
  
  public UefiSettingsNested<A> withNewUefiSettings() {
    return new UefiSettingsNested(null);
  }
  
  public UefiSettingsNested<A> withNewUefiSettingsLike(UEFISettings item) {
    return new UefiSettingsNested(item);
  }
  
  public UefiSettingsNested<A> editUefiSettings() {
    return withNewUefiSettingsLike(java.util.Optional.ofNullable(buildUefiSettings()).orElse(null));
  }
  
  public UefiSettingsNested<A> editOrNewUefiSettings() {
    return withNewUefiSettingsLike(java.util.Optional.ofNullable(buildUefiSettings()).orElse(new UEFISettingsBuilder().build()));
  }
  
  public UefiSettingsNested<A> editOrNewUefiSettingsLike(UEFISettings item) {
    return withNewUefiSettingsLike(java.util.Optional.ofNullable(buildUefiSettings()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TrustedLaunchFluent that = (TrustedLaunchFluent) o;
    if (!java.util.Objects.equals(uefiSettings, that.uefiSettings)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(uefiSettings,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (uefiSettings != null) { sb.append("uefiSettings:"); sb.append(uefiSettings + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class UefiSettingsNested<N> extends UEFISettingsFluent<UefiSettingsNested<N>> implements Nested<N>{
    UefiSettingsNested(UEFISettings item) {
      this.builder = new UEFISettingsBuilder(this, item);
    }
    UEFISettingsBuilder builder;
    
    public N and() {
      return (N) TrustedLaunchFluent.this.withUefiSettings(builder.build());
    }
    
    public N endUefiSettings() {
      return and();
    }
    
  
  }

}