package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VMIdentityBuilder extends VMIdentityFluent<VMIdentityBuilder> implements VisitableBuilder<VMIdentity,VMIdentityBuilder>{
  public VMIdentityBuilder() {
    this(new VMIdentity());
  }
  
  public VMIdentityBuilder(VMIdentityFluent<?> fluent) {
    this(fluent, new VMIdentity());
  }
  
  public VMIdentityBuilder(VMIdentityFluent<?> fluent,VMIdentity instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VMIdentityBuilder(VMIdentity instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VMIdentityFluent<?> fluent;
  
  public VMIdentity build() {
    VMIdentity buildable = new VMIdentity(fluent.getType(),fluent.buildUserAssignedIdentities());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}