package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VMIdentityFluent<A extends VMIdentityFluent<A>> extends BaseFluent<A>{
  public VMIdentityFluent() {
  }
  
  public VMIdentityFluent(VMIdentity instance) {
    this.copyInstance(instance);
  }
  private String type;
  private ArrayList<UserAssignedIdentityBuilder> userAssignedIdentities = new ArrayList<UserAssignedIdentityBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VMIdentity instance) {
    instance = (instance != null ? instance : new VMIdentity());
    if (instance != null) {
          this.withType(instance.getType());
          this.withUserAssignedIdentities(instance.getUserAssignedIdentities());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToUserAssignedIdentities(int index,UserAssignedIdentity item) {
    if (this.userAssignedIdentities == null) {this.userAssignedIdentities = new ArrayList<UserAssignedIdentityBuilder>();}
    UserAssignedIdentityBuilder builder = new UserAssignedIdentityBuilder(item);
    if (index < 0 || index >= userAssignedIdentities.size()) {
        _visitables.get("userAssignedIdentities").add(builder);
        userAssignedIdentities.add(builder);
    } else {
        _visitables.get("userAssignedIdentities").add(builder);
        userAssignedIdentities.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToUserAssignedIdentities(int index,UserAssignedIdentity item) {
    if (this.userAssignedIdentities == null) {this.userAssignedIdentities = new ArrayList<UserAssignedIdentityBuilder>();}
    UserAssignedIdentityBuilder builder = new UserAssignedIdentityBuilder(item);
    if (index < 0 || index >= userAssignedIdentities.size()) {
        _visitables.get("userAssignedIdentities").add(builder);
        userAssignedIdentities.add(builder);
    } else {
        _visitables.get("userAssignedIdentities").add(builder);
        userAssignedIdentities.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToUserAssignedIdentities(io.fabric8.openshift.api.model.installer.azure.v1.UserAssignedIdentity... items) {
    if (this.userAssignedIdentities == null) {this.userAssignedIdentities = new ArrayList<UserAssignedIdentityBuilder>();}
    for (UserAssignedIdentity item : items) {UserAssignedIdentityBuilder builder = new UserAssignedIdentityBuilder(item);_visitables.get("userAssignedIdentities").add(builder);this.userAssignedIdentities.add(builder);} return (A)this;
  }
  
  public A addAllToUserAssignedIdentities(Collection<UserAssignedIdentity> items) {
    if (this.userAssignedIdentities == null) {this.userAssignedIdentities = new ArrayList<UserAssignedIdentityBuilder>();}
    for (UserAssignedIdentity item : items) {UserAssignedIdentityBuilder builder = new UserAssignedIdentityBuilder(item);_visitables.get("userAssignedIdentities").add(builder);this.userAssignedIdentities.add(builder);} return (A)this;
  }
  
  public A removeFromUserAssignedIdentities(io.fabric8.openshift.api.model.installer.azure.v1.UserAssignedIdentity... items) {
    if (this.userAssignedIdentities == null) return (A)this;
    for (UserAssignedIdentity item : items) {UserAssignedIdentityBuilder builder = new UserAssignedIdentityBuilder(item);_visitables.get("userAssignedIdentities").remove(builder); this.userAssignedIdentities.remove(builder);} return (A)this;
  }
  
  public A removeAllFromUserAssignedIdentities(Collection<UserAssignedIdentity> items) {
    if (this.userAssignedIdentities == null) return (A)this;
    for (UserAssignedIdentity item : items) {UserAssignedIdentityBuilder builder = new UserAssignedIdentityBuilder(item);_visitables.get("userAssignedIdentities").remove(builder); this.userAssignedIdentities.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromUserAssignedIdentities(Predicate<UserAssignedIdentityBuilder> predicate) {
    if (userAssignedIdentities == null) return (A) this;
    final Iterator<UserAssignedIdentityBuilder> each = userAssignedIdentities.iterator();
    final List visitables = _visitables.get("userAssignedIdentities");
    while (each.hasNext()) {
      UserAssignedIdentityBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<UserAssignedIdentity> buildUserAssignedIdentities() {
    return this.userAssignedIdentities != null ? build(userAssignedIdentities) : null;
  }
  
  public UserAssignedIdentity buildUserAssignedIdentity(int index) {
    return this.userAssignedIdentities.get(index).build();
  }
  
  public UserAssignedIdentity buildFirstUserAssignedIdentity() {
    return this.userAssignedIdentities.get(0).build();
  }
  
  public UserAssignedIdentity buildLastUserAssignedIdentity() {
    return this.userAssignedIdentities.get(userAssignedIdentities.size() - 1).build();
  }
  
  public UserAssignedIdentity buildMatchingUserAssignedIdentity(Predicate<UserAssignedIdentityBuilder> predicate) {
      for (UserAssignedIdentityBuilder item : userAssignedIdentities) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingUserAssignedIdentity(Predicate<UserAssignedIdentityBuilder> predicate) {
      for (UserAssignedIdentityBuilder item : userAssignedIdentities) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withUserAssignedIdentities(List<UserAssignedIdentity> userAssignedIdentities) {
    if (this.userAssignedIdentities != null) {
      this._visitables.get("userAssignedIdentities").clear();
    }
    if (userAssignedIdentities != null) {
        this.userAssignedIdentities = new ArrayList();
        for (UserAssignedIdentity item : userAssignedIdentities) {
          this.addToUserAssignedIdentities(item);
        }
    } else {
      this.userAssignedIdentities = null;
    }
    return (A) this;
  }
  
  public A withUserAssignedIdentities(io.fabric8.openshift.api.model.installer.azure.v1.UserAssignedIdentity... userAssignedIdentities) {
    if (this.userAssignedIdentities != null) {
        this.userAssignedIdentities.clear();
        _visitables.remove("userAssignedIdentities");
    }
    if (userAssignedIdentities != null) {
      for (UserAssignedIdentity item : userAssignedIdentities) {
        this.addToUserAssignedIdentities(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasUserAssignedIdentities() {
    return this.userAssignedIdentities != null && !this.userAssignedIdentities.isEmpty();
  }
  
  public A addNewUserAssignedIdentity(String name,String resourceGroup,String subscription) {
    return (A)addToUserAssignedIdentities(new UserAssignedIdentity(name, resourceGroup, subscription));
  }
  
  public UserAssignedIdentitiesNested<A> addNewUserAssignedIdentity() {
    return new UserAssignedIdentitiesNested(-1, null);
  }
  
  public UserAssignedIdentitiesNested<A> addNewUserAssignedIdentityLike(UserAssignedIdentity item) {
    return new UserAssignedIdentitiesNested(-1, item);
  }
  
  public UserAssignedIdentitiesNested<A> setNewUserAssignedIdentityLike(int index,UserAssignedIdentity item) {
    return new UserAssignedIdentitiesNested(index, item);
  }
  
  public UserAssignedIdentitiesNested<A> editUserAssignedIdentity(int index) {
    if (userAssignedIdentities.size() <= index) throw new RuntimeException("Can't edit userAssignedIdentities. Index exceeds size.");
    return setNewUserAssignedIdentityLike(index, buildUserAssignedIdentity(index));
  }
  
  public UserAssignedIdentitiesNested<A> editFirstUserAssignedIdentity() {
    if (userAssignedIdentities.size() == 0) throw new RuntimeException("Can't edit first userAssignedIdentities. The list is empty.");
    return setNewUserAssignedIdentityLike(0, buildUserAssignedIdentity(0));
  }
  
  public UserAssignedIdentitiesNested<A> editLastUserAssignedIdentity() {
    int index = userAssignedIdentities.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last userAssignedIdentities. The list is empty.");
    return setNewUserAssignedIdentityLike(index, buildUserAssignedIdentity(index));
  }
  
  public UserAssignedIdentitiesNested<A> editMatchingUserAssignedIdentity(Predicate<UserAssignedIdentityBuilder> predicate) {
    int index = -1;
    for (int i=0;i<userAssignedIdentities.size();i++) { 
    if (predicate.test(userAssignedIdentities.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching userAssignedIdentities. No match found.");
    return setNewUserAssignedIdentityLike(index, buildUserAssignedIdentity(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VMIdentityFluent that = (VMIdentityFluent) o;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(userAssignedIdentities, that.userAssignedIdentities)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(type,  userAssignedIdentities,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (userAssignedIdentities != null && !userAssignedIdentities.isEmpty()) { sb.append("userAssignedIdentities:"); sb.append(userAssignedIdentities + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class UserAssignedIdentitiesNested<N> extends UserAssignedIdentityFluent<UserAssignedIdentitiesNested<N>> implements Nested<N>{
    UserAssignedIdentitiesNested(int index,UserAssignedIdentity item) {
      this.index = index;
      this.builder = new UserAssignedIdentityBuilder(this, item);
    }
    UserAssignedIdentityBuilder builder;
    int index;
    
    public N and() {
      return (N) VMIdentityFluent.this.setToUserAssignedIdentities(index,builder.build());
    }
    
    public N endUserAssignedIdentity() {
      return and();
    }
    
  
  }

}