package io.fabric8.openshift.api.model.installer.baremetal.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MetadataFluent<A extends MetadataFluent<A>> extends BaseFluent<A>{
  public MetadataFluent() {
  }
  
  public MetadataFluent(Metadata instance) {
    this.copyInstance(instance);
  }
  private String bootstrapProvisioningIP;
  private String libvirtURI;
  private String provisioningHostIP;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Metadata instance) {
    instance = (instance != null ? instance : new Metadata());
    if (instance != null) {
          this.withBootstrapProvisioningIP(instance.getBootstrapProvisioningIP());
          this.withLibvirtURI(instance.getLibvirtURI());
          this.withProvisioningHostIP(instance.getProvisioningHostIP());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBootstrapProvisioningIP() {
    return this.bootstrapProvisioningIP;
  }
  
  public A withBootstrapProvisioningIP(String bootstrapProvisioningIP) {
    this.bootstrapProvisioningIP = bootstrapProvisioningIP;
    return (A) this;
  }
  
  public boolean hasBootstrapProvisioningIP() {
    return this.bootstrapProvisioningIP != null;
  }
  
  public String getLibvirtURI() {
    return this.libvirtURI;
  }
  
  public A withLibvirtURI(String libvirtURI) {
    this.libvirtURI = libvirtURI;
    return (A) this;
  }
  
  public boolean hasLibvirtURI() {
    return this.libvirtURI != null;
  }
  
  public String getProvisioningHostIP() {
    return this.provisioningHostIP;
  }
  
  public A withProvisioningHostIP(String provisioningHostIP) {
    this.provisioningHostIP = provisioningHostIP;
    return (A) this;
  }
  
  public boolean hasProvisioningHostIP() {
    return this.provisioningHostIP != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MetadataFluent that = (MetadataFluent) o;
    if (!java.util.Objects.equals(bootstrapProvisioningIP, that.bootstrapProvisioningIP)) return false;
    if (!java.util.Objects.equals(libvirtURI, that.libvirtURI)) return false;
    if (!java.util.Objects.equals(provisioningHostIP, that.provisioningHostIP)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bootstrapProvisioningIP,  libvirtURI,  provisioningHostIP,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootstrapProvisioningIP != null) { sb.append("bootstrapProvisioningIP:"); sb.append(bootstrapProvisioningIP + ","); }
    if (libvirtURI != null) { sb.append("libvirtURI:"); sb.append(libvirtURI + ","); }
    if (provisioningHostIP != null) { sb.append("provisioningHostIP:"); sb.append(provisioningHostIP + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}